/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.operation;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.UserMessage;
import java.io.InputStream;
import java.util.HashMap;
import org.json.JSONObject;
import org.mule.extension.mulechain.api.metadata.LLMResponseAttributes;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.error.MuleChainErrorType;
import org.mule.extension.mulechain.internal.error.provider.AiServiceErrorTypeProvider;
import org.mule.extension.mulechain.internal.helpers.ResponseHelper;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.fixed.OutputJsonType;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangchainLLMOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(LangchainLLMOperations.class);

    @MediaType(value="application/json", strict=false)
    @Alias(value="CHAT-answer-prompt")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> answerPromptByModelName(@Config LangchainLLMConfiguration configuration, @Content String prompt) {
        try {
            LOGGER.debug("Chat Answer Prompt Operation called with prompt: {}", (Object)prompt);
            ChatLanguageModel model = configuration.getModel();
            Assistant assistant = (Assistant)AiServices.create(Assistant.class, (ChatLanguageModel)model);
            dev.langchain4j.service.Result<String> answer = assistant.chat(prompt);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", answer.content());
            LOGGER.debug("Chat Answer Prompt Operation completed with response: {}", answer.content());
            return ResponseHelper.createLLMResponse(jsonObject.toString(), answer, new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ModuleException("Unable to respond with the chat provided", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="AGENT-define-prompt-template")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> definePromptTemplate(@Config LangchainLLMConfiguration configuration, @Content(primary=true) String dataset, @Content String template, @Content String instructions) {
        try {
            LOGGER.debug("Agent Define Prompt Template Operation called with prompt: {}, template: {} & instruction: {}", new Object[]{dataset, template, instructions});
            ChatLanguageModel model = configuration.getModel();
            PromptTemplate promptTemplate = PromptTemplate.from((String)(template + System.lineSeparator() + "Instructions: {{instructions}}" + System.lineSeparator() + "Dataset: {{dataset}}"));
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("instructions", instructions);
            variables.put("dataset", dataset);
            Prompt prompt = promptTemplate.apply(variables);
            Assistant assistant = (Assistant)AiServices.create(Assistant.class, (ChatLanguageModel)model);
            dev.langchain4j.service.Result<String> answer = assistant.chat(prompt.text());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", answer.content());
            LOGGER.debug("Agent Define Prompt Template Operation completed with response: {}", answer.content());
            return ResponseHelper.createLLMResponse(jsonObject.toString(), answer, new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new ModuleException("Unable to reply with the correct prompt template", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    @MediaType(value="application/json", strict=false)
    @Alias(value="SENTIMENT-analyze")
    @Throws(value={AiServiceErrorTypeProvider.class})
    @OutputJsonType(schema="api/response/Response.json")
    public Result<InputStream, LLMResponseAttributes> extractSentiments(@Config LangchainLLMConfiguration configuration, @Content String data) {
        try {
            LOGGER.debug("Sentiment Analyze Operation called with data: {}", (Object)data);
            ChatLanguageModel model = configuration.getModel();
            SentimentAnalyzer sentimentAnalyzer = (SentimentAnalyzer)AiServices.create(SentimentAnalyzer.class, (ChatLanguageModel)model);
            dev.langchain4j.service.Result<Sentiment> sentiment = sentimentAnalyzer.analyzeSentimentOf(data);
            LOGGER.debug("Sentiment Analyze Operation completed with Analyzed sentiment: {}", sentiment);
            boolean positive = sentimentAnalyzer.isPositive(data);
            LOGGER.debug("Is sentiment positive: {}", (Object)positive);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("response", sentiment.content());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("isPositive", String.valueOf(positive));
            return ResponseHelper.createLLMResponse(jsonObject.toString(), sentiment, attributes);
        }
        catch (Exception e) {
            throw new ModuleException("Unable to provide the correct sentiments", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    static interface SentimentAnalyzer {
        @UserMessage(value={"Analyze sentiment of {{it}}"})
        public dev.langchain4j.service.Result<Sentiment> analyzeSentimentOf(String var1);

        @UserMessage(value={"Does {{it}} have a positive sentiment?"})
        public boolean isPositive(String var1);
    }

    static enum Sentiment {
        POSITIVE,
        NEUTRAL,
        NEGATIVE;

    }

    static interface Assistant {
        public dev.langchain4j.service.Result<String> chat(String var1);
    }
}

