/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.operation;

import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.service.AiServices;
import dev.langchain4j.service.TokenStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.mule.extension.mulechain.internal.config.LangchainLLMConfiguration;
import org.mule.extension.mulechain.internal.error.MuleChainErrorType;
import org.mule.extension.mulechain.internal.error.provider.AiServiceErrorTypeProvider;
import org.mule.extension.mulechain.internal.util.ExcludeFromGeneratedCoverage;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

@ExcludeFromGeneratedCoverage
public class LangchainStreamingOperations {
    @MediaType(value="*/*", strict=false)
    @Alias(value="CHAT-answer-prompt-w-stream")
    @Throws(value={AiServiceErrorTypeProvider.class})
    public InputStream answerPromptByModelNameStream(@Config LangchainLLMConfiguration configuration, @Content String prompt) {
        String openaiApiKey = configuration.getConfigExtractor().extractValue("OPENAI_API_KEY");
        long durationInSec = configuration.getLlmTimeoutUnit().toSeconds(configuration.getLlmTimeout());
        try {
            OpenAiStreamingChatModel model = OpenAiStreamingChatModel.builder().apiKey(openaiApiKey).modelName(configuration.getModelName()).maxTokens(Integer.valueOf(configuration.getMaxTokens())).temperature(Double.valueOf(configuration.getTemperature())).timeout(Duration.ofSeconds(durationInSec)).build();
            Assistant assistant = (Assistant)AiServices.create(Assistant.class, (StreamingChatLanguageModel)model);
            TokenStream tokenStream = assistant.chat(prompt);
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            tokenStream.onNext(value -> {
                try {
                    pipedOutputStream.write(value.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new ModuleException("Error occurred while streaming output", (ErrorTypeDefinition)MuleChainErrorType.STREAMING_FAILURE, (Throwable)e);
                }
            }).onComplete(response -> {
                try {
                    pipedOutputStream.close();
                }
                catch (IOException e) {
                    throw new ModuleException("Error occurred while closing the stream", (ErrorTypeDefinition)MuleChainErrorType.STREAMING_FAILURE, (Throwable)e);
                }
            }).onError(throwable -> {
                throw new ModuleException("Exception occurred onError()", (ErrorTypeDefinition)MuleChainErrorType.STREAMING_FAILURE, throwable);
            }).start();
            return pipedInputStream;
        }
        catch (Exception e) {
            throw new ModuleException("Unable to respond with the chat provided", (ErrorTypeDefinition)MuleChainErrorType.AI_SERVICES_FAILURE, (Throwable)e);
        }
    }

    static interface Assistant {
        public TokenStream chat(String var1);
    }
}

