/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mulechain.internal.tools;

import dev.langchain4j.agent.tool.Tool;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.extension.mulechain.internal.util.ExcludeFromGeneratedCoverage;

@ExcludeFromGeneratedCoverage
public class DynamicToolWrapper
implements Tool {
    private final String name;
    private final String description;

    public DynamicToolWrapper(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String name() {
        return this.name;
    }

    public String[] value() {
        return new String[]{this.description};
    }

    public Class<? extends Annotation> annotationType() {
        return Tool.class;
    }

    public static Tool create(String name, String description) {
        return (Tool)Proxy.newProxyInstance(Tool.class.getClassLoader(), new Class[]{Tool.class}, (InvocationHandler)new DynamicToolInvocationHandler(name, description));
    }

    private static class DynamicToolInvocationHandler
    implements InvocationHandler {
        private final String name;
        private final String description;

        public DynamicToolInvocationHandler(String name, String description) {
            this.name = name;
            this.description = description;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "name": {
                    return this.name;
                }
                case "value": {
                    return new String[]{this.description};
                }
                case "annotationType": {
                    return Tool.class;
                }
            }
            throw new UnsupportedOperationException("Method not implemented: " + method.getName());
        }
    }
}

