/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.DeviceTypeEnvelope;
import cloud.artik.model.DeviceTypesEnvelope;
import cloud.artik.model.ManifestPropertiesEnvelope;
import cloud.artik.model.ManifestVersionsEnvelope;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DeviceTypesApi {
    private ApiClient apiClient;

    public DeviceTypesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceTypesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getAvailableManifestVersionsCall(String deviceTypeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{deviceTypeId}/availablemanifestversions".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceTypeId\\}", this.apiClient.escapeString(deviceTypeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAvailableManifestVersionsValidateBeforeCall(String deviceTypeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceTypeId == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeId' when calling getAvailableManifestVersions(Async)");
        }
        Call call = this.getAvailableManifestVersionsCall(deviceTypeId, progressListener, progressRequestListener);
        return call;
    }

    public ManifestVersionsEnvelope getAvailableManifestVersions(String deviceTypeId) throws ApiException {
        ApiResponse<ManifestVersionsEnvelope> resp = this.getAvailableManifestVersionsWithHttpInfo(deviceTypeId);
        return resp.getData();
    }

    public ApiResponse<ManifestVersionsEnvelope> getAvailableManifestVersionsWithHttpInfo(String deviceTypeId) throws ApiException {
        Call call = this.getAvailableManifestVersionsValidateBeforeCall(deviceTypeId, null, null);
        Type localVarReturnType = new TypeToken<ManifestVersionsEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAvailableManifestVersionsAsync(String deviceTypeId, final ApiCallback<ManifestVersionsEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAvailableManifestVersionsValidateBeforeCall(deviceTypeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ManifestVersionsEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDeviceTypeCall(String deviceTypeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{deviceTypeId}".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceTypeId\\}", this.apiClient.escapeString(deviceTypeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeviceTypeValidateBeforeCall(String deviceTypeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceTypeId == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeId' when calling getDeviceType(Async)");
        }
        Call call = this.getDeviceTypeCall(deviceTypeId, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypeEnvelope getDeviceType(String deviceTypeId) throws ApiException {
        ApiResponse<DeviceTypeEnvelope> resp = this.getDeviceTypeWithHttpInfo(deviceTypeId);
        return resp.getData();
    }

    public ApiResponse<DeviceTypeEnvelope> getDeviceTypeWithHttpInfo(String deviceTypeId) throws ApiException {
        Call call = this.getDeviceTypeValidateBeforeCall(deviceTypeId, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypeEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeviceTypeAsync(String deviceTypeId, final ApiCallback<DeviceTypeEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeviceTypeValidateBeforeCall(deviceTypeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypeEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDeviceTypesCall(String name, Integer offset, Integer count, String tags, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "name", name));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (tags != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeviceTypesValidateBeforeCall(String name, Integer offset, Integer count, String tags, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getDeviceTypes(Async)");
        }
        Call call = this.getDeviceTypesCall(name, offset, count, tags, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypesEnvelope getDeviceTypes(String name, Integer offset, Integer count, String tags) throws ApiException {
        ApiResponse<DeviceTypesEnvelope> resp = this.getDeviceTypesWithHttpInfo(name, offset, count, tags);
        return resp.getData();
    }

    public ApiResponse<DeviceTypesEnvelope> getDeviceTypesWithHttpInfo(String name, Integer offset, Integer count, String tags) throws ApiException {
        Call call = this.getDeviceTypesValidateBeforeCall(name, offset, count, tags, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeviceTypesAsync(String name, Integer offset, Integer count, String tags, final ApiCallback<DeviceTypesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeviceTypesValidateBeforeCall(name, offset, count, tags, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDeviceTypesByApplicationCall(String appId, Boolean productInfo, Integer count, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/applications/{appId}/devicetypes".replaceAll("\\{format\\}", "json").replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (productInfo != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "productInfo", productInfo));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeviceTypesByApplicationValidateBeforeCall(String appId, Boolean productInfo, Integer count, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (appId == null) {
            throw new ApiException("Missing the required parameter 'appId' when calling getDeviceTypesByApplication(Async)");
        }
        Call call = this.getDeviceTypesByApplicationCall(appId, productInfo, count, offset, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypesEnvelope getDeviceTypesByApplication(String appId, Boolean productInfo, Integer count, Integer offset) throws ApiException {
        ApiResponse<DeviceTypesEnvelope> resp = this.getDeviceTypesByApplicationWithHttpInfo(appId, productInfo, count, offset);
        return resp.getData();
    }

    public ApiResponse<DeviceTypesEnvelope> getDeviceTypesByApplicationWithHttpInfo(String appId, Boolean productInfo, Integer count, Integer offset) throws ApiException {
        Call call = this.getDeviceTypesByApplicationValidateBeforeCall(appId, productInfo, count, offset, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeviceTypesByApplicationAsync(String appId, Boolean productInfo, Integer count, Integer offset, final ApiCallback<DeviceTypesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeviceTypesByApplicationValidateBeforeCall(appId, productInfo, count, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getLatestManifestPropertiesCall(String deviceTypeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{deviceTypeId}/manifests/latest/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceTypeId\\}", this.apiClient.escapeString(deviceTypeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLatestManifestPropertiesValidateBeforeCall(String deviceTypeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceTypeId == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeId' when calling getLatestManifestProperties(Async)");
        }
        Call call = this.getLatestManifestPropertiesCall(deviceTypeId, progressListener, progressRequestListener);
        return call;
    }

    public ManifestPropertiesEnvelope getLatestManifestProperties(String deviceTypeId) throws ApiException {
        ApiResponse<ManifestPropertiesEnvelope> resp = this.getLatestManifestPropertiesWithHttpInfo(deviceTypeId);
        return resp.getData();
    }

    public ApiResponse<ManifestPropertiesEnvelope> getLatestManifestPropertiesWithHttpInfo(String deviceTypeId) throws ApiException {
        Call call = this.getLatestManifestPropertiesValidateBeforeCall(deviceTypeId, null, null);
        Type localVarReturnType = new TypeToken<ManifestPropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLatestManifestPropertiesAsync(String deviceTypeId, final ApiCallback<ManifestPropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLatestManifestPropertiesValidateBeforeCall(deviceTypeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ManifestPropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getManifestPropertiesCall(String deviceTypeId, String version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{deviceTypeId}/manifests/{version}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceTypeId\\}", this.apiClient.escapeString(deviceTypeId.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getManifestPropertiesValidateBeforeCall(String deviceTypeId, String version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceTypeId == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeId' when calling getManifestProperties(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getManifestProperties(Async)");
        }
        Call call = this.getManifestPropertiesCall(deviceTypeId, version, progressListener, progressRequestListener);
        return call;
    }

    public ManifestPropertiesEnvelope getManifestProperties(String deviceTypeId, String version) throws ApiException {
        ApiResponse<ManifestPropertiesEnvelope> resp = this.getManifestPropertiesWithHttpInfo(deviceTypeId, version);
        return resp.getData();
    }

    public ApiResponse<ManifestPropertiesEnvelope> getManifestPropertiesWithHttpInfo(String deviceTypeId, String version) throws ApiException {
        Call call = this.getManifestPropertiesValidateBeforeCall(deviceTypeId, version, null, null);
        Type localVarReturnType = new TypeToken<ManifestPropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getManifestPropertiesAsync(String deviceTypeId, String version, final ApiCallback<ManifestPropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getManifestPropertiesValidateBeforeCall(deviceTypeId, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ManifestPropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

