/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.DeviceTaskUpdateRequest;
import cloud.artik.model.DeviceTaskUpdateResponse;
import cloud.artik.model.DeviceTypesInfo;
import cloud.artik.model.DeviceTypesInfoEnvelope;
import cloud.artik.model.MetadataEnvelope;
import cloud.artik.model.MetadataPropertiesEnvelope;
import cloud.artik.model.MetadataQueryEnvelope;
import cloud.artik.model.TaskByDidListEnvelope;
import cloud.artik.model.TaskEnvelope;
import cloud.artik.model.TaskListEnvelope;
import cloud.artik.model.TaskRequest;
import cloud.artik.model.TaskStatusesEnvelope;
import cloud.artik.model.TaskStatusesHistoryEnvelope;
import cloud.artik.model.TaskUpdateRequest;
import cloud.artik.model.TaskUpdateResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DevicesManagementApi {
    private ApiClient apiClient;

    public DevicesManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DevicesManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createTasksCall(TaskRequest taskPayload, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaskRequest localVarPostBody = taskPayload;
        String localVarPath = "/devicemgmt/tasks".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createTasksValidateBeforeCall(TaskRequest taskPayload, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taskPayload == null) {
            throw new ApiException("Missing the required parameter 'taskPayload' when calling createTasks(Async)");
        }
        Call call = this.createTasksCall(taskPayload, progressListener, progressRequestListener);
        return call;
    }

    public TaskEnvelope createTasks(TaskRequest taskPayload) throws ApiException {
        ApiResponse<TaskEnvelope> resp = this.createTasksWithHttpInfo(taskPayload);
        return resp.getData();
    }

    public ApiResponse<TaskEnvelope> createTasksWithHttpInfo(TaskRequest taskPayload) throws ApiException {
        Call call = this.createTasksValidateBeforeCall(taskPayload, null, null);
        Type localVarReturnType = new TypeToken<TaskEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createTasksAsync(TaskRequest taskPayload, final ApiCallback<TaskEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTasksValidateBeforeCall(taskPayload, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteServerPropertiesCall(String did, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/devices/{did}/serverproperties".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteServerPropertiesValidateBeforeCall(String did, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling deleteServerProperties(Async)");
        }
        Call call = this.deleteServerPropertiesCall(did, progressListener, progressRequestListener);
        return call;
    }

    public MetadataEnvelope deleteServerProperties(String did) throws ApiException {
        ApiResponse<MetadataEnvelope> resp = this.deleteServerPropertiesWithHttpInfo(did);
        return resp.getData();
    }

    public ApiResponse<MetadataEnvelope> deleteServerPropertiesWithHttpInfo(String did) throws ApiException {
        Call call = this.deleteServerPropertiesValidateBeforeCall(did, null, null);
        Type localVarReturnType = new TypeToken<MetadataEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteServerPropertiesAsync(String did, final ApiCallback<MetadataEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteServerPropertiesValidateBeforeCall(did, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MetadataEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAllByDidCall(String did, Integer count, Integer offset, String status, String order, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/devices/{did}/tasks".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllByDidValidateBeforeCall(String did, Integer count, Integer offset, String status, String order, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling getAllByDid(Async)");
        }
        Call call = this.getAllByDidCall(did, count, offset, status, order, sort, progressListener, progressRequestListener);
        return call;
    }

    public TaskByDidListEnvelope getAllByDid(String did, Integer count, Integer offset, String status, String order, String sort) throws ApiException {
        ApiResponse<TaskByDidListEnvelope> resp = this.getAllByDidWithHttpInfo(did, count, offset, status, order, sort);
        return resp.getData();
    }

    public ApiResponse<TaskByDidListEnvelope> getAllByDidWithHttpInfo(String did, Integer count, Integer offset, String status, String order, String sort) throws ApiException {
        Call call = this.getAllByDidValidateBeforeCall(did, count, offset, status, order, sort, null, null);
        Type localVarReturnType = new TypeToken<TaskByDidListEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllByDidAsync(String did, Integer count, Integer offset, String status, String order, String sort, final ApiCallback<TaskByDidListEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllByDidValidateBeforeCall(did, count, offset, status, order, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskByDidListEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDeviceTypesInfoCall(String dtid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/devicetypes/{dtid}".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeviceTypesInfoValidateBeforeCall(String dtid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getDeviceTypesInfo(Async)");
        }
        Call call = this.getDeviceTypesInfoCall(dtid, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypesInfoEnvelope getDeviceTypesInfo(String dtid) throws ApiException {
        ApiResponse<DeviceTypesInfoEnvelope> resp = this.getDeviceTypesInfoWithHttpInfo(dtid);
        return resp.getData();
    }

    public ApiResponse<DeviceTypesInfoEnvelope> getDeviceTypesInfoWithHttpInfo(String dtid) throws ApiException {
        Call call = this.getDeviceTypesInfoValidateBeforeCall(dtid, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypesInfoEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeviceTypesInfoAsync(String dtid, final ApiCallback<DeviceTypesInfoEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeviceTypesInfoValidateBeforeCall(dtid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypesInfoEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getManifestPropertiesCall(String dtid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/devicetypes/{dtid}/manifest/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getManifestPropertiesValidateBeforeCall(String dtid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getManifestProperties(Async)");
        }
        Call call = this.getManifestPropertiesCall(dtid, progressListener, progressRequestListener);
        return call;
    }

    public MetadataPropertiesEnvelope getManifestProperties(String dtid) throws ApiException {
        ApiResponse<MetadataPropertiesEnvelope> resp = this.getManifestPropertiesWithHttpInfo(dtid);
        return resp.getData();
    }

    public ApiResponse<MetadataPropertiesEnvelope> getManifestPropertiesWithHttpInfo(String dtid) throws ApiException {
        Call call = this.getManifestPropertiesValidateBeforeCall(dtid, null, null);
        Type localVarReturnType = new TypeToken<MetadataPropertiesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getManifestPropertiesAsync(String dtid, final ApiCallback<MetadataPropertiesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getManifestPropertiesValidateBeforeCall(dtid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MetadataPropertiesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getPropertiesCall(String did, Boolean includeTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/devices/{did}/properties".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (includeTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeTimestamp", includeTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPropertiesValidateBeforeCall(String did, Boolean includeTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling getProperties(Async)");
        }
        Call call = this.getPropertiesCall(did, includeTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public MetadataEnvelope getProperties(String did, Boolean includeTimestamp) throws ApiException {
        ApiResponse<MetadataEnvelope> resp = this.getPropertiesWithHttpInfo(did, includeTimestamp);
        return resp.getData();
    }

    public ApiResponse<MetadataEnvelope> getPropertiesWithHttpInfo(String did, Boolean includeTimestamp) throws ApiException {
        Call call = this.getPropertiesValidateBeforeCall(did, includeTimestamp, null, null);
        Type localVarReturnType = new TypeToken<MetadataEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPropertiesAsync(String did, Boolean includeTimestamp, final ApiCallback<MetadataEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPropertiesValidateBeforeCall(did, includeTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MetadataEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getStatusesCall(String tid, Integer count, Integer offset, String status, String dids, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/tasks/{tid}/statuses".replaceAll("\\{format\\}", "json").replaceAll("\\{tid\\}", this.apiClient.escapeString(tid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        }
        if (dids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "dids", dids));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getStatusesValidateBeforeCall(String tid, Integer count, Integer offset, String status, String dids, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tid == null) {
            throw new ApiException("Missing the required parameter 'tid' when calling getStatuses(Async)");
        }
        Call call = this.getStatusesCall(tid, count, offset, status, dids, progressListener, progressRequestListener);
        return call;
    }

    public TaskStatusesEnvelope getStatuses(String tid, Integer count, Integer offset, String status, String dids) throws ApiException {
        ApiResponse<TaskStatusesEnvelope> resp = this.getStatusesWithHttpInfo(tid, count, offset, status, dids);
        return resp.getData();
    }

    public ApiResponse<TaskStatusesEnvelope> getStatusesWithHttpInfo(String tid, Integer count, Integer offset, String status, String dids) throws ApiException {
        Call call = this.getStatusesValidateBeforeCall(tid, count, offset, status, dids, null, null);
        Type localVarReturnType = new TypeToken<TaskStatusesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getStatusesAsync(String tid, Integer count, Integer offset, String status, String dids, final ApiCallback<TaskStatusesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getStatusesValidateBeforeCall(tid, count, offset, status, dids, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskStatusesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getStatusesHistoryCall(String tid, String did, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/tasks/{tid}/statuses/history".replaceAll("\\{format\\}", "json").replaceAll("\\{tid\\}", this.apiClient.escapeString(tid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (did != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "did", did));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getStatusesHistoryValidateBeforeCall(String tid, String did, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tid == null) {
            throw new ApiException("Missing the required parameter 'tid' when calling getStatusesHistory(Async)");
        }
        Call call = this.getStatusesHistoryCall(tid, did, progressListener, progressRequestListener);
        return call;
    }

    public TaskStatusesHistoryEnvelope getStatusesHistory(String tid, String did) throws ApiException {
        ApiResponse<TaskStatusesHistoryEnvelope> resp = this.getStatusesHistoryWithHttpInfo(tid, did);
        return resp.getData();
    }

    public ApiResponse<TaskStatusesHistoryEnvelope> getStatusesHistoryWithHttpInfo(String tid, String did) throws ApiException {
        Call call = this.getStatusesHistoryValidateBeforeCall(tid, did, null, null);
        Type localVarReturnType = new TypeToken<TaskStatusesHistoryEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getStatusesHistoryAsync(String tid, String did, final ApiCallback<TaskStatusesHistoryEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getStatusesHistoryValidateBeforeCall(tid, did, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskStatusesHistoryEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTaskByIDCall(String tid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/tasks/{tid}".replaceAll("\\{format\\}", "json").replaceAll("\\{tid\\}", this.apiClient.escapeString(tid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaskByIDValidateBeforeCall(String tid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tid == null) {
            throw new ApiException("Missing the required parameter 'tid' when calling getTaskByID(Async)");
        }
        Call call = this.getTaskByIDCall(tid, progressListener, progressRequestListener);
        return call;
    }

    public TaskEnvelope getTaskByID(String tid) throws ApiException {
        ApiResponse<TaskEnvelope> resp = this.getTaskByIDWithHttpInfo(tid);
        return resp.getData();
    }

    public ApiResponse<TaskEnvelope> getTaskByIDWithHttpInfo(String tid) throws ApiException {
        Call call = this.getTaskByIDValidateBeforeCall(tid, null, null);
        Type localVarReturnType = new TypeToken<TaskEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaskByIDAsync(String tid, final ApiCallback<TaskEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaskByIDValidateBeforeCall(tid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getTasksCall(String dtid, Integer count, Integer offset, String status, String order, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/tasks".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (dtid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "dtid", dtid));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTasksValidateBeforeCall(String dtid, Integer count, Integer offset, String status, String order, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getTasks(Async)");
        }
        Call call = this.getTasksCall(dtid, count, offset, status, order, sort, progressListener, progressRequestListener);
        return call;
    }

    public TaskListEnvelope getTasks(String dtid, Integer count, Integer offset, String status, String order, String sort) throws ApiException {
        ApiResponse<TaskListEnvelope> resp = this.getTasksWithHttpInfo(dtid, count, offset, status, order, sort);
        return resp.getData();
    }

    public ApiResponse<TaskListEnvelope> getTasksWithHttpInfo(String dtid, Integer count, Integer offset, String status, String order, String sort) throws ApiException {
        Call call = this.getTasksValidateBeforeCall(dtid, count, offset, status, order, sort, null, null);
        Type localVarReturnType = new TypeToken<TaskListEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTasksAsync(String dtid, Integer count, Integer offset, String status, String order, String sort, final ApiCallback<TaskListEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTasksValidateBeforeCall(dtid, count, offset, status, order, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskListEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call queryPropertiesCall(String dtid, Integer count, Integer offset, String filter, Boolean includeTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicemgmt/devices/properties".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (dtid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "dtid", dtid));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        }
        if (includeTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeTimestamp", includeTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call queryPropertiesValidateBeforeCall(String dtid, Integer count, Integer offset, String filter, Boolean includeTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling queryProperties(Async)");
        }
        Call call = this.queryPropertiesCall(dtid, count, offset, filter, includeTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public MetadataQueryEnvelope queryProperties(String dtid, Integer count, Integer offset, String filter, Boolean includeTimestamp) throws ApiException {
        ApiResponse<MetadataQueryEnvelope> resp = this.queryPropertiesWithHttpInfo(dtid, count, offset, filter, includeTimestamp);
        return resp.getData();
    }

    public ApiResponse<MetadataQueryEnvelope> queryPropertiesWithHttpInfo(String dtid, Integer count, Integer offset, String filter, Boolean includeTimestamp) throws ApiException {
        Call call = this.queryPropertiesValidateBeforeCall(dtid, count, offset, filter, includeTimestamp, null, null);
        Type localVarReturnType = new TypeToken<MetadataQueryEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call queryPropertiesAsync(String dtid, Integer count, Integer offset, String filter, Boolean includeTimestamp, final ApiCallback<MetadataQueryEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.queryPropertiesValidateBeforeCall(dtid, count, offset, filter, includeTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MetadataQueryEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateDeviceTypesInfoCall(String dtid, DeviceTypesInfo deviceTypeInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceTypesInfo localVarPostBody = deviceTypeInfo;
        String localVarPath = "/devicemgmt/devicetypes/{dtid}".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateDeviceTypesInfoValidateBeforeCall(String dtid, DeviceTypesInfo deviceTypeInfo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling updateDeviceTypesInfo(Async)");
        }
        if (deviceTypeInfo == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeInfo' when calling updateDeviceTypesInfo(Async)");
        }
        Call call = this.updateDeviceTypesInfoCall(dtid, deviceTypeInfo, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypesInfoEnvelope updateDeviceTypesInfo(String dtid, DeviceTypesInfo deviceTypeInfo) throws ApiException {
        ApiResponse<DeviceTypesInfoEnvelope> resp = this.updateDeviceTypesInfoWithHttpInfo(dtid, deviceTypeInfo);
        return resp.getData();
    }

    public ApiResponse<DeviceTypesInfoEnvelope> updateDeviceTypesInfoWithHttpInfo(String dtid, DeviceTypesInfo deviceTypeInfo) throws ApiException {
        Call call = this.updateDeviceTypesInfoValidateBeforeCall(dtid, deviceTypeInfo, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypesInfoEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateDeviceTypesInfoAsync(String dtid, DeviceTypesInfo deviceTypeInfo, final ApiCallback<DeviceTypesInfoEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateDeviceTypesInfoValidateBeforeCall(dtid, deviceTypeInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypesInfoEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateServerPropertiesCall(String did, Object deviceProperties, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = deviceProperties;
        String localVarPath = "/devicemgmt/devices/{did}/serverproperties".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateServerPropertiesValidateBeforeCall(String did, Object deviceProperties, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling updateServerProperties(Async)");
        }
        if (deviceProperties == null) {
            throw new ApiException("Missing the required parameter 'deviceProperties' when calling updateServerProperties(Async)");
        }
        Call call = this.updateServerPropertiesCall(did, deviceProperties, progressListener, progressRequestListener);
        return call;
    }

    public MetadataEnvelope updateServerProperties(String did, Object deviceProperties) throws ApiException {
        ApiResponse<MetadataEnvelope> resp = this.updateServerPropertiesWithHttpInfo(did, deviceProperties);
        return resp.getData();
    }

    public ApiResponse<MetadataEnvelope> updateServerPropertiesWithHttpInfo(String did, Object deviceProperties) throws ApiException {
        Call call = this.updateServerPropertiesValidateBeforeCall(did, deviceProperties, null, null);
        Type localVarReturnType = new TypeToken<MetadataEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateServerPropertiesAsync(String did, Object deviceProperties, final ApiCallback<MetadataEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateServerPropertiesValidateBeforeCall(did, deviceProperties, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MetadataEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateTaskCall(String tid, TaskUpdateRequest taskUpdateRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaskUpdateRequest localVarPostBody = taskUpdateRequest;
        String localVarPath = "/devicemgmt/tasks/{tid}".replaceAll("\\{format\\}", "json").replaceAll("\\{tid\\}", this.apiClient.escapeString(tid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaskValidateBeforeCall(String tid, TaskUpdateRequest taskUpdateRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tid == null) {
            throw new ApiException("Missing the required parameter 'tid' when calling updateTask(Async)");
        }
        if (taskUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'taskUpdateRequest' when calling updateTask(Async)");
        }
        Call call = this.updateTaskCall(tid, taskUpdateRequest, progressListener, progressRequestListener);
        return call;
    }

    public TaskUpdateResponse updateTask(String tid, TaskUpdateRequest taskUpdateRequest) throws ApiException {
        ApiResponse<TaskUpdateResponse> resp = this.updateTaskWithHttpInfo(tid, taskUpdateRequest);
        return resp.getData();
    }

    public ApiResponse<TaskUpdateResponse> updateTaskWithHttpInfo(String tid, TaskUpdateRequest taskUpdateRequest) throws ApiException {
        Call call = this.updateTaskValidateBeforeCall(tid, taskUpdateRequest, null, null);
        Type localVarReturnType = new TypeToken<TaskUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaskAsync(String tid, TaskUpdateRequest taskUpdateRequest, final ApiCallback<TaskUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaskValidateBeforeCall(tid, taskUpdateRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaskUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call updateTaskForDeviceCall(String tid, String did, DeviceTaskUpdateRequest deviceTaskUpdateRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceTaskUpdateRequest localVarPostBody = deviceTaskUpdateRequest;
        String localVarPath = "/devicemgmt/tasks/{tid}/devices/{did}".replaceAll("\\{format\\}", "json").replaceAll("\\{tid\\}", this.apiClient.escapeString(tid.toString())).replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaskForDeviceValidateBeforeCall(String tid, String did, DeviceTaskUpdateRequest deviceTaskUpdateRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tid == null) {
            throw new ApiException("Missing the required parameter 'tid' when calling updateTaskForDevice(Async)");
        }
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling updateTaskForDevice(Async)");
        }
        if (deviceTaskUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'deviceTaskUpdateRequest' when calling updateTaskForDevice(Async)");
        }
        Call call = this.updateTaskForDeviceCall(tid, did, deviceTaskUpdateRequest, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTaskUpdateResponse updateTaskForDevice(String tid, String did, DeviceTaskUpdateRequest deviceTaskUpdateRequest) throws ApiException {
        ApiResponse<DeviceTaskUpdateResponse> resp = this.updateTaskForDeviceWithHttpInfo(tid, did, deviceTaskUpdateRequest);
        return resp.getData();
    }

    public ApiResponse<DeviceTaskUpdateResponse> updateTaskForDeviceWithHttpInfo(String tid, String did, DeviceTaskUpdateRequest deviceTaskUpdateRequest) throws ApiException {
        Call call = this.updateTaskForDeviceValidateBeforeCall(tid, did, deviceTaskUpdateRequest, null, null);
        Type localVarReturnType = new TypeToken<DeviceTaskUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaskForDeviceAsync(String tid, String did, DeviceTaskUpdateRequest deviceTaskUpdateRequest, final ApiCallback<DeviceTaskUpdateResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaskForDeviceValidateBeforeCall(tid, did, deviceTaskUpdateRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTaskUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

