/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.DeviceShareInfo;
import cloud.artik.model.DeviceSharing;
import cloud.artik.model.DeviceSharingEnvelope;
import cloud.artik.model.DeviceSharingId;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DevicesSharesApi {
    private ApiClient apiClient;

    public DevicesSharesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DevicesSharesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createShareForDeviceCall(String deviceId, DeviceShareInfo deviceShareInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceShareInfo localVarPostBody = deviceShareInfo;
        String localVarPath = "/devices/{deviceId}/shares".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createShareForDeviceValidateBeforeCall(String deviceId, DeviceShareInfo deviceShareInfo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling createShareForDevice(Async)");
        }
        if (deviceShareInfo == null) {
            throw new ApiException("Missing the required parameter 'deviceShareInfo' when calling createShareForDevice(Async)");
        }
        Call call = this.createShareForDeviceCall(deviceId, deviceShareInfo, progressListener, progressRequestListener);
        return call;
    }

    public DeviceSharingId createShareForDevice(String deviceId, DeviceShareInfo deviceShareInfo) throws ApiException {
        ApiResponse<DeviceSharingId> resp = this.createShareForDeviceWithHttpInfo(deviceId, deviceShareInfo);
        return resp.getData();
    }

    public ApiResponse<DeviceSharingId> createShareForDeviceWithHttpInfo(String deviceId, DeviceShareInfo deviceShareInfo) throws ApiException {
        Call call = this.createShareForDeviceValidateBeforeCall(deviceId, deviceShareInfo, null, null);
        Type localVarReturnType = new TypeToken<DeviceSharingId>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createShareForDeviceAsync(String deviceId, DeviceShareInfo deviceShareInfo, final ApiCallback<DeviceSharingId> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createShareForDeviceValidateBeforeCall(deviceId, deviceShareInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceSharingId>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteSharingForDeviceCall(String deviceId, String shareId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/{deviceId}/shares/{shareId}".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString())).replaceAll("\\{shareId\\}", this.apiClient.escapeString(shareId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSharingForDeviceValidateBeforeCall(String deviceId, String shareId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling deleteSharingForDevice(Async)");
        }
        if (shareId == null) {
            throw new ApiException("Missing the required parameter 'shareId' when calling deleteSharingForDevice(Async)");
        }
        Call call = this.deleteSharingForDeviceCall(deviceId, shareId, progressListener, progressRequestListener);
        return call;
    }

    public DeviceSharingId deleteSharingForDevice(String deviceId, String shareId) throws ApiException {
        ApiResponse<DeviceSharingId> resp = this.deleteSharingForDeviceWithHttpInfo(deviceId, shareId);
        return resp.getData();
    }

    public ApiResponse<DeviceSharingId> deleteSharingForDeviceWithHttpInfo(String deviceId, String shareId) throws ApiException {
        Call call = this.deleteSharingForDeviceValidateBeforeCall(deviceId, shareId, null, null);
        Type localVarReturnType = new TypeToken<DeviceSharingId>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSharingForDeviceAsync(String deviceId, String shareId, final ApiCallback<DeviceSharingId> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSharingForDeviceValidateBeforeCall(deviceId, shareId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceSharingId>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAllSharesForDeviceCall(String deviceId, Integer count, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/{deviceId}/shares".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllSharesForDeviceValidateBeforeCall(String deviceId, Integer count, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling getAllSharesForDevice(Async)");
        }
        Call call = this.getAllSharesForDeviceCall(deviceId, count, offset, progressListener, progressRequestListener);
        return call;
    }

    public DeviceSharingEnvelope getAllSharesForDevice(String deviceId, Integer count, Integer offset) throws ApiException {
        ApiResponse<DeviceSharingEnvelope> resp = this.getAllSharesForDeviceWithHttpInfo(deviceId, count, offset);
        return resp.getData();
    }

    public ApiResponse<DeviceSharingEnvelope> getAllSharesForDeviceWithHttpInfo(String deviceId, Integer count, Integer offset) throws ApiException {
        Call call = this.getAllSharesForDeviceValidateBeforeCall(deviceId, count, offset, null, null);
        Type localVarReturnType = new TypeToken<DeviceSharingEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllSharesForDeviceAsync(String deviceId, Integer count, Integer offset, final ApiCallback<DeviceSharingEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllSharesForDeviceValidateBeforeCall(deviceId, count, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceSharingEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getSharingForDeviceCall(String deviceId, String shareId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/{deviceId}/shares/{shareId}".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString())).replaceAll("\\{shareId\\}", this.apiClient.escapeString(shareId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSharingForDeviceValidateBeforeCall(String deviceId, String shareId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling getSharingForDevice(Async)");
        }
        if (shareId == null) {
            throw new ApiException("Missing the required parameter 'shareId' when calling getSharingForDevice(Async)");
        }
        Call call = this.getSharingForDeviceCall(deviceId, shareId, progressListener, progressRequestListener);
        return call;
    }

    public DeviceSharing getSharingForDevice(String deviceId, String shareId) throws ApiException {
        ApiResponse<DeviceSharing> resp = this.getSharingForDeviceWithHttpInfo(deviceId, shareId);
        return resp.getData();
    }

    public ApiResponse<DeviceSharing> getSharingForDeviceWithHttpInfo(String deviceId, String shareId) throws ApiException {
        Call call = this.getSharingForDeviceValidateBeforeCall(deviceId, shareId, null, null);
        Type localVarReturnType = new TypeToken<DeviceSharing>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSharingForDeviceAsync(String deviceId, String shareId, final ApiCallback<DeviceSharing> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSharingForDeviceValidateBeforeCall(deviceId, shareId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceSharing>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

