/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.DeviceStatus;
import cloud.artik.model.DeviceStatusBatch;
import cloud.artik.model.DeviceStatusPut;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class DevicesStatusApi {
    private ApiClient apiClient;

    public DevicesStatusApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DevicesStatusApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getDeviceStatusCall(String deviceId, Boolean includeSnapshot, Boolean includeSnapshotTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/{deviceId}/status".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (includeSnapshot != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeSnapshot", includeSnapshot));
        }
        if (includeSnapshotTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeSnapshotTimestamp", includeSnapshotTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDeviceStatusValidateBeforeCall(String deviceId, Boolean includeSnapshot, Boolean includeSnapshotTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling getDeviceStatus(Async)");
        }
        Call call = this.getDeviceStatusCall(deviceId, includeSnapshot, includeSnapshotTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public DeviceStatus getDeviceStatus(String deviceId, Boolean includeSnapshot, Boolean includeSnapshotTimestamp) throws ApiException {
        ApiResponse<DeviceStatus> resp = this.getDeviceStatusWithHttpInfo(deviceId, includeSnapshot, includeSnapshotTimestamp);
        return resp.getData();
    }

    public ApiResponse<DeviceStatus> getDeviceStatusWithHttpInfo(String deviceId, Boolean includeSnapshot, Boolean includeSnapshotTimestamp) throws ApiException {
        Call call = this.getDeviceStatusValidateBeforeCall(deviceId, includeSnapshot, includeSnapshotTimestamp, null, null);
        Type localVarReturnType = new TypeToken<DeviceStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDeviceStatusAsync(String deviceId, Boolean includeSnapshot, Boolean includeSnapshotTimestamp, final ApiCallback<DeviceStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDeviceStatusValidateBeforeCall(deviceId, includeSnapshot, includeSnapshotTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getDevicesStatusCall(String dids, Boolean includeSnapshot, Boolean includeSnapshotTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/status".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (dids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "dids", dids));
        }
        if (includeSnapshot != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeSnapshot", includeSnapshot));
        }
        if (includeSnapshotTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeSnapshotTimestamp", includeSnapshotTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getDevicesStatusValidateBeforeCall(String dids, Boolean includeSnapshot, Boolean includeSnapshotTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dids == null) {
            throw new ApiException("Missing the required parameter 'dids' when calling getDevicesStatus(Async)");
        }
        Call call = this.getDevicesStatusCall(dids, includeSnapshot, includeSnapshotTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public DeviceStatusBatch getDevicesStatus(String dids, Boolean includeSnapshot, Boolean includeSnapshotTimestamp) throws ApiException {
        ApiResponse<DeviceStatusBatch> resp = this.getDevicesStatusWithHttpInfo(dids, includeSnapshot, includeSnapshotTimestamp);
        return resp.getData();
    }

    public ApiResponse<DeviceStatusBatch> getDevicesStatusWithHttpInfo(String dids, Boolean includeSnapshot, Boolean includeSnapshotTimestamp) throws ApiException {
        Call call = this.getDevicesStatusValidateBeforeCall(dids, includeSnapshot, includeSnapshotTimestamp, null, null);
        Type localVarReturnType = new TypeToken<DeviceStatusBatch>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getDevicesStatusAsync(String dids, Boolean includeSnapshot, Boolean includeSnapshotTimestamp, final ApiCallback<DeviceStatusBatch> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getDevicesStatusValidateBeforeCall(dids, includeSnapshot, includeSnapshotTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceStatusBatch>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call putDeviceStatusCall(String deviceId, DeviceStatusPut body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceStatusPut localVarPostBody = body;
        String localVarPath = "/devices/{deviceId}/status".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putDeviceStatusValidateBeforeCall(String deviceId, DeviceStatusPut body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling putDeviceStatus(Async)");
        }
        Call call = this.putDeviceStatusCall(deviceId, body, progressListener, progressRequestListener);
        return call;
    }

    public DeviceStatus putDeviceStatus(String deviceId, DeviceStatusPut body) throws ApiException {
        ApiResponse<DeviceStatus> resp = this.putDeviceStatusWithHttpInfo(deviceId, body);
        return resp.getData();
    }

    public ApiResponse<DeviceStatus> putDeviceStatusWithHttpInfo(String deviceId, DeviceStatusPut body) throws ApiException {
        Call call = this.putDeviceStatusValidateBeforeCall(deviceId, body, null, null);
        Type localVarReturnType = new TypeToken<DeviceStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call putDeviceStatusAsync(String deviceId, DeviceStatusPut body, final ApiCallback<DeviceStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putDeviceStatusValidateBeforeCall(deviceId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

