/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.Actions;
import cloud.artik.model.AggregatesHistogramResponse;
import cloud.artik.model.AggregatesResponse;
import cloud.artik.model.FieldPresenceEnvelope;
import cloud.artik.model.Message;
import cloud.artik.model.MessageIDEnvelope;
import cloud.artik.model.NormalizedActionsEnvelope;
import cloud.artik.model.NormalizedMessagesEnvelope;
import cloud.artik.model.SnapshotResponses;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class MessagesApi {
    private ApiClient apiClient;

    public MessagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MessagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getAggregatesHistogramCall(Long startDate, Long endDate, String sdid, String field, String interval, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages/analytics/histogram".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (field != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "field", field));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAggregatesHistogramValidateBeforeCall(Long startDate, Long endDate, String sdid, String field, String interval, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getAggregatesHistogram(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getAggregatesHistogram(Async)");
        }
        Call call = this.getAggregatesHistogramCall(startDate, endDate, sdid, field, interval, progressListener, progressRequestListener);
        return call;
    }

    public AggregatesHistogramResponse getAggregatesHistogram(Long startDate, Long endDate, String sdid, String field, String interval) throws ApiException {
        ApiResponse<AggregatesHistogramResponse> resp = this.getAggregatesHistogramWithHttpInfo(startDate, endDate, sdid, field, interval);
        return resp.getData();
    }

    public ApiResponse<AggregatesHistogramResponse> getAggregatesHistogramWithHttpInfo(Long startDate, Long endDate, String sdid, String field, String interval) throws ApiException {
        Call call = this.getAggregatesHistogramValidateBeforeCall(startDate, endDate, sdid, field, interval, null, null);
        Type localVarReturnType = new TypeToken<AggregatesHistogramResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAggregatesHistogramAsync(Long startDate, Long endDate, String sdid, String field, String interval, final ApiCallback<AggregatesHistogramResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAggregatesHistogramValidateBeforeCall(startDate, endDate, sdid, field, interval, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AggregatesHistogramResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getFieldPresenceCall(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages/presence".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (fieldPresence != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFieldPresenceValidateBeforeCall(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getFieldPresence(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getFieldPresence(Async)");
        }
        if (interval == null) {
            throw new ApiException("Missing the required parameter 'interval' when calling getFieldPresence(Async)");
        }
        Call call = this.getFieldPresenceCall(startDate, endDate, interval, sdid, fieldPresence, progressListener, progressRequestListener);
        return call;
    }

    public FieldPresenceEnvelope getFieldPresence(Long startDate, Long endDate, String interval, String sdid, String fieldPresence) throws ApiException {
        ApiResponse<FieldPresenceEnvelope> resp = this.getFieldPresenceWithHttpInfo(startDate, endDate, interval, sdid, fieldPresence);
        return resp.getData();
    }

    public ApiResponse<FieldPresenceEnvelope> getFieldPresenceWithHttpInfo(Long startDate, Long endDate, String interval, String sdid, String fieldPresence) throws ApiException {
        Call call = this.getFieldPresenceValidateBeforeCall(startDate, endDate, interval, sdid, fieldPresence, null, null);
        Type localVarReturnType = new TypeToken<FieldPresenceEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFieldPresenceAsync(Long startDate, Long endDate, String interval, String sdid, String fieldPresence, final ApiCallback<FieldPresenceEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFieldPresenceValidateBeforeCall(startDate, endDate, interval, sdid, fieldPresence, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FieldPresenceEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getLastNormalizedMessagesCall(Integer count, String sdids, String fieldPresence, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages/last".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (sdids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdids", sdids));
        }
        if (fieldPresence != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getLastNormalizedMessagesValidateBeforeCall(Integer count, String sdids, String fieldPresence, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getLastNormalizedMessagesCall(count, sdids, fieldPresence, progressListener, progressRequestListener);
        return call;
    }

    public NormalizedMessagesEnvelope getLastNormalizedMessages(Integer count, String sdids, String fieldPresence) throws ApiException {
        ApiResponse<NormalizedMessagesEnvelope> resp = this.getLastNormalizedMessagesWithHttpInfo(count, sdids, fieldPresence);
        return resp.getData();
    }

    public ApiResponse<NormalizedMessagesEnvelope> getLastNormalizedMessagesWithHttpInfo(Integer count, String sdids, String fieldPresence) throws ApiException {
        Call call = this.getLastNormalizedMessagesValidateBeforeCall(count, sdids, fieldPresence, null, null);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getLastNormalizedMessagesAsync(Integer count, String sdids, String fieldPresence, final ApiCallback<NormalizedMessagesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getLastNormalizedMessagesValidateBeforeCall(count, sdids, fieldPresence, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getMessageAggregatesCall(String sdid, String field, Long startDate, Long endDate, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages/analytics/aggregates".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (field != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "field", field));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMessageAggregatesValidateBeforeCall(String sdid, String field, Long startDate, Long endDate, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sdid == null) {
            throw new ApiException("Missing the required parameter 'sdid' when calling getMessageAggregates(Async)");
        }
        if (field == null) {
            throw new ApiException("Missing the required parameter 'field' when calling getMessageAggregates(Async)");
        }
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getMessageAggregates(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getMessageAggregates(Async)");
        }
        Call call = this.getMessageAggregatesCall(sdid, field, startDate, endDate, progressListener, progressRequestListener);
        return call;
    }

    public AggregatesResponse getMessageAggregates(String sdid, String field, Long startDate, Long endDate) throws ApiException {
        ApiResponse<AggregatesResponse> resp = this.getMessageAggregatesWithHttpInfo(sdid, field, startDate, endDate);
        return resp.getData();
    }

    public ApiResponse<AggregatesResponse> getMessageAggregatesWithHttpInfo(String sdid, String field, Long startDate, Long endDate) throws ApiException {
        Call call = this.getMessageAggregatesValidateBeforeCall(sdid, field, startDate, endDate, null, null);
        Type localVarReturnType = new TypeToken<AggregatesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMessageAggregatesAsync(String sdid, String field, Long startDate, Long endDate, final ApiCallback<AggregatesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMessageAggregatesValidateBeforeCall(sdid, field, startDate, endDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AggregatesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getMessageSnapshotsCall(String sdids, Boolean includeTimestamp, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages/snapshots".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sdids != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdids", sdids));
        }
        if (includeTimestamp != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "includeTimestamp", includeTimestamp));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMessageSnapshotsValidateBeforeCall(String sdids, Boolean includeTimestamp, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sdids == null) {
            throw new ApiException("Missing the required parameter 'sdids' when calling getMessageSnapshots(Async)");
        }
        Call call = this.getMessageSnapshotsCall(sdids, includeTimestamp, progressListener, progressRequestListener);
        return call;
    }

    public SnapshotResponses getMessageSnapshots(String sdids, Boolean includeTimestamp) throws ApiException {
        ApiResponse<SnapshotResponses> resp = this.getMessageSnapshotsWithHttpInfo(sdids, includeTimestamp);
        return resp.getData();
    }

    public ApiResponse<SnapshotResponses> getMessageSnapshotsWithHttpInfo(String sdids, Boolean includeTimestamp) throws ApiException {
        Call call = this.getMessageSnapshotsValidateBeforeCall(sdids, includeTimestamp, null, null);
        Type localVarReturnType = new TypeToken<SnapshotResponses>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMessageSnapshotsAsync(String sdids, Boolean includeTimestamp, final ApiCallback<SnapshotResponses> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMessageSnapshotsValidateBeforeCall(sdids, includeTimestamp, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SnapshotResponses>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getNormalizedActionsCall(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/actions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (uid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "uid", uid));
        }
        if (ddid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ddid", ddid));
        }
        if (mid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "mid", mid));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNormalizedActionsValidateBeforeCall(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getNormalizedActionsCall(uid, ddid, mid, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        return call;
    }

    public NormalizedActionsEnvelope getNormalizedActions(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        ApiResponse<NormalizedActionsEnvelope> resp = this.getNormalizedActionsWithHttpInfo(uid, ddid, mid, offset, count, startDate, endDate, order);
        return resp.getData();
    }

    public ApiResponse<NormalizedActionsEnvelope> getNormalizedActionsWithHttpInfo(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        Call call = this.getNormalizedActionsValidateBeforeCall(uid, ddid, mid, offset, count, startDate, endDate, order, null, null);
        Type localVarReturnType = new TypeToken<NormalizedActionsEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNormalizedActionsAsync(String uid, String ddid, String mid, String offset, Integer count, Long startDate, Long endDate, String order, final ApiCallback<NormalizedActionsEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNormalizedActionsValidateBeforeCall(uid, ddid, mid, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedActionsEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getNormalizedMessagesCall(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/messages".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (uid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "uid", uid));
        }
        if (sdid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sdid", sdid));
        }
        if (mid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "mid", mid));
        }
        if (fieldPresence != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fieldPresence", fieldPresence));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endDate", endDate));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNormalizedMessagesValidateBeforeCall(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getNormalizedMessagesCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        return call;
    }

    public NormalizedMessagesEnvelope getNormalizedMessages(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        ApiResponse<NormalizedMessagesEnvelope> resp = this.getNormalizedMessagesWithHttpInfo(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order);
        return resp.getData();
    }

    public ApiResponse<NormalizedMessagesEnvelope> getNormalizedMessagesWithHttpInfo(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order) throws ApiException {
        Call call = this.getNormalizedMessagesValidateBeforeCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, null, null);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNormalizedMessagesAsync(String uid, String sdid, String mid, String fieldPresence, String filter, String offset, Integer count, Long startDate, Long endDate, String order, final ApiCallback<NormalizedMessagesEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNormalizedMessagesValidateBeforeCall(uid, sdid, mid, fieldPresence, filter, offset, count, startDate, endDate, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NormalizedMessagesEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call sendActionsCall(Actions data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Actions localVarPostBody = data;
        String localVarPath = "/actions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendActionsValidateBeforeCall(Actions data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling sendActions(Async)");
        }
        Call call = this.sendActionsCall(data, progressListener, progressRequestListener);
        return call;
    }

    public MessageIDEnvelope sendActions(Actions data) throws ApiException {
        ApiResponse<MessageIDEnvelope> resp = this.sendActionsWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<MessageIDEnvelope> sendActionsWithHttpInfo(Actions data) throws ApiException {
        Call call = this.sendActionsValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call sendActionsAsync(Actions data, final ApiCallback<MessageIDEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendActionsValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call sendMessageCall(Message data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Message localVarPostBody = data;
        String localVarPath = "/messages".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendMessageValidateBeforeCall(Message data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling sendMessage(Async)");
        }
        Call call = this.sendMessageCall(data, progressListener, progressRequestListener);
        return call;
    }

    public MessageIDEnvelope sendMessage(Message data) throws ApiException {
        ApiResponse<MessageIDEnvelope> resp = this.sendMessageWithHttpInfo(data);
        return resp.getData();
    }

    public ApiResponse<MessageIDEnvelope> sendMessageWithHttpInfo(Message data) throws ApiException {
        Call call = this.sendMessageValidateBeforeCall(data, null, null);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call sendMessageAsync(Message data, final ApiCallback<MessageIDEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendMessageValidateBeforeCall(data, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MessageIDEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

