/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.DevicePricingTierEnvelope;
import cloud.artik.model.DevicePricingTierRequest;
import cloud.artik.model.DevicePricingTiersEnvelope;
import cloud.artik.model.DeviceTypePricingTier;
import cloud.artik.model.DeviceTypePricingTiersEnvelope;
import cloud.artik.model.UpgradePathEnvelope;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class MonetizationApi {
    private ApiClient apiClient;

    public MonetizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MonetizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createPricingTiersCall(String dtid, DeviceTypePricingTier pricingTierInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceTypePricingTier localVarPostBody = pricingTierInfo;
        String localVarPath = "/pricing/devicetypes/{dtid}/pricingtiers".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createPricingTiersValidateBeforeCall(String dtid, DeviceTypePricingTier pricingTierInfo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling createPricingTiers(Async)");
        }
        if (pricingTierInfo == null) {
            throw new ApiException("Missing the required parameter 'pricingTierInfo' when calling createPricingTiers(Async)");
        }
        Call call = this.createPricingTiersCall(dtid, pricingTierInfo, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypePricingTier createPricingTiers(String dtid, DeviceTypePricingTier pricingTierInfo) throws ApiException {
        ApiResponse<DeviceTypePricingTier> resp = this.createPricingTiersWithHttpInfo(dtid, pricingTierInfo);
        return resp.getData();
    }

    public ApiResponse<DeviceTypePricingTier> createPricingTiersWithHttpInfo(String dtid, DeviceTypePricingTier pricingTierInfo) throws ApiException {
        Call call = this.createPricingTiersValidateBeforeCall(dtid, pricingTierInfo, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypePricingTier>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createPricingTiersAsync(String dtid, DeviceTypePricingTier pricingTierInfo, final ApiCallback<DeviceTypePricingTier> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPricingTiersValidateBeforeCall(dtid, pricingTierInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypePricingTier>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getPricingTiersCall(String did, Boolean active, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pricing/devices/{did}/pricingtiers".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (active != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "active", active));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPricingTiersValidateBeforeCall(String did, Boolean active, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling getPricingTiers(Async)");
        }
        Call call = this.getPricingTiersCall(did, active, progressListener, progressRequestListener);
        return call;
    }

    public DevicePricingTiersEnvelope getPricingTiers(String did, Boolean active) throws ApiException {
        ApiResponse<DevicePricingTiersEnvelope> resp = this.getPricingTiersWithHttpInfo(did, active);
        return resp.getData();
    }

    public ApiResponse<DevicePricingTiersEnvelope> getPricingTiersWithHttpInfo(String did, Boolean active) throws ApiException {
        Call call = this.getPricingTiersValidateBeforeCall(did, active, null, null);
        Type localVarReturnType = new TypeToken<DevicePricingTiersEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPricingTiersAsync(String did, Boolean active, final ApiCallback<DevicePricingTiersEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPricingTiersValidateBeforeCall(did, active, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DevicePricingTiersEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getThePricingTiersCall(String dtid, Integer version, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pricing/devicetypes/{dtid}/pricingtiers".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getThePricingTiersValidateBeforeCall(String dtid, Integer version, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getThePricingTiers(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getThePricingTiers(Async)");
        }
        Call call = this.getThePricingTiersCall(dtid, version, progressListener, progressRequestListener);
        return call;
    }

    public DeviceTypePricingTiersEnvelope getThePricingTiers(String dtid, Integer version) throws ApiException {
        ApiResponse<DeviceTypePricingTiersEnvelope> resp = this.getThePricingTiersWithHttpInfo(dtid, version);
        return resp.getData();
    }

    public ApiResponse<DeviceTypePricingTiersEnvelope> getThePricingTiersWithHttpInfo(String dtid, Integer version) throws ApiException {
        Call call = this.getThePricingTiersValidateBeforeCall(dtid, version, null, null);
        Type localVarReturnType = new TypeToken<DeviceTypePricingTiersEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getThePricingTiersAsync(String dtid, Integer version, final ApiCallback<DeviceTypePricingTiersEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getThePricingTiersValidateBeforeCall(dtid, version, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceTypePricingTiersEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUpgradePathCall(String did, String action, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/pricing/devices/{did}/revenueshare/upgradepath".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString())).replaceAll("\\{action\\}", this.apiClient.escapeString(action.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUpgradePathValidateBeforeCall(String did, String action, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling getUpgradePath(Async)");
        }
        if (action == null) {
            throw new ApiException("Missing the required parameter 'action' when calling getUpgradePath(Async)");
        }
        Call call = this.getUpgradePathCall(did, action, progressListener, progressRequestListener);
        return call;
    }

    public UpgradePathEnvelope getUpgradePath(String did, String action) throws ApiException {
        ApiResponse<UpgradePathEnvelope> resp = this.getUpgradePathWithHttpInfo(did, action);
        return resp.getData();
    }

    public ApiResponse<UpgradePathEnvelope> getUpgradePathWithHttpInfo(String did, String action) throws ApiException {
        Call call = this.getUpgradePathValidateBeforeCall(did, action, null, null);
        Type localVarReturnType = new TypeToken<UpgradePathEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUpgradePathAsync(String did, String action, final ApiCallback<UpgradePathEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUpgradePathValidateBeforeCall(did, action, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpgradePathEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call setPricingTierCall(String did, DevicePricingTierRequest pricingTier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DevicePricingTierRequest localVarPostBody = pricingTier;
        String localVarPath = "/pricing/devices/{did}/pricingtiers".replaceAll("\\{format\\}", "json").replaceAll("\\{did\\}", this.apiClient.escapeString(did.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setPricingTierValidateBeforeCall(String did, DevicePricingTierRequest pricingTier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (did == null) {
            throw new ApiException("Missing the required parameter 'did' when calling setPricingTier(Async)");
        }
        if (pricingTier == null) {
            throw new ApiException("Missing the required parameter 'pricingTier' when calling setPricingTier(Async)");
        }
        Call call = this.setPricingTierCall(did, pricingTier, progressListener, progressRequestListener);
        return call;
    }

    public DevicePricingTierEnvelope setPricingTier(String did, DevicePricingTierRequest pricingTier) throws ApiException {
        ApiResponse<DevicePricingTierEnvelope> resp = this.setPricingTierWithHttpInfo(did, pricingTier);
        return resp.getData();
    }

    public ApiResponse<DevicePricingTierEnvelope> setPricingTierWithHttpInfo(String did, DevicePricingTierRequest pricingTier) throws ApiException {
        Call call = this.setPricingTierValidateBeforeCall(did, pricingTier, null, null);
        Type localVarReturnType = new TypeToken<DevicePricingTierEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setPricingTierAsync(String did, DevicePricingTierRequest pricingTier, final ApiCallback<DevicePricingTierEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setPricingTierValidateBeforeCall(did, pricingTier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DevicePricingTierEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

