/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.DeviceRegConfirmUserRequest;
import cloud.artik.model.DeviceRegConfirmUserResponseEnvelope;
import cloud.artik.model.DeviceRegStatusResponseEnvelope;
import cloud.artik.model.UnregisterDeviceResponseEnvelope;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RegistrationsApi {
    private ApiClient apiClient;

    public RegistrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RegistrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call confirmUserCall(DeviceRegConfirmUserRequest registrationInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceRegConfirmUserRequest localVarPostBody = registrationInfo;
        String localVarPath = "/devices/registrations/pin".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call confirmUserValidateBeforeCall(DeviceRegConfirmUserRequest registrationInfo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (registrationInfo == null) {
            throw new ApiException("Missing the required parameter 'registrationInfo' when calling confirmUser(Async)");
        }
        Call call = this.confirmUserCall(registrationInfo, progressListener, progressRequestListener);
        return call;
    }

    public DeviceRegConfirmUserResponseEnvelope confirmUser(DeviceRegConfirmUserRequest registrationInfo) throws ApiException {
        ApiResponse<DeviceRegConfirmUserResponseEnvelope> resp = this.confirmUserWithHttpInfo(registrationInfo);
        return resp.getData();
    }

    public ApiResponse<DeviceRegConfirmUserResponseEnvelope> confirmUserWithHttpInfo(DeviceRegConfirmUserRequest registrationInfo) throws ApiException {
        Call call = this.confirmUserValidateBeforeCall(registrationInfo, null, null);
        Type localVarReturnType = new TypeToken<DeviceRegConfirmUserResponseEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call confirmUserAsync(DeviceRegConfirmUserRequest registrationInfo, final ApiCallback<DeviceRegConfirmUserResponseEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.confirmUserValidateBeforeCall(registrationInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceRegConfirmUserResponseEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getRequestStatusForUserCall(String requestId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/registrations/{requestId}/status".replaceAll("\\{format\\}", "json").replaceAll("\\{requestId\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRequestStatusForUserValidateBeforeCall(String requestId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (requestId == null) {
            throw new ApiException("Missing the required parameter 'requestId' when calling getRequestStatusForUser(Async)");
        }
        Call call = this.getRequestStatusForUserCall(requestId, progressListener, progressRequestListener);
        return call;
    }

    public DeviceRegStatusResponseEnvelope getRequestStatusForUser(String requestId) throws ApiException {
        ApiResponse<DeviceRegStatusResponseEnvelope> resp = this.getRequestStatusForUserWithHttpInfo(requestId);
        return resp.getData();
    }

    public ApiResponse<DeviceRegStatusResponseEnvelope> getRequestStatusForUserWithHttpInfo(String requestId) throws ApiException {
        Call call = this.getRequestStatusForUserValidateBeforeCall(requestId, null, null);
        Type localVarReturnType = new TypeToken<DeviceRegStatusResponseEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRequestStatusForUserAsync(String requestId, final ApiCallback<DeviceRegStatusResponseEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRequestStatusForUserValidateBeforeCall(requestId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeviceRegStatusResponseEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call unregisterDeviceCall(String deviceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devices/{deviceId}/registrations".replaceAll("\\{format\\}", "json").replaceAll("\\{deviceId\\}", this.apiClient.escapeString(deviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unregisterDeviceValidateBeforeCall(String deviceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceId == null) {
            throw new ApiException("Missing the required parameter 'deviceId' when calling unregisterDevice(Async)");
        }
        Call call = this.unregisterDeviceCall(deviceId, progressListener, progressRequestListener);
        return call;
    }

    public UnregisterDeviceResponseEnvelope unregisterDevice(String deviceId) throws ApiException {
        ApiResponse<UnregisterDeviceResponseEnvelope> resp = this.unregisterDeviceWithHttpInfo(deviceId);
        return resp.getData();
    }

    public ApiResponse<UnregisterDeviceResponseEnvelope> unregisterDeviceWithHttpInfo(String deviceId) throws ApiException {
        Call call = this.unregisterDeviceValidateBeforeCall(deviceId, null, null);
        Type localVarReturnType = new TypeToken<UnregisterDeviceResponseEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unregisterDeviceAsync(String deviceId, final ApiCallback<UnregisterDeviceResponseEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unregisterDeviceValidateBeforeCall(deviceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnregisterDeviceResponseEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

