/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.NotifMessagesResponse;
import cloud.artik.model.SubscriptionEnvelope;
import cloud.artik.model.SubscriptionInfo;
import cloud.artik.model.SubscriptionsEnvelope;
import cloud.artik.model.ValidationCallbackInfo;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SubscriptionsApi {
    private ApiClient apiClient;

    public SubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call createSubscriptionCall(SubscriptionInfo subscriptionInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubscriptionInfo localVarPostBody = subscriptionInfo;
        String localVarPath = "/subscriptions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSubscriptionValidateBeforeCall(SubscriptionInfo subscriptionInfo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (subscriptionInfo == null) {
            throw new ApiException("Missing the required parameter 'subscriptionInfo' when calling createSubscription(Async)");
        }
        Call call = this.createSubscriptionCall(subscriptionInfo, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionEnvelope createSubscription(SubscriptionInfo subscriptionInfo) throws ApiException {
        ApiResponse<SubscriptionEnvelope> resp = this.createSubscriptionWithHttpInfo(subscriptionInfo);
        return resp.getData();
    }

    public ApiResponse<SubscriptionEnvelope> createSubscriptionWithHttpInfo(SubscriptionInfo subscriptionInfo) throws ApiException {
        Call call = this.createSubscriptionValidateBeforeCall(subscriptionInfo, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSubscriptionAsync(SubscriptionInfo subscriptionInfo, final ApiCallback<SubscriptionEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSubscriptionValidateBeforeCall(subscriptionInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteSubscriptionCall(String subId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/{subId}".replaceAll("\\{format\\}", "json").replaceAll("\\{subId\\}", this.apiClient.escapeString(subId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteSubscriptionValidateBeforeCall(String subId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (subId == null) {
            throw new ApiException("Missing the required parameter 'subId' when calling deleteSubscription(Async)");
        }
        Call call = this.deleteSubscriptionCall(subId, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionEnvelope deleteSubscription(String subId) throws ApiException {
        ApiResponse<SubscriptionEnvelope> resp = this.deleteSubscriptionWithHttpInfo(subId);
        return resp.getData();
    }

    public ApiResponse<SubscriptionEnvelope> deleteSubscriptionWithHttpInfo(String subId) throws ApiException {
        Call call = this.deleteSubscriptionValidateBeforeCall(subId, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteSubscriptionAsync(String subId, final ApiCallback<SubscriptionEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteSubscriptionValidateBeforeCall(subId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getAllSubscriptionsCall(String uid, Integer offset, Integer count, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (uid != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "uid", uid));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllSubscriptionsValidateBeforeCall(String uid, Integer offset, Integer count, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllSubscriptionsCall(uid, offset, count, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionsEnvelope getAllSubscriptions(String uid, Integer offset, Integer count) throws ApiException {
        ApiResponse<SubscriptionsEnvelope> resp = this.getAllSubscriptionsWithHttpInfo(uid, offset, count);
        return resp.getData();
    }

    public ApiResponse<SubscriptionsEnvelope> getAllSubscriptionsWithHttpInfo(String uid, Integer offset, Integer count) throws ApiException {
        Call call = this.getAllSubscriptionsValidateBeforeCall(uid, offset, count, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionsEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllSubscriptionsAsync(String uid, Integer offset, Integer count, final ApiCallback<SubscriptionsEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllSubscriptionsValidateBeforeCall(uid, offset, count, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionsEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getMessagesCall(String notifId, Integer offset, Integer count, String order, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/notifications/{notifId}/messages".replaceAll("\\{format\\}", "json").replaceAll("\\{notifId\\}", this.apiClient.escapeString(notifId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", order));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMessagesValidateBeforeCall(String notifId, Integer offset, Integer count, String order, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (notifId == null) {
            throw new ApiException("Missing the required parameter 'notifId' when calling getMessages(Async)");
        }
        Call call = this.getMessagesCall(notifId, offset, count, order, progressListener, progressRequestListener);
        return call;
    }

    public NotifMessagesResponse getMessages(String notifId, Integer offset, Integer count, String order) throws ApiException {
        ApiResponse<NotifMessagesResponse> resp = this.getMessagesWithHttpInfo(notifId, offset, count, order);
        return resp.getData();
    }

    public ApiResponse<NotifMessagesResponse> getMessagesWithHttpInfo(String notifId, Integer offset, Integer count, String order) throws ApiException {
        Call call = this.getMessagesValidateBeforeCall(notifId, offset, count, order, null, null);
        Type localVarReturnType = new TypeToken<NotifMessagesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMessagesAsync(String notifId, Integer offset, Integer count, String order, final ApiCallback<NotifMessagesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMessagesValidateBeforeCall(notifId, offset, count, order, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<NotifMessagesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getSubscriptionCall(String subId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions/{subId}".replaceAll("\\{format\\}", "json").replaceAll("\\{subId\\}", this.apiClient.escapeString(subId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSubscriptionValidateBeforeCall(String subId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (subId == null) {
            throw new ApiException("Missing the required parameter 'subId' when calling getSubscription(Async)");
        }
        Call call = this.getSubscriptionCall(subId, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionEnvelope getSubscription(String subId) throws ApiException {
        ApiResponse<SubscriptionEnvelope> resp = this.getSubscriptionWithHttpInfo(subId);
        return resp.getData();
    }

    public ApiResponse<SubscriptionEnvelope> getSubscriptionWithHttpInfo(String subId) throws ApiException {
        Call call = this.getSubscriptionValidateBeforeCall(subId, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSubscriptionAsync(String subId, final ApiCallback<SubscriptionEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSubscriptionValidateBeforeCall(subId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call validateSubscriptionCall(String subId, ValidationCallbackInfo validationCallbackRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ValidationCallbackInfo localVarPostBody = validationCallbackRequest;
        String localVarPath = "/subscriptions/{subId}/validate".replaceAll("\\{format\\}", "json").replaceAll("\\{subId\\}", this.apiClient.escapeString(subId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateSubscriptionValidateBeforeCall(String subId, ValidationCallbackInfo validationCallbackRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (subId == null) {
            throw new ApiException("Missing the required parameter 'subId' when calling validateSubscription(Async)");
        }
        if (validationCallbackRequest == null) {
            throw new ApiException("Missing the required parameter 'validationCallbackRequest' when calling validateSubscription(Async)");
        }
        Call call = this.validateSubscriptionCall(subId, validationCallbackRequest, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionEnvelope validateSubscription(String subId, ValidationCallbackInfo validationCallbackRequest) throws ApiException {
        ApiResponse<SubscriptionEnvelope> resp = this.validateSubscriptionWithHttpInfo(subId, validationCallbackRequest);
        return resp.getData();
    }

    public ApiResponse<SubscriptionEnvelope> validateSubscriptionWithHttpInfo(String subId, ValidationCallbackInfo validationCallbackRequest) throws ApiException {
        Call call = this.validateSubscriptionValidateBeforeCall(subId, validationCallbackRequest, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateSubscriptionAsync(String subId, ValidationCallbackInfo validationCallbackRequest, final ApiCallback<SubscriptionEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateSubscriptionValidateBeforeCall(subId, validationCallbackRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

