/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.api;

import cloud.artik.client.ApiCallback;
import cloud.artik.client.ApiClient;
import cloud.artik.client.ApiException;
import cloud.artik.client.ApiResponse;
import cloud.artik.client.Configuration;
import cloud.artik.client.Pair;
import cloud.artik.client.ProgressRequestBody;
import cloud.artik.client.ProgressResponseBody;
import cloud.artik.model.CertificateEnvelope;
import cloud.artik.model.DeviceTypeUpdateInput;
import cloud.artik.model.RejectedCSVRowsEnvelope;
import cloud.artik.model.UploadIdEnvelope;
import cloud.artik.model.UploadStatusEnvelope;
import cloud.artik.model.WhitelistEnvelope;
import cloud.artik.model.WhitelistResultEnvelope;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class WhitelistingApi {
    private ApiClient apiClient;

    public WhitelistingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WhitelistingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call deleteVdidCall(String dtid, String vdid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist/{vdid}".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString())).replaceAll("\\{vdid\\}", this.apiClient.escapeString(vdid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteVdidValidateBeforeCall(String dtid, String vdid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling deleteVdid(Async)");
        }
        if (vdid == null) {
            throw new ApiException("Missing the required parameter 'vdid' when calling deleteVdid(Async)");
        }
        Call call = this.deleteVdidCall(dtid, vdid, progressListener, progressRequestListener);
        return call;
    }

    public WhitelistEnvelope deleteVdid(String dtid, String vdid) throws ApiException {
        ApiResponse<WhitelistEnvelope> resp = this.deleteVdidWithHttpInfo(dtid, vdid);
        return resp.getData();
    }

    public ApiResponse<WhitelistEnvelope> deleteVdidWithHttpInfo(String dtid, String vdid) throws ApiException {
        Call call = this.deleteVdidValidateBeforeCall(dtid, vdid, null, null);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteVdidAsync(String dtid, String vdid, final ApiCallback<WhitelistEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteVdidValidateBeforeCall(dtid, vdid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call deleteWhitelistCertificateCall(String dtid, String cid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist/certificates/{cid}".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString())).replaceAll("\\{cid\\}", this.apiClient.escapeString(cid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWhitelistCertificateValidateBeforeCall(String dtid, String cid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling deleteWhitelistCertificate(Async)");
        }
        if (cid == null) {
            throw new ApiException("Missing the required parameter 'cid' when calling deleteWhitelistCertificate(Async)");
        }
        Call call = this.deleteWhitelistCertificateCall(dtid, cid, progressListener, progressRequestListener);
        return call;
    }

    public WhitelistEnvelope deleteWhitelistCertificate(String dtid, String cid) throws ApiException {
        ApiResponse<WhitelistEnvelope> resp = this.deleteWhitelistCertificateWithHttpInfo(dtid, cid);
        return resp.getData();
    }

    public ApiResponse<WhitelistEnvelope> deleteWhitelistCertificateWithHttpInfo(String dtid, String cid) throws ApiException {
        Call call = this.deleteWhitelistCertificateValidateBeforeCall(dtid, cid, null, null);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteWhitelistCertificateAsync(String dtid, String cid, final ApiCallback<WhitelistEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWhitelistCertificateValidateBeforeCall(dtid, cid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call enableWhitelistCall(String dtid, DeviceTypeUpdateInput deviceTypeUpdateInfo, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        DeviceTypeUpdateInput localVarPostBody = deviceTypeUpdateInfo;
        String localVarPath = "/devicetypes/:dtid/whitelist/enable".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call enableWhitelistValidateBeforeCall(String dtid, DeviceTypeUpdateInput deviceTypeUpdateInfo, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling enableWhitelist(Async)");
        }
        if (deviceTypeUpdateInfo == null) {
            throw new ApiException("Missing the required parameter 'deviceTypeUpdateInfo' when calling enableWhitelist(Async)");
        }
        Call call = this.enableWhitelistCall(dtid, deviceTypeUpdateInfo, progressListener, progressRequestListener);
        return call;
    }

    public WhitelistEnvelope enableWhitelist(String dtid, DeviceTypeUpdateInput deviceTypeUpdateInfo) throws ApiException {
        ApiResponse<WhitelistEnvelope> resp = this.enableWhitelistWithHttpInfo(dtid, deviceTypeUpdateInfo);
        return resp.getData();
    }

    public ApiResponse<WhitelistEnvelope> enableWhitelistWithHttpInfo(String dtid, DeviceTypeUpdateInput deviceTypeUpdateInfo) throws ApiException {
        Call call = this.enableWhitelistValidateBeforeCall(dtid, deviceTypeUpdateInfo, null, null);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call enableWhitelistAsync(String dtid, DeviceTypeUpdateInput deviceTypeUpdateInfo, final ApiCallback<WhitelistEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.enableWhitelistValidateBeforeCall(dtid, deviceTypeUpdateInfo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getRejectedRowListCall(String dtid, String uploadId, Integer count, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist/{uploadId}/rejectedRows".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString())).replaceAll("\\{uploadId\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRejectedRowListValidateBeforeCall(String dtid, String uploadId, Integer count, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getRejectedRowList(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling getRejectedRowList(Async)");
        }
        Call call = this.getRejectedRowListCall(dtid, uploadId, count, offset, progressListener, progressRequestListener);
        return call;
    }

    public RejectedCSVRowsEnvelope getRejectedRowList(String dtid, String uploadId, Integer count, Integer offset) throws ApiException {
        ApiResponse<RejectedCSVRowsEnvelope> resp = this.getRejectedRowListWithHttpInfo(dtid, uploadId, count, offset);
        return resp.getData();
    }

    public ApiResponse<RejectedCSVRowsEnvelope> getRejectedRowListWithHttpInfo(String dtid, String uploadId, Integer count, Integer offset) throws ApiException {
        Call call = this.getRejectedRowListValidateBeforeCall(dtid, uploadId, count, offset, null, null);
        Type localVarReturnType = new TypeToken<RejectedCSVRowsEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRejectedRowListAsync(String dtid, String uploadId, Integer count, Integer offset, final ApiCallback<RejectedCSVRowsEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRejectedRowListValidateBeforeCall(dtid, uploadId, count, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RejectedCSVRowsEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getUploadStatusCall(String dtid, String uploadId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist/{uploadId}/status".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString())).replaceAll("\\{uploadId\\}", this.apiClient.escapeString(uploadId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUploadStatusValidateBeforeCall(String dtid, String uploadId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getUploadStatus(Async)");
        }
        if (uploadId == null) {
            throw new ApiException("Missing the required parameter 'uploadId' when calling getUploadStatus(Async)");
        }
        Call call = this.getUploadStatusCall(dtid, uploadId, progressListener, progressRequestListener);
        return call;
    }

    public UploadStatusEnvelope getUploadStatus(String dtid, String uploadId) throws ApiException {
        ApiResponse<UploadStatusEnvelope> resp = this.getUploadStatusWithHttpInfo(dtid, uploadId);
        return resp.getData();
    }

    public ApiResponse<UploadStatusEnvelope> getUploadStatusWithHttpInfo(String dtid, String uploadId) throws ApiException {
        Call call = this.getUploadStatusValidateBeforeCall(dtid, uploadId, null, null);
        Type localVarReturnType = new TypeToken<UploadStatusEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUploadStatusAsync(String dtid, String uploadId, final ApiCallback<UploadStatusEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUploadStatusValidateBeforeCall(dtid, uploadId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UploadStatusEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getWhitelistCall(String dtid, Integer count, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (count != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWhitelistValidateBeforeCall(String dtid, Integer count, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getWhitelist(Async)");
        }
        Call call = this.getWhitelistCall(dtid, count, offset, progressListener, progressRequestListener);
        return call;
    }

    public WhitelistResultEnvelope getWhitelist(String dtid, Integer count, Integer offset) throws ApiException {
        ApiResponse<WhitelistResultEnvelope> resp = this.getWhitelistWithHttpInfo(dtid, count, offset);
        return resp.getData();
    }

    public ApiResponse<WhitelistResultEnvelope> getWhitelistWithHttpInfo(String dtid, Integer count, Integer offset) throws ApiException {
        Call call = this.getWhitelistValidateBeforeCall(dtid, count, offset, null, null);
        Type localVarReturnType = new TypeToken<WhitelistResultEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWhitelistAsync(String dtid, Integer count, Integer offset, final ApiCallback<WhitelistResultEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWhitelistValidateBeforeCall(dtid, count, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WhitelistResultEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getWhitelistCertificateCall(String dtid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist/certificates".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWhitelistCertificateValidateBeforeCall(String dtid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getWhitelistCertificate(Async)");
        }
        Call call = this.getWhitelistCertificateCall(dtid, progressListener, progressRequestListener);
        return call;
    }

    public CertificateEnvelope getWhitelistCertificate(String dtid) throws ApiException {
        ApiResponse<CertificateEnvelope> resp = this.getWhitelistCertificateWithHttpInfo(dtid);
        return resp.getData();
    }

    public ApiResponse<CertificateEnvelope> getWhitelistCertificateWithHttpInfo(String dtid) throws ApiException {
        Call call = this.getWhitelistCertificateValidateBeforeCall(dtid, null, null);
        Type localVarReturnType = new TypeToken<CertificateEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWhitelistCertificateAsync(String dtid, final ApiCallback<CertificateEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWhitelistCertificateValidateBeforeCall(dtid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CertificateEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call getWhitelistStatusCall(String dtid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/devicetypes/{dtid}/whitelist/status".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWhitelistStatusValidateBeforeCall(String dtid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling getWhitelistStatus(Async)");
        }
        Call call = this.getWhitelistStatusCall(dtid, progressListener, progressRequestListener);
        return call;
    }

    public WhitelistEnvelope getWhitelistStatus(String dtid) throws ApiException {
        ApiResponse<WhitelistEnvelope> resp = this.getWhitelistStatusWithHttpInfo(dtid);
        return resp.getData();
    }

    public ApiResponse<WhitelistEnvelope> getWhitelistStatusWithHttpInfo(String dtid) throws ApiException {
        Call call = this.getWhitelistStatusValidateBeforeCall(dtid, null, null);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWhitelistStatusAsync(String dtid, final ApiCallback<WhitelistEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWhitelistStatusValidateBeforeCall(dtid, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WhitelistEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call uploadCSVCall(String dtid, byte[] file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        byte[] localVarPostBody = file;
        String localVarPath = "/devicetypes/{dtid}/whitelist".replaceAll("\\{format\\}", "json").replaceAll("\\{dtid\\}", this.apiClient.escapeString(dtid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"artikcloud_oauth"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call uploadCSVValidateBeforeCall(String dtid, byte[] file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dtid == null) {
            throw new ApiException("Missing the required parameter 'dtid' when calling uploadCSV(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadCSV(Async)");
        }
        Call call = this.uploadCSVCall(dtid, file, progressListener, progressRequestListener);
        return call;
    }

    public UploadIdEnvelope uploadCSV(String dtid, byte[] file) throws ApiException {
        ApiResponse<UploadIdEnvelope> resp = this.uploadCSVWithHttpInfo(dtid, file);
        return resp.getData();
    }

    public ApiResponse<UploadIdEnvelope> uploadCSVWithHttpInfo(String dtid, byte[] file) throws ApiException {
        Call call = this.uploadCSVValidateBeforeCall(dtid, file, null, null);
        Type localVarReturnType = new TypeToken<UploadIdEnvelope>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call uploadCSVAsync(String dtid, byte[] file, final ApiCallback<UploadIdEnvelope> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.uploadCSVValidateBeforeCall(dtid, file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UploadIdEnvelope>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

