/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.model;

import cloud.artik.model.Tag;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Device Type Information")
public class DeviceType {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="uniqueName")
    private String uniqueName = null;
    @SerializedName(value="latestVersion")
    private Integer latestVersion = null;
    @SerializedName(value="lastUpdated")
    private Long lastUpdated = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="uid")
    private String uid = null;
    @SerializedName(value="oid")
    private String oid = null;
    @SerializedName(value="hasCloudConnector")
    private Boolean hasCloudConnector = null;
    @SerializedName(value="approved")
    private Boolean approved = null;
    @SerializedName(value="published")
    private Boolean published = null;
    @SerializedName(value="protected")
    private Boolean _protected = null;
    @SerializedName(value="inStore")
    private Boolean inStore = null;
    @SerializedName(value="ownedByCurrentUser")
    private Boolean ownedByCurrentUser = null;
    @SerializedName(value="tags")
    private List<Tag> tags = new ArrayList<Tag>();
    @SerializedName(value="rsp")
    private Boolean rsp = null;
    @SerializedName(value="issuerDn")
    private String issuerDn = null;
    @SerializedName(value="vid")
    private String vid = null;

    public DeviceType id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Device Type ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DeviceType uniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique Name.")
    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public DeviceType latestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest Manifest version.")
    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
    }

    public DeviceType lastUpdated(Long lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DeviceType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DeviceType uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(example="null", value="User ID.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public DeviceType oid(String oid) {
        this.oid = oid;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization ID.")
    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public DeviceType hasCloudConnector(Boolean hasCloudConnector) {
        this.hasCloudConnector = hasCloudConnector;
        return this;
    }

    @ApiModelProperty(example="null", value="Uses Cloud Connectors SDK")
    public Boolean getHasCloudConnector() {
        return this.hasCloudConnector;
    }

    public void setHasCloudConnector(Boolean hasCloudConnector) {
        this.hasCloudConnector = hasCloudConnector;
    }

    public DeviceType approved(Boolean approved) {
        this.approved = approved;
        return this;
    }

    @ApiModelProperty(example="null", value="Approval status.")
    public Boolean getApproved() {
        return this.approved;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public DeviceType published(Boolean published) {
        this.published = published;
        return this;
    }

    @ApiModelProperty(example="null", value="Published status.")
    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public DeviceType _protected(Boolean _protected) {
        this._protected = _protected;
        return this;
    }

    @ApiModelProperty(example="null", value="Protected status.")
    public Boolean getProtected() {
        return this._protected;
    }

    public void setProtected(Boolean _protected) {
        this._protected = _protected;
    }

    public DeviceType inStore(Boolean inStore) {
        this.inStore = inStore;
        return this;
    }

    @ApiModelProperty(example="null", value="In Store.")
    public Boolean getInStore() {
        return this.inStore;
    }

    public void setInStore(Boolean inStore) {
        this.inStore = inStore;
    }

    public DeviceType ownedByCurrentUser(Boolean ownedByCurrentUser) {
        this.ownedByCurrentUser = ownedByCurrentUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Does the current user own a device of this device type")
    public Boolean getOwnedByCurrentUser() {
        return this.ownedByCurrentUser;
    }

    public void setOwnedByCurrentUser(Boolean ownedByCurrentUser) {
        this.ownedByCurrentUser = ownedByCurrentUser;
    }

    public DeviceType tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public DeviceType addTagsItem(Tag tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Tags")
    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public DeviceType rsp(Boolean rsp) {
        this.rsp = rsp;
        return this;
    }

    @ApiModelProperty(example="null", value="Require Secure Device Registration (SDR) Protocol.")
    public Boolean getRsp() {
        return this.rsp;
    }

    public void setRsp(Boolean rsp) {
        this.rsp = rsp;
    }

    public DeviceType issuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
        return this;
    }

    @ApiModelProperty(example="null", value="Issuer Distinguished Name (Used in SDR)")
    public String getIssuerDn() {
        return this.issuerDn;
    }

    public void setIssuerDn(String issuerDn) {
        this.issuerDn = issuerDn;
    }

    public DeviceType vid(String vid) {
        this.vid = vid;
        return this;
    }

    @ApiModelProperty(example="null", value="Vendor ID. (Used in SDR)")
    public String getVid() {
        return this.vid;
    }

    public void setVid(String vid) {
        this.vid = vid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceType deviceType = (DeviceType)o;
        return Objects.equals(this.id, deviceType.id) && Objects.equals(this.uniqueName, deviceType.uniqueName) && Objects.equals(this.latestVersion, deviceType.latestVersion) && Objects.equals(this.lastUpdated, deviceType.lastUpdated) && Objects.equals(this.name, deviceType.name) && Objects.equals(this.description, deviceType.description) && Objects.equals(this.uid, deviceType.uid) && Objects.equals(this.oid, deviceType.oid) && Objects.equals(this.hasCloudConnector, deviceType.hasCloudConnector) && Objects.equals(this.approved, deviceType.approved) && Objects.equals(this.published, deviceType.published) && Objects.equals(this._protected, deviceType._protected) && Objects.equals(this.inStore, deviceType.inStore) && Objects.equals(this.ownedByCurrentUser, deviceType.ownedByCurrentUser) && Objects.equals(this.tags, deviceType.tags) && Objects.equals(this.rsp, deviceType.rsp) && Objects.equals(this.issuerDn, deviceType.issuerDn) && Objects.equals(this.vid, deviceType.vid);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uniqueName, this.latestVersion, this.lastUpdated, this.name, this.description, this.uid, this.oid, this.hasCloudConnector, this.approved, this.published, this._protected, this.inStore, this.ownedByCurrentUser, this.tags, this.rsp, this.issuerDn, this.vid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceType {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uniqueName: ").append(this.toIndentedString(this.uniqueName)).append("\n");
        sb.append("    latestVersion: ").append(this.toIndentedString(this.latestVersion)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    oid: ").append(this.toIndentedString(this.oid)).append("\n");
        sb.append("    hasCloudConnector: ").append(this.toIndentedString(this.hasCloudConnector)).append("\n");
        sb.append("    approved: ").append(this.toIndentedString(this.approved)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    _protected: ").append(this.toIndentedString(this._protected)).append("\n");
        sb.append("    inStore: ").append(this.toIndentedString(this.inStore)).append("\n");
        sb.append("    ownedByCurrentUser: ").append(this.toIndentedString(this.ownedByCurrentUser)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    rsp: ").append(this.toIndentedString(this.rsp)).append("\n");
        sb.append("    issuerDn: ").append(this.toIndentedString(this.issuerDn)).append("\n");
        sb.append("    vid: ").append(this.toIndentedString(this.vid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

