/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Message received by a WebSocket.")
public class MessageOut {
    @SerializedName(value="data")
    private Map<String, Object> data = new HashMap<String, Object>();
    @SerializedName(value="cid")
    private String cid = null;
    @SerializedName(value="ddid")
    private String ddid = null;
    @SerializedName(value="sdid")
    private String sdid = null;
    @SerializedName(value="ts")
    private Long ts = null;
    @SerializedName(value="type")
    private String type = "message";
    @SerializedName(value="mid")
    private String mid = null;
    @SerializedName(value="uid")
    private String uid = null;
    @SerializedName(value="sdtid")
    private String sdtid = null;
    @SerializedName(value="cts")
    private Long cts = null;
    @SerializedName(value="mv")
    private Integer mv = null;

    public MessageOut data(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public MessageOut putDataItem(String key, Object dataItem) {
        this.data.put(key, dataItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Message Payload.")
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public MessageOut cid(String cid) {
        this.cid = cid;
        return this;
    }

    @ApiModelProperty(example="null", value="Confirmation ID.")
    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public MessageOut ddid(String ddid) {
        this.ddid = ddid;
        return this;
    }

    @ApiModelProperty(example="null", value="Destination Device ID.")
    public String getDdid() {
        return this.ddid;
    }

    public void setDdid(String ddid) {
        this.ddid = ddid;
    }

    public MessageOut sdid(String sdid) {
        this.sdid = sdid;
        return this;
    }

    @ApiModelProperty(example="null", value="Source Device ID.")
    public String getSdid() {
        return this.sdid;
    }

    public void setSdid(String sdid) {
        this.sdid = sdid;
    }

    public MessageOut ts(Long ts) {
        this.ts = ts;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp (past, present or future). Defaults to current time if not provided.")
    public Long getTs() {
        return this.ts;
    }

    public void setTs(Long ts) {
        this.ts = ts;
    }

    public MessageOut type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Type.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public MessageOut mid(String mid) {
        this.mid = mid;
        return this;
    }

    @ApiModelProperty(example="null", value="Message ID.")
    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public MessageOut uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(example="null", value="User ID.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public MessageOut sdtid(String sdtid) {
        this.sdtid = sdtid;
        return this;
    }

    @ApiModelProperty(example="null", value="Source Device Type ID.")
    public String getSdtid() {
        return this.sdtid;
    }

    public void setSdtid(String sdtid) {
        this.sdtid = sdtid;
    }

    public MessageOut cts(Long cts) {
        this.cts = cts;
        return this;
    }

    @ApiModelProperty(example="null", value="Created Timestamp (past, present or future). Defaults to current time if not provided.")
    public Long getCts() {
        return this.cts;
    }

    public void setCts(Long cts) {
        this.cts = cts;
    }

    public MessageOut mv(Integer mv) {
        this.mv = mv;
        return this;
    }

    @ApiModelProperty(example="null", value="Manifest Version.")
    public Integer getMv() {
        return this.mv;
    }

    public void setMv(Integer mv) {
        this.mv = mv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageOut messageOut = (MessageOut)o;
        return Objects.equals(this.data, messageOut.data) && Objects.equals(this.cid, messageOut.cid) && Objects.equals(this.ddid, messageOut.ddid) && Objects.equals(this.sdid, messageOut.sdid) && Objects.equals(this.ts, messageOut.ts) && Objects.equals(this.type, messageOut.type) && Objects.equals(this.mid, messageOut.mid) && Objects.equals(this.uid, messageOut.uid) && Objects.equals(this.sdtid, messageOut.sdtid) && Objects.equals(this.cts, messageOut.cts) && Objects.equals(this.mv, messageOut.mv);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.cid, this.ddid, this.sdid, this.ts, this.type, this.mid, this.uid, this.sdtid, this.cts, this.mv);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageOut {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    cid: ").append(this.toIndentedString(this.cid)).append("\n");
        sb.append("    ddid: ").append(this.toIndentedString(this.ddid)).append("\n");
        sb.append("    sdid: ").append(this.toIndentedString(this.sdid)).append("\n");
        sb.append("    ts: ").append(this.toIndentedString(this.ts)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    mid: ").append(this.toIndentedString(this.mid)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    sdtid: ").append(this.toIndentedString(this.sdtid)).append("\n");
        sb.append("    cts: ").append(this.toIndentedString(this.cts)).append("\n");
        sb.append("    mv: ").append(this.toIndentedString(this.mv)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

