/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.mqtt;

import cloud.artik.mqtt.ArtikCloudMqttCallback;
import cloud.artik.mqtt.ArtikCloudMqttException;
import cloud.artik.mqtt.OperationMode;
import cloud.artik.mqtt.Topics;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttSession {
    private static final String PUBLISH_TOPIC_MESSAGES_BASE = "/v1.1/messages/";
    private static final String SUBSCRIBE_TOPIC_ACTIONS_BASE = "/v1.1/actions/";
    private static final String SUBSCRIBE_TOPIC_ERRORS_BASE = "/v1.1/errors/";
    private static final String SCHEME = "ssl";
    private static final String HOST = "api.artik.cloud";
    private static final String PORT = "8883";
    private MqttAsyncClient mqttClient;
    private OperationListener operationListener;
    private MessageListener msgListener;
    private String deviceId;
    private String deviceToken;
    private String publishMessageTopicPath;
    private String subscribeActionsTopicPath;
    private String subscribeErrorTopicPath;
    private String brokerUri;

    public MqttSession(String deviceId, String deviceToken, ArtikCloudMqttCallback callback) throws ArtikCloudMqttException {
        this.operationListener = new OperationListener(callback);
        this.deviceId = deviceId;
        this.deviceToken = deviceToken;
        this.brokerUri = "ssl://api.artik.cloud:8883";
        this.publishMessageTopicPath = PUBLISH_TOPIC_MESSAGES_BASE + deviceId;
        this.subscribeActionsTopicPath = SUBSCRIBE_TOPIC_ACTIONS_BASE + deviceId;
        this.subscribeErrorTopicPath = SUBSCRIBE_TOPIC_ERRORS_BASE + deviceId;
        try {
            this.mqttClient = new MqttAsyncClient(this.brokerUri, deviceId, (MqttClientPersistence)new MemoryPersistence());
            this.msgListener = new MessageListener(callback);
            this.mqttClient.setCallback((MqttCallback)this.msgListener);
        }
        catch (MqttException e) {
            throw new ArtikCloudMqttException(e);
        }
    }

    public void connect() throws ArtikCloudMqttException {
        try {
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(true);
            connOpts.setUserName(this.deviceId);
            connOpts.setPassword(this.deviceToken.toCharArray());
            this.mqttClient.connect(connOpts, (Object)String.valueOf((Object)OperationMode.CONNECT), (IMqttActionListener)this.operationListener);
        }
        catch (Exception e) {
            throw new ArtikCloudMqttException(e);
        }
    }

    public void disconnect() throws ArtikCloudMqttException {
        try {
            this.mqttClient.disconnect(0L, (Object)String.valueOf((Object)OperationMode.DISCONNECT), (IMqttActionListener)this.operationListener);
        }
        catch (MqttException e) {
            throw new ArtikCloudMqttException(e);
        }
    }

    public void publish(int qos, String payload) throws ArtikCloudMqttException {
        MqttMessage mqttMessage = new MqttMessage(payload.getBytes());
        mqttMessage.setQos(qos);
        try {
            this.mqttClient.publish(this.publishMessageTopicPath, mqttMessage, (Object)String.valueOf((Object)OperationMode.PUBLISH), (IMqttActionListener)this.operationListener);
        }
        catch (MqttException e) {
            throw new ArtikCloudMqttException(e);
        }
    }

    @Deprecated
    public void subscribe() throws ArtikCloudMqttException {
        try {
            this.mqttClient.subscribe(this.subscribeActionsTopicPath, 0, (Object)String.valueOf((Object)OperationMode.SUBSCRIBE_ACTIONS), (IMqttActionListener)this.operationListener);
        }
        catch (MqttException e) {
            throw new ArtikCloudMqttException(e);
        }
    }

    public void subscribe(Topics topic) throws ArtikCloudMqttException {
        String path = "";
        OperationMode operationMode = null;
        switch (topic) {
            case SUBSCRIBE_TOPIC_ACTIONS: {
                path = SUBSCRIBE_TOPIC_ACTIONS_BASE + this.deviceId;
                operationMode = OperationMode.SUBSCRIBE_ACTIONS;
                break;
            }
            case SUBSCRIBE_TOPIC_ERRORS: {
                path = SUBSCRIBE_TOPIC_ERRORS_BASE + this.deviceId;
                operationMode = OperationMode.SUBSCRIBE_ERRORS;
            }
        }
        try {
            System.out.println(String.format("subscribe to: %s ", path));
            this.mqttClient.subscribe(path, 0, (Object)String.valueOf((Object)operationMode), (IMqttActionListener)this.operationListener);
        }
        catch (MqttException e) {
            throw new ArtikCloudMqttException(e);
        }
    }

    public boolean isConnected() {
        return this.mqttClient.isConnected();
    }

    public String getPublishTopic() {
        return this.publishMessageTopicPath;
    }

    public String getPublishTopicPath() {
        return this.publishMessageTopicPath;
    }

    public String getBrokerUri() {
        return this.brokerUri;
    }

    public String getSubscribeTopic() {
        return this.subscribeActionsTopicPath;
    }

    public String getSubscribeActionsTopicPath() {
        return this.subscribeActionsTopicPath;
    }

    public String getSubscribeErrorsTopicPath() {
        return this.subscribeErrorTopicPath;
    }

    private class MessageListener
    implements MqttCallback {
        ArtikCloudMqttCallback userCallback;

        MessageListener(ArtikCloudMqttCallback callback) {
            this.userCallback = callback;
        }

        public void connectionLost(final Throwable cause) {
            if (this.userCallback == null) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    MessageListener.this.userCallback.connectionLost(cause);
                }
            });
            t.start();
        }

        public void deliveryComplete(final IMqttDeliveryToken mqttDelToken) {
            if (this.userCallback == null) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    MessageListener.this.userCallback.deliveryComplete(mqttDelToken);
                }
            });
            t.start();
        }

        public void messageArrived(final String fromTopic, final MqttMessage mqttMessage) {
            if (this.userCallback == null) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    MessageListener.this.userCallback.messageArrived(fromTopic, mqttMessage);
                }
            });
            t.start();
        }
    }

    private class OperationListener
    implements IMqttActionListener {
        ArtikCloudMqttCallback userCallback;

        OperationListener(ArtikCloudMqttCallback callback) {
            this.userCallback = callback;
        }

        public void onFailure(final IMqttToken arg0, final Throwable arg1) {
            if (this.userCallback == null) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    OperationMode opMode = OperationListener.this.getOperationModeFromContext((String)arg0.getUserContext());
                    OperationListener.this.userCallback.onFailure(opMode, arg0, arg1);
                }
            });
            t.start();
        }

        public void onSuccess(final IMqttToken arg0) {
            if (this.userCallback == null) {
                return;
            }
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    OperationMode opMode = OperationListener.this.getOperationModeFromContext((String)arg0.getUserContext());
                    OperationListener.this.userCallback.onSuccess(opMode, arg0);
                }
            });
            t.start();
        }

        private OperationMode getOperationModeFromContext(String userContext) {
            OperationMode mode = OperationMode.UNKNOWN;
            if (userContext.equals(String.valueOf((Object)OperationMode.CONNECT))) {
                mode = OperationMode.CONNECT;
            } else if (userContext.equals(String.valueOf((Object)OperationMode.DISCONNECT))) {
                mode = OperationMode.DISCONNECT;
            } else if (userContext.equals(String.valueOf((Object)OperationMode.PUBLISH))) {
                mode = OperationMode.PUBLISH;
            } else if (userContext.equals(String.valueOf((Object)OperationMode.SUBSCRIBE_ACTIONS))) {
                mode = OperationMode.SUBSCRIBE_ACTIONS;
            } else if (userContext.equals(String.valueOf((Object)OperationMode.SUBSCRIBE_ERRORS))) {
                mode = OperationMode.SUBSCRIBE_ERRORS;
            }
            return mode;
        }
    }
}

