/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.websocket;

import cloud.artik.model.EventFeedData;
import cloud.artik.websocket.ArtikCloudWebSocketCallback;
import cloud.artik.websocket.EventFeedWebSocketCallback;
import cloud.artik.websocket.WebSocketProxy;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okio.BufferedSource;

public class EventFeedWebSocket
extends WebSocketProxy {
    private EventFeedWebSocketCallback eventCallback;

    public EventFeedWebSocket(String accessToken, String did, String dids, String uid, String events, ArtikCloudWebSocketCallback callback, EventFeedWebSocketCallback eventCallback) throws URISyntaxException, IOException {
        this(new OkHttpClient().newBuilder().readTimeout(35L, TimeUnit.SECONDS).build(), accessToken, did, dids, uid, events, callback, eventCallback);
        this.eventCallback = eventCallback;
    }

    public EventFeedWebSocket(OkHttpClient client, String accessToken, String did, String dids, String uid, String events, ArtikCloudWebSocketCallback callback, EventFeedWebSocketCallback eventCallback) throws URISyntaxException, IOException {
        super("/events" + EventFeedWebSocket.getQueryURI(accessToken, did, dids, uid, events), client, callback);
        this.eventCallback = eventCallback;
    }

    public void sendEvent(EventFeedData eventFeedData) throws IOException {
        super.sendObject(eventFeedData);
    }

    static String getQueryURI(String accessToken, String did, String dids, String uid, String events) {
        StringBuffer sb = new StringBuffer("?");
        if (accessToken != null) {
            sb.append("Authorization=bearer+").append(accessToken);
        }
        if (did != null) {
            sb.append("&did=").append(did);
        }
        if (dids != null) {
            sb.append("&dids=").append(dids);
        }
        if (uid != null) {
            sb.append("&uid=").append(uid);
        }
        if (events != null) {
            sb.append("&event=").append(events);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(ResponseBody response) throws IOException {
        try (BufferedSource source = response.source();){
            MediaType contentType = response.contentType();
            String message = source.readString(contentType.charset());
            Map jsonMap = (Map)this.json.getGson().fromJson(message, Map.class);
            if (jsonMap.containsKey("event")) {
                EventFeedData eventFeed = (EventFeedData)this.json.getGson().fromJson(message, EventFeedData.class);
                this.eventCallback.onEvent(eventFeed);
            } else {
                super.onMessage(response);
            }
        }
    }
}

