/*
 * Decompiled with CFR 0.152.
 */
package cloud.artik.websocket;

import cloud.artik.model.AckEnvelope;
import cloud.artik.model.ActionOut;
import cloud.artik.model.ErrorEnvelope;
import cloud.artik.model.MessageOut;
import cloud.artik.model.WebSocketError;
import cloud.artik.websocket.ArtikCloudWebSocketCallback;
import cloud.artik.websocket.ConnectionStatus;
import cloud.artik.websocket.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import okio.BufferedSource;

public class WebSocketProxy
implements WebSocketListener {
    protected Request request = null;
    protected WebSocket webSocket = null;
    protected ArtikCloudWebSocketCallback callback = null;
    protected OkHttpClient client = null;
    protected final JSON json = new JSON();
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    protected ConnectionStatus status = ConnectionStatus.CLOSED;
    protected CountDownLatch openSignal = null;
    protected CountDownLatch closeSignal = null;
    protected static String host = "wss://api.artik.cloud/v1.1";

    public WebSocketProxy(String url, OkHttpClient client, ArtikCloudWebSocketCallback callback) {
        this.request = new Request.Builder().url(host + url).build();
        this.client = client;
        this.callback = callback;
    }

    public static void setHost(String host) {
        WebSocketProxy.host = host;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.status;
    }

    public final void onOpen(WebSocket webSocket, Response response) {
        this.status = ConnectionStatus.CONNECTED;
        this.webSocket = webSocket;
        if (this.openSignal != null) {
            this.openSignal.countDown();
        }
        this.callback.onOpen(response.code(), response.message());
    }

    public final void onClose(int code, String reason) {
        if (this.closeSignal != null) {
            this.closeSignal.countDown();
        }
        this.status = ConnectionStatus.CLOSED;
        this.callback.onClose(code, reason, true);
    }

    public final void onFailure(IOException exc, Response response) {
        if (this.closeSignal != null) {
            this.closeSignal.countDown();
        }
        this.status = ConnectionStatus.CLOSED;
        WebSocketError error = new WebSocketError();
        if (response != null) {
            error.setCode(response.code());
            error.setMessage(response.message());
        } else {
            error.setCode(-1);
            if (exc.getCause() != null) {
                error.setMessage(this.asString(exc.getCause()));
            } else {
                error.setMessage(this.asString(exc));
            }
        }
        this.callback.onError(error);
    }

    protected String asString(Throwable exc) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exc.printStackTrace(pw);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ResponseBody response) throws IOException {
        try (BufferedSource source = response.source();){
            MediaType contentType = response.contentType();
            String message = source.readString(contentType.charset());
            Map jsonMap = (Map)this.json.getGson().fromJson(message, Map.class);
            if (jsonMap.containsKey("error")) {
                ErrorEnvelope artikError = (ErrorEnvelope)this.json.getGson().fromJson(message, ErrorEnvelope.class);
                this.callback.onError(artikError.getError());
            } else if (jsonMap.containsKey("type")) {
                String type = (String)jsonMap.get("type");
                if ("ping".equalsIgnoreCase(type)) {
                    long ts = ((Double)jsonMap.get("ts")).longValue();
                    this.callback.onPing(ts);
                } else if ("message".equalsIgnoreCase(type)) {
                    MessageOut artikMessage = (MessageOut)this.json.getGson().fromJson(message, MessageOut.class);
                    this.callback.onMessage(artikMessage);
                } else if ("action".equalsIgnoreCase(type)) {
                    ActionOut artikAction = (ActionOut)this.json.getGson().fromJson(message, ActionOut.class);
                    this.callback.onAction(artikAction);
                }
            } else if (jsonMap.containsKey("data") && jsonMap.containsKey("mid")) {
                MessageOut artikMessage = (MessageOut)this.json.getGson().fromJson(message, MessageOut.class);
                this.callback.onMessage(artikMessage);
            } else if (jsonMap.containsKey("data") && ((Map)jsonMap.get("data")).containsKey("mid") || ((Map)jsonMap.get("data")).containsKey("code")) {
                AckEnvelope ackEnv = (AckEnvelope)this.json.getGson().fromJson(message, AckEnvelope.class);
                this.callback.onAck(ackEnv.getData());
            } else {
                System.err.println("Un handled message: " + this.json);
            }
        }
    }

    public final void onPong(Buffer arg0) {
    }

    public final void connect() throws IOException {
        if (this.status != ConnectionStatus.CONNECTING) {
            this.status = ConnectionStatus.CONNECTING;
            WebSocketCall ws = WebSocketCall.create((OkHttpClient)this.client, (Request)this.request);
            ws.enqueue((WebSocketListener)this);
        }
    }

    public final void connectBlocking() throws IOException, InterruptedException {
        if (this.openSignal == null) {
            this.openSignal = new CountDownLatch(1);
        }
        this.connect();
        this.openSignal.await();
        this.openSignal = null;
    }

    public final void close() throws IOException {
        if (this.status != ConnectionStatus.CLOSING) {
            this.status = ConnectionStatus.CLOSING;
            this.webSocket.close(4999, "OK");
        }
    }

    public final void closeBlocking() throws IOException, InterruptedException {
        if (this.closeSignal == null) {
            this.closeSignal = new CountDownLatch(1);
        }
        this.close();
        this.closeSignal.await();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.dispatcher().executorService().awaitTermination(100L, TimeUnit.MILLISECONDS);
        this.closeSignal = null;
    }

    protected void sendObject(Object object) throws IOException {
        if (!this.client.dispatcher().executorService().isShutdown()) {
            RequestBody request = RequestBody.create((MediaType)WebSocket.TEXT, (String)this.json.getGson().toJson(object));
            this.webSocket.sendMessage(request);
        }
    }
}

