/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.annotations;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.CommandManager;
import cloud.commandframework.annotations.AnnotationParser;
import cloud.commandframework.annotations.Flag;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.flags.CommandFlag;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.parser.ParserRegistry;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.Permission;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

final class FlagExtractor
implements Function<Method, Collection<CommandFlag<?>>> {
    private final CommandManager<?> commandManager;
    private final AnnotationParser<?> annotationParser;

    FlagExtractor(@NonNull CommandManager<?> commandManager, @NonNull AnnotationParser<?> annotationParser) {
        this.commandManager = commandManager;
        this.annotationParser = annotationParser;
    }

    @Override
    public @NonNull Collection<@NonNull CommandFlag<?>> apply(@NonNull Method method) {
        LinkedList flags = new LinkedList();
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isAnnotationPresent(Flag.class)) continue;
            Flag flag = parameter.getAnnotation(Flag.class);
            String flagName = this.annotationParser.processString(flag.value());
            CommandFlag.Builder builder = this.commandManager.flagBuilder(this.annotationParser.processString(flagName)).withDescription(ArgumentDescription.of((String)this.annotationParser.processString(flag.description()))).withAliases(this.annotationParser.processStrings(flag.aliases())).withPermission((CommandPermission)Permission.of((String)this.annotationParser.processString(flag.permission())));
            if (flag.repeatable()) {
                builder = builder.asRepeatable();
            }
            if (parameter.getType().equals(Boolean.TYPE)) {
                flags.add(builder.build());
                continue;
            }
            TypeToken token = flag.repeatable() && Collection.class.isAssignableFrom(parameter.getType()) ? TypeToken.get((Type)GenericTypeReflector.getTypeParameter((Type)parameter.getParameterizedType(), Collection.class.getTypeParameters()[0])) : TypeToken.get(parameter.getType());
            if (token.equals((Object)TypeToken.get(Boolean.TYPE))) {
                flags.add(builder.build());
                continue;
            }
            List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
            ParserRegistry registry = this.commandManager.parserRegistry();
            String parserName = this.annotationParser.processString(flag.parserName());
            ArgumentParser parser = parserName.isEmpty() ? (ArgumentParser)registry.createParser(token, registry.parseAnnotations(token, annotations)).orElse(null) : (ArgumentParser)registry.createParser(parserName, registry.parseAnnotations(token, annotations)).orElse(null);
            if (parser == null) {
                throw new IllegalArgumentException(String.format("Cannot find parser for type '%s' for flag '%s' in method '%s'", parameter.getType().getCanonicalName(), flagName, method.getName()));
            }
            String suggestions = this.annotationParser.processString(flag.suggestions());
            BiFunction suggestionProvider = !suggestions.isEmpty() ? (BiFunction)registry.getSuggestionProvider(suggestions).orElse(null) : null;
            CommandArgument.Builder argumentBuilder0 = CommandArgument.ofType(parameter.getType(), (String)flagName);
            CommandArgument.Builder argumentBuilder = argumentBuilder0.asRequired().manager(this.commandManager).withParser(parser);
            CommandArgument argument = suggestionProvider != null ? argumentBuilder.withSuggestionsProvider(suggestionProvider).build() : argumentBuilder.build();
            flags.add(builder.withArgument(argument).build());
        }
        return flags;
    }
}

