/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.brigadier.argument;

import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.brigadier.argument.QueueAsStringReader;
import cloud.commandframework.brigadier.argument.StringReaderAsQueue;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class WrappedBrigadierParser<C, T>
implements ArgumentParser<C, T> {
    public static final String COMMAND_CONTEXT_BRIGADIER_NATIVE_SENDER = "_cloud_brigadier_native_sender";
    private final Supplier<ArgumentType<T>> nativeType;
    private final int expectedArgumentCount;
    private final @Nullable ParseFunction<T> parse;

    public WrappedBrigadierParser(ArgumentType<T> nativeType) {
        this(() -> nativeType, 1);
    }

    public WrappedBrigadierParser(Supplier<ArgumentType<T>> nativeType) {
        this(nativeType, 1);
    }

    public WrappedBrigadierParser(ArgumentType<T> nativeType, int expectedArgumentCount) {
        this(() -> nativeType, expectedArgumentCount);
    }

    public WrappedBrigadierParser(Supplier<ArgumentType<T>> nativeType, int expectedArgumentCount) {
        this(nativeType, expectedArgumentCount, null);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public WrappedBrigadierParser(Supplier<ArgumentType<T>> nativeType, int expectedArgumentCount, @Nullable ParseFunction<T> parse) {
        Objects.requireNonNull(nativeType, "brigadierType");
        this.nativeType = nativeType;
        this.expectedArgumentCount = expectedArgumentCount;
        this.parse = parse;
    }

    public ArgumentType<T> getNativeArgument() {
        return this.nativeType.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull cloud.commandframework.context.CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        Object reader = inputQueue instanceof StringReader ? (StringReader)inputQueue : (inputQueue instanceof StringReaderAsQueue ? ((StringReaderAsQueue)inputQueue).getOriginal() : new QueueAsStringReader(inputQueue));
        try {
            Object result = this.parse != null ? this.parse.apply(this.nativeType.get(), (StringReader)reader) : this.nativeType.get().parse(reader);
            ArgumentParseResult argumentParseResult = ArgumentParseResult.success((Object)result);
            return argumentParseResult;
        }
        catch (CommandSyntaxException ex) {
            ArgumentParseResult argumentParseResult = ArgumentParseResult.failure((Throwable)ex);
            return argumentParseResult;
        }
        finally {
            if (reader instanceof QueueAsStringReader) {
                ((QueueAsStringReader)((Object)reader)).updateQueue();
            }
        }
    }

    public @NonNull List<@NonNull String> suggestions(@NonNull cloud.commandframework.context.CommandContext<C> commandContext, @NonNull String input) {
        CommandContext reverseMappedContext = new CommandContext(commandContext.getOrDefault(COMMAND_CONTEXT_BRIGADIER_NATIVE_SENDER, commandContext.getSender()), commandContext.getRawInputJoined(), Collections.emptyMap(), null, null, Collections.emptyList(), StringRange.at((int)0), null, null, false);
        CompletableFuture result = this.nativeType.get().listSuggestions(reverseMappedContext, new SuggestionsBuilder(input, 0));
        List suggestions = ((Suggestions)result.join()).getList();
        ArrayList<String> out = new ArrayList<String>(suggestions.size());
        for (Suggestion suggestion : suggestions) {
            out.add(suggestion.getText());
        }
        return out;
    }

    public boolean isContextFree() {
        return true;
    }

    public int getRequestedArgumentCount() {
        return this.expectedArgumentCount;
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    @FunctionalInterface
    public static interface ParseFunction<T> {
        public T apply(ArgumentType<T> var1, StringReader var2) throws CommandSyntaxException;
    }
}

