/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.minecraft.extras;

import cloud.commandframework.ArgumentDescription;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RichDescription
implements ArgumentDescription {
    private static final RichDescription EMPTY = new RichDescription((Component)Component.empty());
    private final Component contents;

    RichDescription(Component contents) {
        this.contents = contents;
    }

    public static @NonNull RichDescription empty() {
        return EMPTY;
    }

    public static @NonNull RichDescription of(@NonNull ComponentLike contents) {
        Component componentContents = Objects.requireNonNull(contents, "contents").asComponent();
        if (Component.empty().equals(componentContents)) {
            return EMPTY;
        }
        return new RichDescription(componentContents);
    }

    public static @NonNull RichDescription translatable(@NonNull String key) {
        Objects.requireNonNull(key, "key");
        return new RichDescription((Component)Component.translatable((String)key));
    }

    public static @NonNull RichDescription translatable(@NonNull String key, ComponentLike ... args) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(args, "args");
        return new RichDescription((Component)Component.translatable((String)key, (ComponentLike[])args));
    }

    @Deprecated
    public @NonNull String getDescription() {
        return PlainComponentSerializer.plain().serialize(GlobalTranslator.render((Component)this.contents, (Locale)Locale.getDefault()));
    }

    public @NonNull Component getContents() {
        return this.contents;
    }

    public boolean isEmpty() {
        return Component.empty().equals(this.contents);
    }
}

