/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.minecraft.extras;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.captions.StandardCaptionKeys;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.exceptions.parsing.NoInputProvidedException;
import cloud.commandframework.exceptions.parsing.ParserException;
import cloud.commandframework.types.tuples.Pair;
import io.leangen.geantyref.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TextColorArgument<C>
extends CommandArgument<C, TextColor> {
    private static final Pattern LEGACY_PREDICATE = Pattern.compile("&[0-9a-fA-F]");
    private static final Pattern HEX_PREDICATE = Pattern.compile("#?([a-fA-F0-9]{1,6})");
    private static final Collection<Pair<Character, NamedTextColor>> COLORS = Arrays.asList(Pair.of((Object)Character.valueOf('0'), (Object)NamedTextColor.BLACK), Pair.of((Object)Character.valueOf('1'), (Object)NamedTextColor.DARK_BLUE), Pair.of((Object)Character.valueOf('2'), (Object)NamedTextColor.DARK_GREEN), Pair.of((Object)Character.valueOf('3'), (Object)NamedTextColor.DARK_GREEN), Pair.of((Object)Character.valueOf('4'), (Object)NamedTextColor.DARK_AQUA), Pair.of((Object)Character.valueOf('5'), (Object)NamedTextColor.DARK_PURPLE), Pair.of((Object)Character.valueOf('6'), (Object)NamedTextColor.GOLD), Pair.of((Object)Character.valueOf('7'), (Object)NamedTextColor.GRAY), Pair.of((Object)Character.valueOf('8'), (Object)NamedTextColor.DARK_GRAY), Pair.of((Object)Character.valueOf('9'), (Object)NamedTextColor.BLUE), Pair.of((Object)Character.valueOf('a'), (Object)NamedTextColor.GREEN), Pair.of((Object)Character.valueOf('b'), (Object)NamedTextColor.AQUA), Pair.of((Object)Character.valueOf('c'), (Object)NamedTextColor.RED), Pair.of((Object)Character.valueOf('d'), (Object)NamedTextColor.LIGHT_PURPLE), Pair.of((Object)Character.valueOf('e'), (Object)NamedTextColor.YELLOW), Pair.of((Object)Character.valueOf('f'), (Object)NamedTextColor.WHITE));

    private TextColorArgument(boolean required, @NonNull String name, @NonNull String defaultValue) {
        super(required, name, new TextColorParser(), defaultValue, TypeToken.get(TextColor.class), null, new LinkedList());
    }

    public static <C> @NonNull TextColorArgument<C> of(@NonNull String name) {
        return new TextColorArgument<C>(true, name, "");
    }

    public static <C> @NonNull TextColorArgument<C> optional(@NonNull String name) {
        return new TextColorArgument<C>(false, name, "");
    }

    public static <C> @NonNull TextColorArgument<C> optionalWithDefault(@NonNull String name, @NonNull String defaultValue) {
        return new TextColorArgument<C>(false, name, defaultValue);
    }

    public static final class TextColorParser<C>
    implements ArgumentParser<C, TextColor> {
        public @NonNull ArgumentParseResult<@NonNull TextColor> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure((Throwable)new NoInputProvidedException(TextColorParser.class, commandContext));
            }
            if (LEGACY_PREDICATE.matcher(input).matches()) {
                char code = input.substring(1).toLowerCase().charAt(0);
                for (Pair pair : COLORS) {
                    if (((Character)pair.getFirst()).charValue() != code) continue;
                    inputQueue.remove();
                    return ArgumentParseResult.success((Object)((TextColor)pair.getSecond()));
                }
            }
            for (Pair pair : COLORS) {
                if (!((NamedTextColor)pair.getSecond()).toString().equalsIgnoreCase(input)) continue;
                inputQueue.remove();
                return ArgumentParseResult.success((Object)((TextColor)pair.getSecond()));
            }
            if (HEX_PREDICATE.matcher(input).matches()) {
                inputQueue.remove();
                return ArgumentParseResult.success((Object)TextColor.color((int)Integer.parseInt(input.startsWith("#") ? input.substring(1) : input, 16)));
            }
            return ArgumentParseResult.failure((Throwable)((Object)new TextColorParseException(commandContext, input)));
        }

        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            LinkedList<String> suggestions = new LinkedList<String>();
            if (input.isEmpty() || input.equals("#") || HEX_PREDICATE.matcher(input).matches() && input.length() < (input.startsWith("#") ? 7 : 6)) {
                char c;
                for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
                    suggestions.add(String.format("%s%c", input, Character.valueOf(c)));
                    suggestions.add(String.format("&%c", Character.valueOf(c)));
                }
                for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                    suggestions.add(String.format("%s%c", input, Character.valueOf(c)));
                    suggestions.add(String.format("&%c", Character.valueOf(c)));
                }
            }
            suggestions.addAll(NamedTextColor.NAMES.keys());
            return suggestions;
        }
    }

    private static final class TextColorParseException
    extends ParserException {
        private static final long serialVersionUID = -6236625328843879518L;

        private TextColorParseException(@NonNull CommandContext<?> commandContext, @NonNull String input) {
            super(TextColorParser.class, commandContext, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_COLOR, new CaptionVariable[]{CaptionVariable.of((String)"input", (String)input)});
        }
    }
}

