/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.paper;

import cloud.commandframework.CommandTree;
import cloud.commandframework.brigadier.CloudBrigadierManager;
import cloud.commandframework.bukkit.BukkitBrigadierMapper;
import cloud.commandframework.bukkit.internal.BukkitBackwardsBrigadierSenderMapper;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.paper.PaperBrigadierMapper;
import cloud.commandframework.paper.PaperCommandManager;
import cloud.commandframework.permission.CommandPermission;
import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.destroystokyo.paper.event.brigadier.CommandRegisteredEvent;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.lang.reflect.Method;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class PaperBrigadierListener<C>
implements Listener {
    private static final @Nullable Method SET_RAW;
    private final CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager;
    private final PaperCommandManager<C> paperCommandManager;

    PaperBrigadierListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
        this.brigadierManager = new CloudBrigadierManager(this.paperCommandManager, () -> new CommandContext(this.paperCommandManager.getCommandSenderMapper().apply(Bukkit.getConsoleSender()), this.paperCommandManager));
        this.brigadierManager.brigadierSenderMapper(sender -> this.paperCommandManager.getCommandSenderMapper().apply(sender.getBukkitSender()));
        new PaperBrigadierMapper(new BukkitBrigadierMapper(this.paperCommandManager, this.brigadierManager));
        this.brigadierManager.backwardsBrigadierSenderMapper((Function)new BukkitBackwardsBrigadierSenderMapper(this.paperCommandManager));
    }

    protected @NonNull CloudBrigadierManager<C, BukkitBrigadierCommandSource> brigadierManager() {
        return this.brigadierManager;
    }

    @EventHandler
    public void onCommandRegister(@NonNull CommandRegisteredEvent<BukkitBrigadierCommandSource> event) {
        String label;
        if (!(event.getCommand() instanceof PluginIdentifiableCommand)) {
            return;
        }
        if (!((PluginIdentifiableCommand)event.getCommand()).getPlugin().equals(this.paperCommandManager.getOwningPlugin())) {
            return;
        }
        CommandTree commandTree = this.paperCommandManager.commandTree();
        CommandTree.Node node = commandTree.getNamedNode(label = event.getCommandLabel().contains(":") ? event.getCommandLabel().split(Pattern.quote(":"))[1] : event.getCommandLabel());
        if (node == null) {
            return;
        }
        BiPredicate<BukkitBrigadierCommandSource, CommandPermission> permissionChecker = (s, p) -> {
            if (commandTree.getNamedNode(label) == null) {
                return false;
            }
            Object sender = this.paperCommandManager.getCommandSenderMapper().apply(s.getBukkitSender());
            return this.paperCommandManager.hasPermission(sender, (CommandPermission)p);
        };
        event.setLiteral(this.brigadierManager.createLiteralCommandNode(node, event.getLiteral(), (SuggestionProvider)event.getBrigadierCommand(), (Command)event.getBrigadierCommand(), permissionChecker));
        if (SET_RAW != null) {
            try {
                SET_RAW.invoke(event, true);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static {
        Method mth;
        try {
            mth = CommandRegisteredEvent.class.getDeclaredMethod("setRawCommand", Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            mth = null;
        }
        SET_RAW = mth;
    }
}

