/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.daikon.ppt;

import cloud.filibuster.daikon.DaikonPpt;
import cloud.filibuster.daikon.DaikonPptType;
import cloud.filibuster.daikon.ppt.DaikonGrpcProgramPointVariable;
import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.junit.server.core.transformers.JsonUtils;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class DaikonGrpcProgramPointRecord {
    private final String ppt;
    private final DaikonPptType daikonPptType;
    private final List<DaikonGrpcProgramPointVariable> variables;

    public DaikonGrpcProgramPointRecord(String fullMethodName, DaikonPptType daikonPptType, GeneratedMessageV3 requestMessage, @Nullable GeneratedMessageV3 responseMessage) {
        this.ppt = DaikonPpt.generatePpt(fullMethodName, daikonPptType, requestMessage);
        this.daikonPptType = daikonPptType;
        try {
            String key;
            Iterator keys;
            JSONObject jsonObject;
            String serializedMessage;
            ArrayList<DaikonGrpcProgramPointVariable> variables = new ArrayList<DaikonGrpcProgramPointVariable>();
            if (daikonPptType.equals((Object)DaikonPptType.ENTER) || daikonPptType.equals((Object)DaikonPptType.EXIT)) {
                variables.add(new DaikonGrpcProgramPointVariable("this", "variable", null, "java.lang.Object", "hashcode", "is_param nomod", "1"));
                serializedMessage = JsonFormat.printer().preservingProtoFieldNames().includingDefaultValueFields().print((MessageOrBuilder)requestMessage);
                jsonObject = new JSONObject(serializedMessage);
                jsonObject = JsonUtils.flatten(jsonObject);
                keys = jsonObject.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    variables.add(new DaikonGrpcProgramPointVariable("this." + key, "field " + key, "this", "java.lang.String", "java.lang.String", "nomod not_ordered to_string", "1"));
                }
            }
            if (daikonPptType.equals((Object)DaikonPptType.EXIT)) {
                variables.add(new DaikonGrpcProgramPointVariable("return", "return", null, "java.lang.Object", "hashcode", null, "1"));
                serializedMessage = JsonFormat.printer().preservingProtoFieldNames().includingDefaultValueFields().print((MessageOrBuilder)responseMessage);
                jsonObject = new JSONObject(serializedMessage);
                jsonObject = JsonUtils.flatten(jsonObject);
                keys = jsonObject.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    variables.add(new DaikonGrpcProgramPointVariable("return." + key, "field " + key, "return", "java.lang.String", "java.lang.String", "not_ordered to_string", "1"));
                }
            }
            this.variables = variables;
        }
        catch (Throwable t) {
            throw new FilibusterRuntimeException(t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ppt " + this.ppt + "\n");
        builder.append("ppt-type " + this.daikonPptType.toString().toLowerCase(Locale.ROOT) + "\n");
        for (DaikonGrpcProgramPointVariable variable : this.variables) {
            builder.append("variable " + variable.getName() + "\n");
            builder.append("  var-kind " + variable.getVarKind() + "\n");
            if (variable.getEnclosingVar() != null) {
                builder.append("  enclosing-var " + variable.getEnclosingVar() + "\n");
            }
            builder.append("  dec-type " + variable.getDecType() + "\n");
            builder.append("  rep-type " + variable.getRepType() + "\n");
            if (variable.getFlags() != null) {
                builder.append("  flags " + variable.getFlags() + "\n");
            }
            builder.append("  comparability " + variable.getComparability() + "\n");
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.ppt);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DaikonGrpcProgramPointRecord)) {
            return false;
        }
        DaikonGrpcProgramPointRecord r = (DaikonGrpcProgramPointRecord)o;
        return Objects.equals(this.ppt, r.ppt);
    }

    public static List<DaikonGrpcProgramPointRecord> onRequestAndResponse(String fullMethodName, GeneratedMessageV3 request, GeneratedMessageV3 response) {
        ArrayList<DaikonGrpcProgramPointRecord> declRecords = new ArrayList<DaikonGrpcProgramPointRecord>();
        declRecords.add(new DaikonGrpcProgramPointRecord(fullMethodName, DaikonPptType.ENTER, request, null));
        declRecords.add(new DaikonGrpcProgramPointRecord(fullMethodName, DaikonPptType.EXIT, request, response));
        return declRecords;
    }
}

