/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.daikon.traces;

import cloud.filibuster.daikon.DaikonPpt;
import cloud.filibuster.daikon.DaikonPptType;
import cloud.filibuster.daikon.traces.DaikonGrpcDataTraceVariable;
import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.junit.server.core.transformers.JsonUtils;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class DaikonGrpcDataTraceRecord {
    public String nonceString;
    private final String ppt;
    private final List<DaikonGrpcDataTraceVariable> variables;

    public DaikonGrpcDataTraceRecord(String nonceString, String fullMethodName, DaikonPptType daikonPptType, GeneratedMessageV3 requestMessage, @Nullable GeneratedMessageV3 responseMessage) {
        this.ppt = DaikonPpt.generatePpt(fullMethodName, daikonPptType, requestMessage);
        this.nonceString = nonceString;
        try {
            Object value;
            String key;
            Iterator keys;
            JSONObject jsonObject;
            String serializedMessage;
            ArrayList<DaikonGrpcDataTraceVariable> variables = new ArrayList<DaikonGrpcDataTraceVariable>();
            if (daikonPptType.equals((Object)DaikonPptType.ENTER) || daikonPptType.equals((Object)DaikonPptType.EXIT)) {
                variables.add(new DaikonGrpcDataTraceVariable("this", null, requestMessage.hashCode()));
                serializedMessage = JsonFormat.printer().preservingProtoFieldNames().includingDefaultValueFields().print((MessageOrBuilder)requestMessage);
                jsonObject = new JSONObject(serializedMessage);
                jsonObject = JsonUtils.flatten(jsonObject);
                keys = jsonObject.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    value = jsonObject.get(key);
                    variables.add(new DaikonGrpcDataTraceVariable("this." + key, value.toString(), value.hashCode()));
                }
            }
            if (daikonPptType.equals((Object)DaikonPptType.EXIT)) {
                variables.add(new DaikonGrpcDataTraceVariable("return", null, responseMessage.hashCode()));
                serializedMessage = JsonFormat.printer().preservingProtoFieldNames().includingDefaultValueFields().print((MessageOrBuilder)responseMessage);
                jsonObject = new JSONObject(serializedMessage);
                jsonObject = JsonUtils.flatten(jsonObject);
                keys = jsonObject.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    value = jsonObject.get(key);
                    variables.add(new DaikonGrpcDataTraceVariable("return." + key, value.toString(), value.hashCode()));
                }
            }
            this.variables = variables;
        }
        catch (Throwable t) {
            throw new FilibusterRuntimeException(t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ppt + "\n");
        for (DaikonGrpcDataTraceVariable variable : this.variables) {
            builder.append(variable.getName() + "\n");
            if (variable.getValue() == null) {
                builder.append(variable.getHashCode() + "\n");
            } else {
                builder.append("\"" + variable.getValue() + "\"\n");
            }
            builder.append(variable.getModified() + "\n");
        }
        return builder.toString();
    }

    public static List<DaikonGrpcDataTraceRecord> onRequestAndResponse(String fullMethodName, GeneratedMessageV3 request, GeneratedMessageV3 response) {
        String nonceString = UUID.randomUUID().toString();
        ArrayList<DaikonGrpcDataTraceRecord> traceRecords = new ArrayList<DaikonGrpcDataTraceRecord>();
        traceRecords.add(new DaikonGrpcDataTraceRecord(nonceString, fullMethodName, DaikonPptType.ENTER, request, null));
        traceRecords.add(new DaikonGrpcDataTraceRecord(nonceString, fullMethodName, DaikonPptType.EXIT, request, response));
        return traceRecords;
    }
}

