/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.dei;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.dei.DistributedExecutionIndexKey;
import cloud.filibuster.exceptions.distributed_execution_index.DistributedExecutionIndexCloneException;
import cloud.filibuster.exceptions.distributed_execution_index.DistributedExecutionIndexSerializationException;
import cloud.filibuster.instrumentation.datatypes.Callsite;
import cloud.filibuster.instrumentation.datatypes.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class DistributedExecutionIndexBase
implements Cloneable {
    protected HashMap<DistributedExecutionIndexKey, Integer> counters = new HashMap();
    protected ArrayList<Map.Entry<DistributedExecutionIndexKey, Integer>> callstack = new ArrayList();

    public boolean equals(Object o) {
        if (!(o instanceof DistributedExecutionIndexBase)) {
            return false;
        }
        DistributedExecutionIndexBase dei = (DistributedExecutionIndexBase)o;
        return Objects.equals(this.counters, dei.counters) && Objects.equals(this.callstack, dei.callstack);
    }

    public int hashCode() {
        return Objects.hash(this.counters, this.callstack);
    }

    public void push(Callsite callsite) {
        DistributedExecutionIndex dei = (DistributedExecutionIndex)((Object)this);
        DistributedExecutionIndexKey key = dei.convertCallsiteToDistributedExecutionIndexKey(callsite);
        int currentValue = 0;
        if (this.counters.containsKey(key)) {
            currentValue = this.counters.get(key);
            this.counters.replace(key, currentValue + 1);
        } else {
            this.counters.put(key, currentValue + 1);
        }
        this.callstack.add(Pair.of(key, currentValue + 1));
    }

    public void pop() {
        int lastIndex = this.callstack.size() - 1;
        this.callstack.remove(lastIndex);
    }

    public DistributedExecutionIndex deserialize(String serialized) {
        if (serialized == null) {
            throw new DistributedExecutionIndexSerializationException("cannot deserialize an empty string.");
        }
        if (serialized.equals("")) {
            return (DistributedExecutionIndex)((Object)this);
        }
        String normalized = serialized.substring(1, serialized.length() - 1);
        String[] parts = normalized.split(",");
        String key = null;
        for (int counter = 0; counter < parts.length; ++counter) {
            if (parts[0].isEmpty()) continue;
            if (key == null) {
                if (counter == 0) {
                    key = parts[counter].substring(2);
                }
                if (counter > 0) {
                    key = parts[counter].substring(3);
                }
                key = key.substring(0, key.length() - 1);
                continue;
            }
            String value = parts[counter].substring(0, parts[counter].length() - 1);
            value = value.substring(1);
            this.callstack.add(Pair.of(DistributedExecutionIndexKey.deserialize(key), Integer.valueOf(value)));
            key = null;
        }
        return (DistributedExecutionIndex)((Object)this);
    }

    private String serialize() {
        ArrayList<String> entryList = new ArrayList<String>();
        for (Map.Entry<DistributedExecutionIndexKey, Integer> stringIntegerEntry : this.callstack) {
            ArrayList<String> innerOutput = new ArrayList<String>();
            innerOutput.add("[\"");
            innerOutput.add(stringIntegerEntry.getKey().serialize());
            innerOutput.add("\", ");
            innerOutput.add(String.valueOf(stringIntegerEntry.getValue()));
            innerOutput.add("]");
            String innerOutputString = String.join((CharSequence)"", innerOutput);
            entryList.add(innerOutputString);
        }
        return "[" + String.join((CharSequence)", ", entryList) + "]";
    }

    public Object clone() {
        DistributedExecutionIndexBase newDistributedExecutionIndex;
        try {
            newDistributedExecutionIndex = (DistributedExecutionIndexBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DistributedExecutionIndexCloneException("cloning not supported for distributed execution index subtype", e);
        }
        newDistributedExecutionIndex.counters = new HashMap();
        for (Map.Entry<DistributedExecutionIndexKey, Integer> entry : this.counters.entrySet()) {
            newDistributedExecutionIndex.counters.put(entry.getKey(), entry.getValue());
        }
        newDistributedExecutionIndex.callstack = new ArrayList();
        for (Map.Entry<DistributedExecutionIndexKey, Integer> entry : this.callstack) {
            newDistributedExecutionIndex.callstack.add(Pair.of(entry.getKey(), entry.getValue()));
        }
        return newDistributedExecutionIndex;
    }

    public String toString() {
        return this.serialize();
    }
}

