/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.dei.implementations;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.dei.DistributedExecutionIndexBase;
import cloud.filibuster.dei.DistributedExecutionIndexKey;
import cloud.filibuster.dei.DistributedExecutionIndexType;
import cloud.filibuster.instrumentation.datatypes.Callsite;
import cloud.filibuster.instrumentation.datatypes.CallsiteArguments;
import cloud.filibuster.instrumentation.helpers.Hashing;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DistributedExecutionIndexV1
extends DistributedExecutionIndexBase
implements DistributedExecutionIndex {
    public static final DistributedExecutionIndexType VERSION = DistributedExecutionIndexType.V1;

    @Override
    public int compareTo(@NotNull DistributedExecutionIndex o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public DistributedExecutionIndexKey convertCallsiteToDistributedExecutionIndexKey(Callsite callsite) {
        Key key = new Key.Builder().metadata(Components.generateRpcMetadataFromCallsite(callsite)).source(Components.generateRpcSourceFromCallsite(callsite)).destination(callsite.getClassOrModuleName()).signature(Components.generateRpcSignatureFromCallsite(callsite)).synchronous(Components.generateRpcSynchronousComponentFromCallsite(callsite)).asynchronous(Components.generateRpcAsynchronousComponentFromCallsite(callsite)).build();
        return key;
    }

    @Override
    public String projectionLastKeyWithOnlyMetadata() {
        Map.Entry lastCallstackEntry = (Map.Entry)this.callstack.get(this.callstack.size() - 1);
        DistributedExecutionIndexKey key = (DistributedExecutionIndexKey)lastCallstackEntry.getKey();
        return key.onlyMetadata().toString();
    }

    @Override
    public String projectionLastKeyWithOnlyMetadataAndSignature() {
        Map.Entry lastCallstackEntry = (Map.Entry)this.callstack.get(this.callstack.size() - 1);
        DistributedExecutionIndexKey key = (DistributedExecutionIndexKey)lastCallstackEntry.getKey();
        return key.onlyMetadataAndSignature().toString();
    }

    @Override
    public String projectionLastKeyWithOnlySignature() {
        Map.Entry lastCallstackEntry = (Map.Entry)this.callstack.get(this.callstack.size() - 1);
        DistributedExecutionIndexKey key = (DistributedExecutionIndexKey)lastCallstackEntry.getKey();
        return key.onlySignature().toString();
    }

    @Override
    public String projectionLastKeyWithOnlyDestination() {
        Map.Entry lastCallstackEntry = (Map.Entry)this.callstack.get(this.callstack.size() - 1);
        DistributedExecutionIndexKey key = (DistributedExecutionIndexKey)lastCallstackEntry.getKey();
        return key.onlyDestination().toString();
    }

    public static class Components {
        public static String generateRpcSourceFromCallsite(Callsite callsite) {
            String rpcSource = "";
            if (Properties.Source.getSourceInclude()) {
                rpcSource = callsite.getServiceName();
            }
            if (Properties.Source.getSourceDigest()) {
                return Hashing.createDigest(rpcSource);
            }
            return '[' + rpcSource + ']';
        }

        public static String generateRpcMetadataFromCallsite(Callsite callsite) {
            ArrayList<String> rpcMetadataElements = new ArrayList<String>();
            String rpcMetadata = "";
            if (Properties.TestScope.getTestScopeCounter()) {
                rpcMetadataElements.add("TestScope+" + callsite.getCurrentTestScope() + "+" + callsite.getCurrentTestScopeBlockType());
            }
            if (Properties.Metadata.getMetadataInclude()) {
                rpcMetadata = String.join((CharSequence)",", rpcMetadataElements);
            }
            if (Properties.Metadata.getMetadataDigest()) {
                return Hashing.createDigest(rpcMetadata);
            }
            return '[' + rpcMetadata + ']';
        }

        public static String generateRpcSignatureFromCallsite(Callsite callsite) {
            ArrayList<String> rpcSignatureElements = new ArrayList<String>();
            rpcSignatureElements.add(callsite.getClassOrModuleName());
            rpcSignatureElements.add(callsite.getMethodOrFunctionName());
            rpcSignatureElements.add(callsite.getParameterList());
            String rpcSignature = "";
            if (Properties.Signature.getSignatureInclude()) {
                rpcSignature = String.join((CharSequence)",", rpcSignatureElements);
            }
            if (Properties.Signature.getSignatureDigest()) {
                return Hashing.createDigest(rpcSignature);
            }
            return '[' + rpcSignature + ']';
        }

        public static String generateRpcSynchronousComponentFromCallsite(Callsite callsite) {
            ArrayList<String> rpcSynchronousElements = new ArrayList<String>();
            rpcSynchronousElements.add(callsite.getFileName());
            rpcSynchronousElements.add(callsite.getLineNumber());
            rpcSynchronousElements.add(callsite.getSerializedStackTrace());
            String rpcSynchronous = "";
            if (Properties.Synchronous.getSynchronousInclude()) {
                rpcSynchronous = String.join((CharSequence)",", rpcSynchronousElements);
            }
            if (Properties.Synchronous.getSynchronousDigest()) {
                return Hashing.createDigest(rpcSynchronous);
            }
            return '[' + rpcSynchronous + ']';
        }

        public static String generateRpcAsynchronousComponentFromCallsite(Callsite callsite) {
            ArrayList<String> rpcAsynchronousElements = new ArrayList<String>();
            CallsiteArguments callsiteArguments = callsite.getCallsiteArguments();
            rpcAsynchronousElements.add(callsiteArguments.getStringClass());
            rpcAsynchronousElements.add(callsiteArguments.getToStringResult());
            String rpcAsynchronous = "";
            if (Properties.Asynchronous.getAsynchronousInclude()) {
                rpcAsynchronous = String.join((CharSequence)",", rpcAsynchronousElements);
            }
            if (Properties.Asynchronous.getAsynchronousDigest()) {
                return Hashing.createDigest(rpcAsynchronous);
            }
            return '[' + rpcAsynchronous + ']';
        }
    }

    public static class Key
    implements DistributedExecutionIndexKey {
        private final String source;
        private final String destination;
        private final String signature;
        private final String synchronous;
        private final String asynchronous;
        private final String metadata;

        public Key(Builder builder) {
            this.source = builder.source;
            this.destination = builder.destination;
            this.signature = builder.signature;
            this.synchronous = builder.synchronous;
            this.asynchronous = builder.asynchronous;
            this.metadata = builder.metadata;
        }

        @Override
        public String toString() {
            return this.serialize();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return Objects.equals(this.metadata, k.metadata) && Objects.equals(this.source, k.source) && Objects.equals(this.signature, k.signature) && Objects.equals(this.synchronous, k.synchronous) && Objects.equals(this.asynchronous, k.asynchronous);
        }

        @Override
        public String onlyMetadata() {
            return this.metadata;
        }

        @Override
        public String onlyMetadataAndSignature() {
            return this.metadata + "-" + this.signature;
        }

        @Override
        public String onlySignature() {
            return this.signature;
        }

        @Override
        public String onlyDestination() {
            return this.destination;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{VERSION, this.metadata, this.source, this.signature, this.synchronous, this.asynchronous});
        }

        @Override
        public String serialize() {
            ArrayList<String> deiElements = new ArrayList<String>();
            deiElements.add(VERSION.name());
            deiElements.add(this.metadata);
            deiElements.add(this.source);
            deiElements.add(this.signature);
            deiElements.add(this.synchronous);
            deiElements.add(this.asynchronous);
            return String.join((CharSequence)"-", deiElements);
        }

        public static class Builder {
            private static final DistributedExecutionIndexType version = DistributedExecutionIndexType.V1;
            private String source;
            private String destination;
            private String signature;
            private String synchronous;
            private String asynchronous;
            private String metadata;

            @CanIgnoreReturnValue
            public Builder source(String source) {
                this.source = source;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder metadata(String metadata) {
                this.metadata = metadata;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder destination(String destination) {
                this.destination = destination;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder signature(String signature) {
                this.signature = signature;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder synchronous(String synchronous) {
                this.synchronous = synchronous;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder asynchronous(String asynchronous) {
                this.asynchronous = asynchronous;
                return this;
            }

            public Key build() {
                return new Key(this);
            }
        }
    }

    public static class Properties {

        public static class Asynchronous {
            private static final String ASYNCHRONOUS_INCLUDE = "filibuster.dei.v1.asynchronous.include";
            private static final String ASYNCHRONOUS_DIGEST = "filibuster.dei.v1.asynchronous.digest";

            public static void setAsynchronousInclude(boolean value) {
                System.setProperty(ASYNCHRONOUS_INCLUDE, String.valueOf(value));
            }

            public static boolean getAsynchronousInclude() {
                String propertyValue = System.getProperty(ASYNCHRONOUS_INCLUDE);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }

            public static void setAsynchronousDigest(boolean value) {
                System.setProperty(ASYNCHRONOUS_DIGEST, String.valueOf(value));
            }

            public static boolean getAsynchronousDigest() {
                String propertyValue = System.getProperty(ASYNCHRONOUS_DIGEST);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }
        }

        public static class Synchronous {
            private static final String SYNCHRONOUS_INCLUDE = "filibuster.dei.v1.synchronous.include";
            private static final String SYNCHRONOUS_DIGEST = "filibuster.dei.v1.synchronous.digest";

            public static void setSynchronousInclude(boolean value) {
                System.setProperty(SYNCHRONOUS_INCLUDE, String.valueOf(value));
            }

            public static boolean getSynchronousInclude() {
                String propertyValue = System.getProperty(SYNCHRONOUS_INCLUDE);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }

            public static void setSynchronousDigest(boolean value) {
                System.setProperty(SYNCHRONOUS_DIGEST, String.valueOf(value));
            }

            public static boolean getSynchronousDigest() {
                String propertyValue = System.getProperty(SYNCHRONOUS_DIGEST);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }
        }

        public static class Signature {
            private static final String SIGNATURE_INCLUDE = "filibuster.dei.v1.signature.include";
            private static final String SIGNATURE_DIGEST = "filibuster.dei.v1.signature.digest";

            public static void setSignatureInclude(boolean value) {
                System.setProperty(SIGNATURE_INCLUDE, String.valueOf(value));
            }

            public static boolean getSignatureInclude() {
                String propertyValue = System.getProperty(SIGNATURE_INCLUDE);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }

            public static void setSignatureDigest(boolean value) {
                System.setProperty(SIGNATURE_DIGEST, String.valueOf(value));
            }

            public static boolean getSignatureDigest() {
                String propertyValue = System.getProperty(SIGNATURE_DIGEST);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }
        }

        public static class Source {
            private static final String SOURCE_INCLUDE = "filibuster.dei.v1.source.include";
            private static final String SOURCE_DIGEST = "filibuster.dei.v1.source.digest";

            public static void setSourceInclude(boolean value) {
                System.setProperty(SOURCE_INCLUDE, String.valueOf(value));
            }

            public static boolean getSourceInclude() {
                String propertyValue = System.getProperty(SOURCE_INCLUDE);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }

            public static void setSourceDigest(boolean value) {
                System.setProperty(SOURCE_DIGEST, String.valueOf(value));
            }

            public static boolean getSourceDigest() {
                String propertyValue = System.getProperty(SOURCE_DIGEST);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }
        }

        public static class Metadata {
            private static final String METADATA_INCLUDE = "filibuster.dei.v1.metadata.include";
            private static final String METADATA_DIGEST = "filibuster.dei.v1.metadata.digest";

            public static void setMetadataInclude(boolean value) {
                System.setProperty(METADATA_INCLUDE, String.valueOf(value));
            }

            public static boolean getMetadataInclude() {
                String propertyValue = System.getProperty(METADATA_INCLUDE);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }

            public static void setMetadataDigest(boolean value) {
                System.setProperty(METADATA_DIGEST, String.valueOf(value));
            }

            public static boolean getMetadataDigest() {
                String propertyValue = System.getProperty(METADATA_DIGEST);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return true;
                }
                return Boolean.parseBoolean(propertyValue);
            }
        }

        public static class TestScope {
            public static final boolean TEST_SCOPE_COUNTER_DEFAULT = false;
            private static final String TEST_SCOPE_COUNTER = "filibuster.dei.v1.test_scope_counter";

            public static void setTestScopeCounter(boolean value) {
                System.setProperty(TEST_SCOPE_COUNTER, String.valueOf(value));
            }

            public static boolean getTestScopeCounter() {
                String propertyValue = System.getProperty(TEST_SCOPE_COUNTER);
                if (Objects.equals(propertyValue, "null") || propertyValue == null) {
                    return false;
                }
                return Boolean.valueOf(propertyValue);
            }
        }
    }
}

