/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.datatypes;

import cloud.filibuster.exceptions.filibuster.FilibusterCallsiteGenerationException;
import cloud.filibuster.exceptions.filibuster.FilibusterUnknownCallsiteException;
import cloud.filibuster.instrumentation.datatypes.CallsiteArguments;
import cloud.filibuster.instrumentation.datatypes.Pair;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.server.core.FilibusterCore;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Callsite {
    private static final Logger logger = Logger.getLogger(Callsite.class.getName());
    private static final ArrayList<String> standardImportedLibraries = new ArrayList();
    private static final ArrayList<String> importedLibrariesFromGradle = new ArrayList();
    private final String serviceName;
    private final String classOrModuleName;
    private final String methodOrFunctionName;
    private final CallsiteArguments callsiteArguments;
    private final String serializedStackTrace;
    private final String fileName;
    private final String lineNumber;
    private final ArrayList<Map.Entry<String, String>> filteredStackTrace = new ArrayList();

    public Callsite(String serviceName, String classOrModuleName, String methodOrFunctionName, CallsiteArguments callsiteArguments) {
        this.serviceName = serviceName;
        this.classOrModuleName = classOrModuleName;
        this.methodOrFunctionName = methodOrFunctionName;
        this.callsiteArguments = callsiteArguments;
        this.computeFilteredStackTrace();
        if (this.filteredStackTrace.size() == 0) {
            throw new FilibusterUnknownCallsiteException("Filibuster cannot determine the callsite of the remote request.");
        }
        ArrayList<String> arraySerializedArguments = new ArrayList<String>();
        for (Map.Entry<String, String> filteredStackTraceElement : this.filteredStackTrace) {
            arraySerializedArguments.add(filteredStackTraceElement.getValue());
        }
        this.serializedStackTrace = String.join((CharSequence)"", arraySerializedArguments);
        Map.Entry<String, String> lastStackTraceElement = this.filteredStackTrace.get(0);
        String lastStackTraceElementString = lastStackTraceElement.getValue();
        try {
            this.fileName = lastStackTraceElementString.substring(lastStackTraceElementString.indexOf(40) + 1, lastStackTraceElementString.indexOf(58));
        }
        catch (StringIndexOutOfBoundsException e) {
            for (Map.Entry<String, String> filteredStackTraceElement : this.filteredStackTrace) {
                logger.log(Level.WARNING, filteredStackTraceElement.getValue());
            }
            logger.log(Level.SEVERE, "lastStackTraceElementString: " + lastStackTraceElementString);
            throw e;
        }
        this.lineNumber = Property.getCallsiteLineNumberProperty() ? lastStackTraceElementString.substring(lastStackTraceElementString.indexOf(58) + 1, lastStackTraceElementString.indexOf(41)) : "0";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getParameterList() {
        return "[]";
    }

    public String getCurrentTestScope() {
        if (FilibusterCore.hasCurrentInstance()) {
            return String.valueOf(FilibusterCore.getCurrentInstance().getTestScopeCounter());
        }
        return "";
    }

    public String getCurrentTestScopeBlockType() {
        if (FilibusterCore.hasCurrentInstance()) {
            return String.valueOf((Object)FilibusterCore.getCurrentInstance().getLastTestScopeBlockType());
        }
        return "";
    }

    public String getClassOrModuleName() {
        return this.classOrModuleName;
    }

    public String getMethodOrFunctionName() {
        return this.methodOrFunctionName;
    }

    public CallsiteArguments getCallsiteArguments() {
        return this.callsiteArguments;
    }

    public String getSerializedStackTrace() {
        return this.serializedStackTrace;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    private void computeFilteredStackTrace() {
        StackTraceElement[] ste;
        for (StackTraceElement stackTraceElement : ste = Thread.currentThread().getStackTrace()) {
            boolean notProxy;
            int hashCode = stackTraceElement.hashCode();
            String stringStackTraceElement = stackTraceElement.toString();
            boolean foundInStandardImportedLibraries = false;
            for (String string : standardImportedLibraries) {
                if (!stringStackTraceElement.contains(string)) continue;
                foundInStandardImportedLibraries = true;
                break;
            }
            boolean foundInImportedLibrariesFromGradle = false;
            if (Property.getCallsiteRemoveImportsFromStackTraceProperty()) {
                for (String i2 : importedLibrariesFromGradle) {
                    if (!stringStackTraceElement.contains(i2)) continue;
                    foundInImportedLibrariesFromGradle = true;
                    break;
                }
            }
            boolean bl = !stringStackTraceElement.contains("cloud.filibuster") || stringStackTraceElement.contains("cloud.filibuster") && (stringStackTraceElement.contains("test") || stringStackTraceElement.contains("tutorial"));
            boolean bl2 = notProxy = !stringStackTraceElement.contains("$Proxy");
            if (foundInStandardImportedLibraries || foundInImportedLibrariesFromGradle || !bl || !notProxy) continue;
            this.filteredStackTrace.add(Pair.of(String.valueOf(hashCode), stringStackTraceElement));
        }
    }

    private static void generateImportedLibrariesListFromGradle() {
        ArrayList<String> regexps = new ArrayList<String>();
        regexps.add("\"(.*):.*:.*\"");
        regexps.add("'(.*):.*:.*'");
        ArrayList<String> files = new ArrayList<String>();
        files.add("build.gradle");
        files.add("build.gradle.kt");
        for (String file : files) {
            for (String regex : regexps) {
                Pattern pattern = Pattern.compile(regex, 8);
                try {
                    String line;
                    Path currentPath = Paths.get(System.getProperty("user.dir"), new String[0]);
                    Path filePath = Paths.get(currentPath.toString(), file);
                    if (!Files.exists(filePath, new LinkOption[0])) continue;
                    FileReader fileReader = new FileReader(filePath.toString());
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        Matcher matcher;
                        if (!line.contains("implementation") || line.contains("testImplementation") || !(matcher = pattern.matcher(line)).find() || importedLibrariesFromGradle.contains(matcher.group(1))) continue;
                        String whitelistedLibrary = Property.getCallsiteStackTraceWhitelistProperty();
                        if (whitelistedLibrary == null) {
                            importedLibrariesFromGradle.add(matcher.group(1));
                            continue;
                        }
                        if (matcher.group(1).contains(whitelistedLibrary)) continue;
                        importedLibrariesFromGradle.add(matcher.group(1));
                    }
                    bufferedReader.close();
                }
                catch (IOException e) {
                    throw new FilibusterCallsiteGenerationException(e);
                }
            }
        }
    }

    static {
        standardImportedLibraries.add("jdk.internal");
        standardImportedLibraries.add("java.base");
        standardImportedLibraries.add("org.junit");
        standardImportedLibraries.add("org.gradle");
        standardImportedLibraries.add("com.linecorp.armeria");
        standardImportedLibraries.add("com.sun");
        standardImportedLibraries.add("io.netty");
        standardImportedLibraries.add("io.grpc");
        Callsite.generateImportedLibrariesListFromGradle();
    }
}

