/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.datatypes;

import cloud.filibuster.instrumentation.libraries.armeria.http.FilibusterDecoratingHttpClient;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.util.EventLoopGroups;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FilibusterExecutor {
    private static final int MAX_FILIBUSTER_INSTRUMENTATION_THREADS = 200;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(200);
    private static final int MAX_SERVER_EVENT_LOOP_THREADS = 100;

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static EventLoopGroup getNewEventLoopGroup() {
        return EventLoopGroups.newEventLoopGroup((int)100);
    }

    public static EventLoopGroup getClientEventLoopGroup(int numThreads) {
        return EventLoopGroups.newEventLoopGroup((int)numThreads);
    }

    public static ClientFactory getNewClientFactory(int numThreads) {
        return ClientFactory.builder().maxNumEventLoopsPerEndpoint(Integer.MAX_VALUE).maxNumEventLoopsPerHttp1Endpoint(Integer.MAX_VALUE).workerGroup(FilibusterExecutor.getClientEventLoopGroup(numThreads), true).build();
    }

    public static WebClient getWebClient(String baseUri) {
        return WebClient.builder((String)baseUri).build();
    }

    public static WebClient getDecoratedWebClient(String baseUri, String serviceName) {
        return WebClient.builder((String)baseUri).decorator(delegate -> new FilibusterDecoratingHttpClient((HttpClient)delegate, serviceName)).build();
    }
}

