/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.datatypes;

import cloud.filibuster.exceptions.vector_clock.VectorClockCloneException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class VectorClock
implements Cloneable {
    private JSONObject obj = new JSONObject();

    public VectorClock clone() {
        VectorClock newVectorClock;
        try {
            newVectorClock = (VectorClock)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new VectorClockCloneException("cloning not supported for vector clock", e);
        }
        newVectorClock.obj = new JSONObject(this.obj.toString());
        return newVectorClock;
    }

    public int get(String key) {
        if (this.obj.has(key)) {
            return this.obj.getInt(key);
        }
        return 0;
    }

    public void incrementClock(String key) {
        int currentValue = 0;
        if (this.obj.has(key)) {
            currentValue = this.obj.getInt(key);
        }
        int newValue = currentValue + 1;
        this.obj.remove(key);
        this.obj.put(key, newValue);
    }

    public JSONObject toJsonObject() {
        return this.obj;
    }

    public String toString() {
        return this.obj.toString();
    }

    public void fromString(String jsonString) {
        this.obj = new JSONObject(jsonString);
    }

    public static VectorClock merge(VectorClock vc1, VectorClock vc2) {
        String key;
        VectorClock vc = new VectorClock();
        Iterator it = vc1.obj.keys();
        while (it.hasNext()) {
            key = (String)it.next();
            vc.obj.put(key, vc1.obj.getInt(key));
        }
        it = vc2.obj.keys();
        while (it.hasNext()) {
            key = (String)it.next();
            if (vc.obj.has(key)) {
                int currentValue = vc.obj.getInt(key);
                int newValue = Integer.max(currentValue, vc2.obj.getInt(key));
                vc.obj.put(key, newValue);
                continue;
            }
            vc.obj.put(key, vc2.obj.get(key));
        }
        return vc;
    }

    public static boolean descends(@Nullable VectorClock vc1, @Nullable VectorClock vc2) {
        boolean atLeastOneKeyGreater = false;
        if (vc1 == null) {
            return vc2 != null;
        }
        if (vc2 == null) {
            return false;
        }
        for (String key : vc1.obj.keySet()) {
            if (!vc2.obj.has(key)) {
                return false;
            }
            if (vc2.obj.getInt(key) < vc1.obj.getInt(key)) {
                return false;
            }
            if (vc2.obj.getInt(key) <= vc1.obj.getInt(key)) continue;
            atLeastOneKeyGreater = true;
        }
        if (atLeastOneKeyGreater) {
            return true;
        }
        return vc2.obj.length() > vc1.obj.length();
    }
}

