/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.helpers;

import cloud.filibuster.instrumentation.exceptions.CounterexampleFileDoesNotExistException;
import cloud.filibuster.instrumentation.exceptions.CounterexampleInvalidException;
import cloud.filibuster.instrumentation.exceptions.CounterexampleIsNullException;
import cloud.filibuster.instrumentation.exceptions.EnvironmentMissingCounterexampleException;
import cloud.filibuster.instrumentation.helpers.Property;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Counterexample {
    private Counterexample() {
    }

    public static boolean canLoadCounterexample() {
        String counterexampleFileName = Property.getInstrumentationCounterexampleFileProperty();
        if (counterexampleFileName != null && !counterexampleFileName.isEmpty()) {
            File f = new File(counterexampleFileName);
            return f.exists();
        }
        return false;
    }

    public static JSONObject loadCounterexampleAsJsonObjectFromEnvironment() {
        String counterexampleFileName = Property.getInstrumentationCounterexampleFileProperty();
        if (counterexampleFileName != null && !counterexampleFileName.isEmpty()) {
            return Counterexample.loadCounterexampleAsJsonObject(counterexampleFileName);
        }
        throw new EnvironmentMissingCounterexampleException();
    }

    public static JSONObject loadCounterexampleAsJsonObject(String counterexampleFileName) {
        if (counterexampleFileName != null && !counterexampleFileName.isEmpty()) {
            File f = new File(counterexampleFileName);
            if (f.exists()) {
                String rawCounterexample = Counterexample.readLineByLineJava8(counterexampleFileName);
                return new JSONObject(rawCounterexample);
            }
            throw new CounterexampleFileDoesNotExistException();
        }
        throw new CounterexampleIsNullException();
    }

    public static JSONObject loadTestExecutionFromCounterexample(JSONObject counterexample) {
        if (counterexample != null) {
            return new JSONObject(counterexample.getString("TestExecution"));
        }
        throw new CounterexampleInvalidException();
    }

    @Nullable
    public static JSONObject shouldFailRequestWith(String distributedExecutionIndex, JSONObject testExecution) {
        JSONArray failures = testExecution.getJSONArray("failures");
        for (int i = 0; i < failures.length(); ++i) {
            JSONObject failure = failures.getJSONObject(i);
            String failureDistributedExecutionIndex = failure.getString("execution_index");
            if (!distributedExecutionIndex.equals(failureDistributedExecutionIndex)) continue;
            return failure;
        }
        return null;
    }

    public static JSONObject shouldFailRequestWithOrDefault(String distributedExecutionIndex, JSONObject testExecution) {
        JSONObject failure = Counterexample.shouldFailRequestWith(distributedExecutionIndex, testExecution);
        if (failure == null) {
            JSONObject response = new JSONObject();
            response.put("execution_index", (Object)distributedExecutionIndex);
            return response;
        }
        return failure;
    }

    private static String readLineByLineJava8(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }
}

