/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.instrumentors;

import cloud.filibuster.RpcType;
import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.dei.DistributedExecutionIndexType;
import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.exceptions.filibuster.FilibusterServerBadResponseException;
import cloud.filibuster.instrumentation.datatypes.Callsite;
import cloud.filibuster.instrumentation.datatypes.CallsiteArguments;
import cloud.filibuster.instrumentation.datatypes.FilibusterExecutor;
import cloud.filibuster.instrumentation.datatypes.RequestId;
import cloud.filibuster.instrumentation.datatypes.VectorClock;
import cloud.filibuster.instrumentation.helpers.Counterexample;
import cloud.filibuster.instrumentation.helpers.Networking;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.helpers.Response;
import cloud.filibuster.instrumentation.instrumentors.FilibusterContextHelpers;
import cloud.filibuster.instrumentation.instrumentors.FilibusterLocks;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import cloud.filibuster.junit.server.core.FilibusterCore;
import cloud.filibuster.junit.server.core.serializers.GeneratedMessageV3Serializer;
import cloud.filibuster.junit.server.core.serializers.StatusSerializer;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import com.google.gson.Gson;
import com.google.protobuf.GeneratedMessageV3;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import io.grpc.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.json.JSONObject;

public final class FilibusterClientInstrumentor {
    private static final Logger logger = Logger.getLogger(FilibusterClientInstrumentor.class.getName());
    private static Map<String, Map<String, VectorClock>> vectorClocksByRequest = new HashMap<String, Map<String, VectorClock>>();
    private final String outgoingRequestId;
    private static Map<String, Map<String, DistributedExecutionIndex>> distributedExecutionIndexByRequest = new HashMap<String, Map<String, DistributedExecutionIndex>>();
    private final String filibusterHost = Networking.getFilibusterHost();
    private final int filibusterPort = Networking.getFilibusterPort();
    private final String serviceName;
    private final boolean shouldCommunicateWithServer;
    private Callsite callsite;
    private int generatedId;
    private VectorClock vectorClock;
    private DistributedExecutionIndex distributedExecutionIndex;
    @Nullable
    private VectorClock originVectorClock;
    @Nullable
    private JSONObject forcedException;
    @Nullable
    private JSONObject failureMetadata;
    @Nullable
    private JSONObject transformerFault;
    private String requestId;
    public static String overrideRequestId;
    private final ContextStorage contextStorage;
    private final String filibusterBaseUri = "http://" + this.getFilibusterHost() + ":" + this.getFilibusterPort() + "/";
    @Nullable
    private JSONObject counterexample;
    @Nullable
    private JSONObject counterexampleTestExecution;
    @Nullable
    private DistributedExecutionIndex preliminaryDistributedExecutionIndex;
    @Nullable
    RpcType rpcType;
    @Nullable
    GeneratedMessageV3 requestMessage;
    private static final String filibusterServiceName = "filibuster-instrumentation";

    public static Map<String, Map<String, VectorClock>> getVectorClocksByRequest() {
        return vectorClocksByRequest;
    }

    public static Map<String, Map<String, DistributedExecutionIndex>> getDistributedExecutionIndexByRequest() {
        return distributedExecutionIndexByRequest;
    }

    public static void setVectorClockForRequestId(String serviceName, String requestId, VectorClock vectorClock) {
        if (vectorClocksByRequest.containsKey(serviceName)) {
            Map<String, VectorClock> vectorClockMap = vectorClocksByRequest.get(serviceName);
            vectorClockMap.put(requestId, vectorClock);
        } else {
            HashMap<String, VectorClock> vectorClockMap = new HashMap<String, VectorClock>();
            vectorClockMap.put(requestId, vectorClock);
            vectorClocksByRequest.put(serviceName, vectorClockMap);
        }
    }

    public static boolean vectorClockForRequestIdExists(String serviceName, String requestId) {
        if (!vectorClocksByRequest.containsKey(serviceName)) {
            return false;
        }
        Map<String, VectorClock> vectorClockMap = vectorClocksByRequest.get(serviceName);
        return vectorClockMap.containsKey(requestId);
    }

    public static void clearVectorClockForRequestId(String serviceName) {
        vectorClocksByRequest.remove(serviceName);
    }

    public static void clearVectorClockForRequestId() {
        vectorClocksByRequest = new HashMap<String, Map<String, VectorClock>>();
    }

    public static void clearDistributedExecutionIndexForRequestId(String serviceName) {
        distributedExecutionIndexByRequest.remove(serviceName);
    }

    public static void clearDistributedExecutionIndexForRequestId() {
        distributedExecutionIndexByRequest = new HashMap<String, Map<String, DistributedExecutionIndex>>();
    }

    public static void setDistributedExecutionIndexForRequestId(String serviceName, String requestId, DistributedExecutionIndex distributedExecutionIndex) {
        if (distributedExecutionIndexByRequest.containsKey(serviceName)) {
            Map<String, DistributedExecutionIndex> distributedExecutionIndexMap = distributedExecutionIndexByRequest.get(serviceName);
            distributedExecutionIndexMap.put(requestId, distributedExecutionIndex);
        } else {
            HashMap<String, DistributedExecutionIndex> distributedExecutionIndexMap = new HashMap<String, DistributedExecutionIndex>();
            distributedExecutionIndexMap.put(requestId, distributedExecutionIndex);
            distributedExecutionIndexByRequest.put(serviceName, distributedExecutionIndexMap);
        }
    }

    public static VectorClock getVectorClockForServiceNameAndRequestId(String serviceName, String requestId, VectorClock defaultVectorClock) {
        Map vectorClocksByRequestId = vectorClocksByRequest.getOrDefault(serviceName, new HashMap());
        return vectorClocksByRequestId.getOrDefault(requestId, defaultVectorClock);
    }

    public static DistributedExecutionIndex getDistributedExecutionIndexForServiceNameAndRequestId(String serviceName, String requestId, DistributedExecutionIndex defaultExecutionIndex) {
        Map distributedExecutionIndexByRequestId = distributedExecutionIndexByRequest.getOrDefault(serviceName, new HashMap());
        return distributedExecutionIndexByRequestId.getOrDefault(requestId, defaultExecutionIndex);
    }

    public FilibusterClientInstrumentor(String serviceName, boolean shouldCommunicateWithServer, ContextStorage contextStorage, Callsite callsite) {
        this.serviceName = serviceName;
        this.callsite = callsite;
        this.shouldCommunicateWithServer = shouldCommunicateWithServer;
        this.contextStorage = contextStorage;
        this.requestId = contextStorage.getRequestId();
        this.outgoingRequestId = RequestId.generateNewRequestId().toString();
        this.originVectorClock = contextStorage.getOriginVectorClock();
        this.distributedExecutionIndex = DistributedExecutionIndexType.getImplType().createImpl();
        this.generatedId = -1;
        if (Counterexample.canLoadCounterexample()) {
            this.counterexample = Counterexample.loadCounterexampleAsJsonObjectFromEnvironment();
            this.counterexampleTestExecution = Counterexample.loadTestExecutionFromCounterexample(this.counterexample);
        }
    }

    private boolean counterexampleNotProvided() {
        return this.counterexample == null;
    }

    public void setPreliminaryDistributedExecutionIndex(DistributedExecutionIndex preliminaryDistributedExecutionIndex) {
        this.preliminaryDistributedExecutionIndex = preliminaryDistributedExecutionIndex;
    }

    public DistributedExecutionIndex getPreliminaryDistributedExecutionIndex() {
        return this.preliminaryDistributedExecutionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCallsite(Callsite callsite) {
        this.callsite = callsite;
        Object object = FilibusterLocks.distributedExecutionIndexLock;
        synchronized (object) {
            DistributedExecutionIndex incrementedDistributedExecutionIndex = FilibusterClientInstrumentor.getDistributedExecutionIndexForServiceNameAndRequestId(this.serviceName, this.getRequestId(), DistributedExecutionIndexType.getImplType().createImpl());
            incrementedDistributedExecutionIndex.push(callsite);
            this.distributedExecutionIndex = (DistributedExecutionIndex)incrementedDistributedExecutionIndex.clone();
            incrementedDistributedExecutionIndex.pop();
            FilibusterClientInstrumentor.setDistributedExecutionIndexForRequestId(this.serviceName, this.getRequestId(), incrementedDistributedExecutionIndex);
        }
    }

    public void setRpcType(@Nullable RpcType rpcType) {
        this.rpcType = rpcType;
    }

    public Callsite getCallsite() {
        return this.callsite;
    }

    public String getFilibusterHost() {
        return this.filibusterHost;
    }

    public int getFilibusterPort() {
        return this.filibusterPort;
    }

    public String getRequestId() {
        if (Property.getClientInstrumentorUseOverrideRequestIdProperty()) {
            return overrideRequestId;
        }
        return this.requestId;
    }

    public String getOutgoingRequestId() {
        return this.outgoingRequestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public VectorClock getVectorClock() {
        return this.vectorClock;
    }

    public DistributedExecutionIndex getDistributedExecutionIndex() {
        return this.distributedExecutionIndex;
    }

    public VectorClock getOriginVectorClock() {
        return this.originVectorClock;
    }

    public int getGeneratedId() {
        return this.generatedId;
    }

    public JSONObject getForcedException() {
        return this.forcedException;
    }

    public JSONObject getFailureMetadata() {
        return this.failureMetadata;
    }

    public JSONObject getTransformerFault() {
        return this.transformerFault;
    }

    public boolean shouldAbort() {
        if (this.forcedException != null && this.forcedException.has("metadata")) {
            JSONObject forcedExceptionMetadata = this.forcedException.getJSONObject("metadata");
            if (forcedExceptionMetadata.has("abort") && !forcedExceptionMetadata.getBoolean("abort")) {
                return false;
            }
            if (forcedExceptionMetadata.has("defer") && forcedExceptionMetadata.getBoolean("defer")) {
                return false;
            }
        }
        if (this.failureMetadata != null) {
            return !this.failureMetadata.has("abort") || this.failureMetadata.getBoolean("abort");
        }
        return true;
    }

    public boolean shouldResetClocks() {
        logger.log(Level.INFO, "shouldResetClocks: about to make call.");
        if (this.shouldCommunicateWithServer && this.counterexampleNotProvided()) {
            if (Property.getServerBackendCanInvokeDirectlyProperty()) {
                if (FilibusterCore.hasCurrentInstance()) {
                    return FilibusterCore.getCurrentInstance().isNewTestExecution(this.serviceName);
                }
                throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
            }
            CompletableFuture<Boolean> shouldResetClocks = CompletableFuture.supplyAsync(() -> {
                try {
                    WebClient webClient = FilibusterExecutor.getDecoratedWebClient(this.filibusterBaseUri, filibusterServiceName);
                    RequestHeaders postJson = RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)("/filibuster/new-test-execution/" + this.serviceName), (CharSequence)HttpHeaderNames.ACCEPT, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
                    AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(postJson).aggregate().join();
                    ResponseHeaders headers = response.headers();
                    String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                    if (statusCode == null) {
                        FilibusterServerBadResponseException.logAndThrow("shouldResetClocks, statusCode: null");
                    }
                    if (!Objects.equals(statusCode, "200")) {
                        FilibusterServerBadResponseException.logAndThrow("shouldResetClocks, statusCode: " + statusCode);
                    }
                    JSONObject jsonObject = Response.aggregatedHttpResponseToJsonObject(response);
                    return jsonObject.getBoolean("new-test-execution");
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "cannot connect to the Filibuster server: " + e);
                    return false;
                }
            }, FilibusterExecutor.getExecutorService());
            try {
                logger.log(Level.INFO, "shouldResetClocks: finished.");
                return shouldResetClocks.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.SEVERE, "cannot get information from Filibuster server: " + e);
                return false;
            }
        }
        return false;
    }

    public void prepareForInvocation(GeneratedMessageV3 message) {
        this.requestMessage = message;
        this.prepareForInvocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForInvocation() {
        logger.log(Level.INFO, "requestId: " + this.getRequestId());
        if (this.shouldResetClocks()) {
            FilibusterClientInstrumentor.clearVectorClockForRequestId(this.serviceName);
            FilibusterClientInstrumentor.clearDistributedExecutionIndexForRequestId(this.serviceName);
        }
        if (!FilibusterClientInstrumentor.vectorClockForRequestIdExists(this.serviceName, this.getRequestId())) {
            FilibusterClientInstrumentor.setVectorClockForRequestId(this.serviceName, this.getRequestId(), new VectorClock());
        }
        FilibusterContextHelpers.populateExecutionMapsFromContextStorage(this.serviceName, this.contextStorage, this.getRequestId());
        logger.log(Level.INFO, "NEW requestId: " + this.getRequestId());
        Object object = FilibusterLocks.vectorClockLock;
        synchronized (object) {
            VectorClock incrementedVectorClock = FilibusterClientInstrumentor.getVectorClockForServiceNameAndRequestId(this.serviceName, this.getRequestId(), new VectorClock());
            incrementedVectorClock.incrementClock(this.serviceName);
            FilibusterClientInstrumentor.setVectorClockForRequestId(this.serviceName, this.getRequestId(), incrementedVectorClock);
            this.vectorClock = incrementedVectorClock.clone();
        }
        object = FilibusterLocks.distributedExecutionIndexLock;
        synchronized (object) {
            DistributedExecutionIndex incrementedDistributedExecutionIndex = FilibusterClientInstrumentor.getDistributedExecutionIndexForServiceNameAndRequestId(this.serviceName, this.getRequestId(), DistributedExecutionIndexType.getImplType().createImpl());
            incrementedDistributedExecutionIndex.push(this.callsite);
            this.distributedExecutionIndex = (DistributedExecutionIndex)incrementedDistributedExecutionIndex.clone();
            incrementedDistributedExecutionIndex.pop();
            FilibusterClientInstrumentor.setDistributedExecutionIndexForRequestId(this.serviceName, this.getRequestId(), incrementedDistributedExecutionIndex);
        }
        if (this.originVectorClock == null) {
            this.originVectorClock = new VectorClock();
        }
        logger.log(Level.INFO, "originVectorClock: " + this.originVectorClock);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeInvocation() {
        JSONObject jsonObject;
        logger.log(Level.INFO, "beforeInvocation: about to make call.");
        JSONObject invocationMetadata = new JSONObject();
        if (this.rpcType != null) {
            invocationMetadata.put("rpc_type", (Object)this.rpcType.toString());
        } else {
            invocationMetadata.put("rpc_type", (Object)"");
        }
        JSONObject invocationPayload = new JSONObject();
        invocationPayload.put("instrumentation_type", (Object)"invocation");
        invocationPayload.put("source_service_name", (Object)this.serviceName);
        invocationPayload.put("module", (Object)this.callsite.getClassOrModuleName());
        invocationPayload.put("method", (Object)this.callsite.getMethodOrFunctionName());
        CallsiteArguments callsiteArguments = this.callsite.getCallsiteArguments();
        JSONObject invocationArguments = callsiteArguments.toJsonObject();
        invocationPayload.put("args", (Object)invocationArguments);
        if (Property.getTestV2Arguments() && this.requestMessage != null) {
            JSONObject serializedRequestArgumentsV2 = GeneratedMessageV3Serializer.toJsonObject(this.requestMessage);
            invocationPayload.put("args_v2", (Object)serializedRequestArgumentsV2);
        }
        invocationPayload.put("kwargs", (Object)new JSONObject());
        invocationPayload.put("callsite_file", (Object)this.callsite.getFileName());
        invocationPayload.put("callsite_line", (Object)this.callsite.getLineNumber());
        invocationPayload.put("full_traceback", (Object)this.callsite.getSerializedStackTrace());
        invocationPayload.put("metadata", (Object)invocationMetadata);
        invocationPayload.put("vclock", (Object)this.vectorClock.toJsonObject());
        invocationPayload.put("origin_vclock", (Object)this.originVectorClock.toJsonObject());
        invocationPayload.put("execution_index", (Object)this.distributedExecutionIndex.toString());
        if (this.preliminaryDistributedExecutionIndex != null) {
            invocationPayload.put("preliminary_execution_index", (Object)this.preliminaryDistributedExecutionIndex.toString());
        }
        if (!this.counterexampleNotProvided()) {
            logger.log(Level.INFO, "Not contacting server; replaying from counterexample file.");
            jsonObject = Counterexample.shouldFailRequestWithOrDefault(this.distributedExecutionIndex.toString(), this.counterexampleTestExecution);
            if (jsonObject.has("forced_exception")) {
                this.forcedException = jsonObject.getJSONObject("forced_exception");
            }
            if (jsonObject.has("failure_metadata")) {
                this.failureMetadata = jsonObject.getJSONObject("failure_metadata");
            }
            if (jsonObject.has("transformer_fault")) {
                this.transformerFault = jsonObject.getJSONObject("transformer_fault");
            }
        } else if (this.shouldCommunicateWithServer && this.counterexampleNotProvided()) {
            if (Property.getServerBackendCanInvokeDirectlyProperty()) {
                if (!FilibusterCore.hasCurrentInstance()) throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
                jsonObject = FilibusterCore.getCurrentInstance().beginInvocation(invocationPayload);
                this.generatedId = jsonObject.getInt("generated_id");
                if (jsonObject.has("forced_exception")) {
                    this.forcedException = jsonObject.getJSONObject("forced_exception");
                }
                if (jsonObject.has("failure_metadata")) {
                    this.failureMetadata = jsonObject.getJSONObject("failure_metadata");
                }
                if (jsonObject.has("transformer_fault")) {
                    this.transformerFault = jsonObject.getJSONObject("transformer_fault");
                }
            } else {
                CompletableFuture<Void> createFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        WebClient webClient = FilibusterExecutor.getDecoratedWebClient(this.filibusterBaseUri, filibusterServiceName);
                        RequestHeaders postJson = RequestHeaders.of((HttpMethod)HttpMethod.PUT, (String)"/filibuster/create", (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true");
                        AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(postJson, invocationPayload.toString()).aggregate().join();
                        ResponseHeaders headers = response.headers();
                        String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                        if (statusCode == null) {
                            FilibusterServerBadResponseException.logAndThrow("beforeInvocation, statusCode: null");
                        }
                        if (!Objects.equals(statusCode, "200")) {
                            FilibusterServerBadResponseException.logAndThrow("beforeInvocation, statusCode: " + statusCode);
                        }
                        JSONObject jsonObject = Response.aggregatedHttpResponseToJsonObject(response);
                        this.generatedId = jsonObject.getInt("generated_id");
                        if (jsonObject.has("forced_exception")) {
                            this.forcedException = jsonObject.getJSONObject("forced_exception");
                        }
                        if (jsonObject.has("failure_metadata")) {
                            this.failureMetadata = jsonObject.getJSONObject("failure_metadata");
                        }
                        if (jsonObject.has("transformer_fault")) {
                            this.transformerFault = jsonObject.getJSONObject("transformer_fault");
                        }
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, "cannot connect to the Filibuster server: " + e);
                    }
                    return null;
                }, FilibusterExecutor.getExecutorService());
                try {
                    createFuture.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, "cannot get information from Filibuster server: " + e);
                }
            }
        }
        logger.log(Level.INFO, "beforeInvocation: finished.");
    }

    public void afterInvocationWithException(Throwable throwable) {
        HashMap<String, String> additionalMetadata = new HashMap<String, String>();
        this.afterInvocationWithException(throwable, additionalMetadata);
    }

    public void afterInvocationWithException(Throwable throwable, Map<String, String> additionalMetadata) {
        String exceptionName = throwable.getClass().getName();
        String exceptionCause = throwable.getCause() != null ? throwable.getCause().getClass().getName() : null;
        this.afterInvocationWithException(exceptionName, exceptionCause, additionalMetadata);
    }

    public void afterInvocationWithException(String exceptionName, String exceptionCause, Map<String, String> additionalMetadata) {
        this.afterInvocationWithException(exceptionName, exceptionCause, additionalMetadata, null);
    }

    public void afterInvocationWithException(String exceptionName, String exceptionCause, Map<String, String> additionalMetadata, @Nullable Object exceptionDetails) {
        if (this.generatedId > -1 && this.shouldCommunicateWithServer && this.counterexampleNotProvided()) {
            JSONObject metadata = new JSONObject();
            if (this.getForcedException() != null) {
                JSONObject forcedExceptionMetadata = this.getForcedException().getJSONObject("metadata");
                if (forcedExceptionMetadata.has("sleep")) {
                    metadata.put("sleep", forcedExceptionMetadata.get("sleep"));
                }
                if (forcedExceptionMetadata.has("abort")) {
                    metadata.put("abort", forcedExceptionMetadata.get("abort"));
                }
            }
            metadata.put("cause", (Object)exceptionCause);
            for (Map.Entry entry : additionalMetadata.entrySet()) {
                metadata.put((String)entry.getKey(), entry.getValue());
            }
            JSONObject exception = new JSONObject();
            exception.put("name", (Object)exceptionName);
            exception.put("metadata", (Object)metadata);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("instrumentation_type", (Object)"invocation_complete");
            jSONObject.put("generated_id", this.generatedId);
            jSONObject.put("execution_index", (Object)this.distributedExecutionIndex.toString());
            jSONObject.put("vclock", (Object)this.vectorClock.toJsonObject());
            jSONObject.put("exception", (Object)exception);
            if (Property.getTestV2Exception() && exceptionDetails != null && exceptionDetails instanceof Status) {
                Status responseStatus = (Status)exceptionDetails;
                JSONObject serializedExceptionV2 = StatusSerializer.toJsonObject(responseStatus);
                jSONObject.put("exception_v2", (Object)serializedExceptionV2);
            }
            jSONObject.put("module", (Object)this.callsite.getClassOrModuleName());
            jSONObject.put("method", (Object)this.callsite.getMethodOrFunctionName());
            if (this.preliminaryDistributedExecutionIndex != null) {
                jSONObject.put("preliminary_execution_index", (Object)this.preliminaryDistributedExecutionIndex.toString());
            }
            this.recordInvocationComplete(jSONObject, false);
        }
    }

    public void afterInvocationWithTransformerFault(String value, String type, Accumulator<?, ?> accumulator) {
        if (this.generatedId > -1 && this.shouldCommunicateWithServer && this.counterexampleNotProvided()) {
            JSONObject transformerFault = new JSONObject();
            transformerFault.put("value", (Object)value);
            transformerFault.put("accumulator", (Object)new Gson().toJson(accumulator));
            transformerFault.put("type", (Object)type);
            JSONObject invocationCompletePayload = new JSONObject();
            invocationCompletePayload.put("instrumentation_type", (Object)"invocation_complete");
            invocationCompletePayload.put("generated_id", this.generatedId);
            invocationCompletePayload.put("execution_index", (Object)this.distributedExecutionIndex.toString());
            invocationCompletePayload.put("vclock", (Object)this.vectorClock.toJsonObject());
            invocationCompletePayload.put("transformer_fault", (Object)transformerFault);
            invocationCompletePayload.put("module", (Object)this.callsite.getClassOrModuleName());
            invocationCompletePayload.put("method", (Object)this.callsite.getMethodOrFunctionName());
            if (this.preliminaryDistributedExecutionIndex != null) {
                invocationCompletePayload.put("preliminary_execution_index", (Object)this.preliminaryDistributedExecutionIndex.toString());
            }
            this.recordInvocationComplete(invocationCompletePayload, false);
        }
    }

    public void afterInvocationComplete(String className, Map<String, String> returnValueProperties) {
        this.afterInvocationComplete(className, returnValueProperties, false, null);
    }

    public void afterInvocationComplete(String className, Map<String, String> returnValueProperties, boolean isUpdate, @Nullable Object returnValue) {
        this.afterInvocationComplete(className, returnValueProperties, isUpdate, returnValue, null);
    }

    public void afterInvocationComplete(String className, Map<String, String> returnValueProperties, boolean isUpdate, @Nullable Object returnValue, @Nullable GeneratedMessageV3 responseMessage) {
        logger.log(Level.INFO, "generatedId: " + this.generatedId);
        logger.log(Level.INFO, "shouldCommunicateWithServer: " + this.shouldCommunicateWithServer);
        if (this.generatedId > -1 && this.shouldCommunicateWithServer && this.counterexampleNotProvided()) {
            JSONObject returnValueJsonObject = new JSONObject();
            returnValueJsonObject.put("__class__", (Object)className);
            if (returnValue != null && returnValue != JSONObject.NULL && returnValue != "") {
                try {
                    returnValueJsonObject.put("value", (Object)new Gson().toJson(returnValue));
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, "Could not serialise return value to JSON: " + e);
                }
            } else {
                returnValueJsonObject.put("value", returnValue);
            }
            for (Map.Entry<String, String> entry : returnValueProperties.entrySet()) {
                returnValueJsonObject.put(entry.getKey(), entry.getValue() == null ? JSONObject.NULL : entry.getValue());
            }
            JSONObject invocationCompletePayload = new JSONObject();
            invocationCompletePayload.put("instrumentation_type", (Object)"invocation_complete");
            invocationCompletePayload.put("generated_id", this.getGeneratedId());
            invocationCompletePayload.put("execution_index", (Object)this.distributedExecutionIndex.toString());
            invocationCompletePayload.put("vclock", (Object)this.getVectorClock().toJsonObject());
            invocationCompletePayload.put("return_value", (Object)returnValueJsonObject);
            if (Property.getTestV2ReturnValue() && responseMessage != null) {
                JSONObject serializedResponseArgumentsV2 = GeneratedMessageV3Serializer.toJsonObject(responseMessage);
                invocationCompletePayload.put("return_value_v2", (Object)serializedResponseArgumentsV2);
            }
            invocationCompletePayload.put("module", (Object)this.callsite.getClassOrModuleName());
            invocationCompletePayload.put("method", (Object)this.callsite.getMethodOrFunctionName());
            if (this.preliminaryDistributedExecutionIndex != null) {
                invocationCompletePayload.put("preliminary_execution_index", (Object)this.preliminaryDistributedExecutionIndex.toString());
            }
            this.recordInvocationComplete(invocationCompletePayload, isUpdate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recordInvocationComplete(JSONObject invocationCompletePayload, boolean isUpdate) {
        logger.log(Level.INFO, "invocationCompletePayload: about to make call.");
        logger.log(Level.INFO, "invocationCompletePayload: " + invocationCompletePayload);
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) throw new FilibusterRuntimeException("No current filibuster core instance, this could indicate a problem.");
            FilibusterCore.getCurrentInstance().endInvocation(invocationCompletePayload, isUpdate);
            return;
        }
        if (isUpdate) return;
        CompletableFuture<Void> updateFuture = CompletableFuture.supplyAsync(() -> {
            WebClient webClient = FilibusterExecutor.getDecoratedWebClient(this.filibusterBaseUri, filibusterServiceName);
            RequestHeaders postJson = RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)"/filibuster/update", (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true", (CharSequence)"X-Filibuster-Is-Update", (String)String.valueOf(isUpdate));
            webClient.execute(postJson, invocationCompletePayload.toString()).aggregate().join();
            return null;
        }, FilibusterExecutor.getExecutorService());
        try {
            updateFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "cannot get information from Filibuster server: " + e);
        }
        logger.log(Level.INFO, "invocationCompletePayload: finished.");
    }
}

