/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.instrumentors;

import cloud.filibuster.dei.DistributedExecutionIndex;
import cloud.filibuster.dei.DistributedExecutionIndexType;
import cloud.filibuster.instrumentation.datatypes.VectorClock;
import cloud.filibuster.instrumentation.instrumentors.FilibusterClientInstrumentor;
import cloud.filibuster.instrumentation.instrumentors.FilibusterLocks;
import cloud.filibuster.instrumentation.storage.ContextStorage;

public class FilibusterContextHelpers {
    private FilibusterContextHelpers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateExecutionMapsFromContextStorage(String serviceName, ContextStorage contextStorage, String requestId) {
        VectorClock vectorClock = contextStorage.getVectorClock();
        String distributedExecutionIndexStr = contextStorage.getDistributedExecutionIndex();
        Object object = FilibusterLocks.distributedExecutionIndexLock;
        synchronized (object) {
            DistributedExecutionIndex distributedExecutionIndexFromContext = FilibusterClientInstrumentor.getDistributedExecutionIndexForServiceNameAndRequestId(serviceName, requestId, null);
            if (distributedExecutionIndexFromContext == null) {
                if (distributedExecutionIndexStr == null) {
                    FilibusterClientInstrumentor.setDistributedExecutionIndexForRequestId(serviceName, requestId, DistributedExecutionIndexType.getImplType().createImpl());
                } else {
                    DistributedExecutionIndex incomingDistributedExecutionIndex = DistributedExecutionIndexType.getImplType().createImpl().deserialize(contextStorage.getDistributedExecutionIndex());
                    FilibusterClientInstrumentor.setDistributedExecutionIndexForRequestId(serviceName, requestId, incomingDistributedExecutionIndex);
                }
            }
        }
        object = FilibusterLocks.vectorClockLock;
        synchronized (object) {
            if (vectorClock != null) {
                VectorClock mergedVectorClock = new VectorClock();
                mergedVectorClock = VectorClock.merge(contextStorage.getVectorClock(), FilibusterClientInstrumentor.getVectorClockForServiceNameAndRequestId(serviceName, requestId, new VectorClock()));
                FilibusterClientInstrumentor.setVectorClockForRequestId(serviceName, requestId, mergedVectorClock);
            } else {
                FilibusterClientInstrumentor.setVectorClockForRequestId(serviceName, requestId, new VectorClock());
            }
        }
    }
}

