/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.instrumentors;

import cloud.filibuster.exceptions.filibuster.FilibusterServerBadResponseException;
import cloud.filibuster.instrumentation.datatypes.FilibusterExecutor;
import cloud.filibuster.instrumentation.datatypes.VectorClock;
import cloud.filibuster.instrumentation.helpers.Counterexample;
import cloud.filibuster.instrumentation.helpers.Networking;
import cloud.filibuster.instrumentation.helpers.Response;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.json.JSONObject;

public final class FilibusterServerInstrumentor {
    private static final Logger logger = Logger.getLogger(FilibusterServerInstrumentor.class.getName());
    private final String serviceName;
    private final String generatedId;
    private String distributedExecutionIndex;
    private final boolean shouldCommunicateWithServer;
    private final ContextStorage contextStorage;
    @Nullable
    private JSONObject counterexample;
    @Nullable
    private JSONObject counterexampleTestExecution;

    public FilibusterServerInstrumentor(String serviceName, boolean shouldCommunicateWithServer, String requestId, String generatedId, @Nullable String vclockStr, @Nullable String originVclockStr, String distributedExecutionIndex, ContextStorage contextStorage) {
        VectorClock originVectorClock;
        VectorClock vectorClock;
        this.serviceName = serviceName;
        this.shouldCommunicateWithServer = shouldCommunicateWithServer;
        this.generatedId = generatedId;
        this.contextStorage = contextStorage;
        if (vclockStr != null) {
            vectorClock = new VectorClock();
            vectorClock.fromString(vclockStr);
        } else {
            vectorClock = new VectorClock();
        }
        if (originVclockStr != null) {
            originVectorClock = new VectorClock();
            originVectorClock.fromString(originVclockStr);
        } else {
            originVectorClock = new VectorClock();
        }
        this.distributedExecutionIndex = distributedExecutionIndex;
        logger.log(Level.INFO, "requestId: " + requestId);
        logger.log(Level.INFO, "generatedId: " + generatedId);
        logger.log(Level.INFO, "vclockStr: " + vclockStr);
        logger.log(Level.INFO, "originVclockStr: " + originVclockStr);
        logger.log(Level.INFO, "executionIndex: " + distributedExecutionIndex);
        contextStorage.setRequestId(requestId);
        contextStorage.setVectorClock(vectorClock);
        contextStorage.setOriginVectorClock(originVectorClock);
        contextStorage.setDistributedExecutionIndex(distributedExecutionIndex);
        if (Counterexample.canLoadCounterexample()) {
            this.counterexample = Counterexample.loadCounterexampleAsJsonObjectFromEnvironment();
            this.counterexampleTestExecution = Counterexample.loadTestExecutionFromCounterexample(this.counterexample);
        }
    }

    private boolean counterexampleNotProvided() {
        return this.counterexample == null;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getDistributedExecutionIndex() {
        return this.distributedExecutionIndex;
    }

    public void beforeInvocation() {
        logger.log(Level.INFO, "beforeInvocation [server]: about to make call.");
        if (this.getDistributedExecutionIndex() != null) {
            JSONObject payload = new JSONObject();
            payload.put("instrumentation_type", (Object)"request_received");
            payload.put("generated_id", (Object)this.getGeneratedId());
            payload.put("target_service_name", (Object)this.serviceName);
            payload.put("execution_index", (Object)this.getDistributedExecutionIndex());
            logger.log(Level.INFO, "payload: " + payload);
            if (this.shouldCommunicateWithServer && this.counterexampleNotProvided()) {
                CompletableFuture<String> updateFuture = CompletableFuture.supplyAsync(() -> {
                    JSONObject jsonObject;
                    String uri = "http://" + Networking.getFilibusterHost() + ":" + Networking.getFilibusterPort() + "/";
                    logger.log(Level.INFO, "making call to filibuster server, update with body: " + payload);
                    logger.log(Level.INFO, "URI: " + uri);
                    WebClient webClient = FilibusterExecutor.getWebClient("http://" + Networking.getFilibusterHost() + ":" + Networking.getFilibusterPort() + "/");
                    RequestHeaders postJson = RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)"/filibuster/update", (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/json", (CharSequence)"X-Filibuster-Instrumentation", (String)"true", (CharSequence)"X-Filibuster-Is-Update", (String)String.valueOf(false));
                    AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(postJson, payload.toString()).aggregate().join();
                    ResponseHeaders headers = response.headers();
                    String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
                    if (statusCode == null) {
                        FilibusterServerBadResponseException.logAndThrow("beforeInvocation, statusCode: null");
                    }
                    if (!Objects.equals(statusCode, "200")) {
                        FilibusterServerBadResponseException.logAndThrow("beforeInvocation, statusCode: " + statusCode);
                    }
                    if ((jsonObject = Response.aggregatedHttpResponseToJsonObject(response)).has("execution_index")) {
                        this.distributedExecutionIndex = jsonObject.getString("execution_index");
                        return this.distributedExecutionIndex;
                    }
                    return null;
                }, FilibusterExecutor.getExecutorService());
                try {
                    String newDistributedExecutionIndex = updateFuture.get();
                    if (newDistributedExecutionIndex != null) {
                        logger.log(Level.INFO, "rewriting EI from: " + this.contextStorage.getDistributedExecutionIndex() + " to " + this.distributedExecutionIndex);
                        this.contextStorage.setDistributedExecutionIndex(this.distributedExecutionIndex);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, "cannot get information from Filibuster server: " + e);
                }
                logger.log(Level.INFO, "beforeInvocation [server]: finished.");
                logger.log(Level.INFO, "call complete.");
            } else {
                logger.log(Level.INFO, "skipping!");
            }
        }
    }
}

