/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.instrumentors;

import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionException;
import cloud.filibuster.instrumentation.instrumentors.FilibusterClientInstrumentor;
import io.grpc.Status;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class FilibusterShared {
    public static String getForcedExceptionValue(JSONObject forcedException, String keyName, @Nullable String defaultValue) {
        Objects.requireNonNull(forcedException);
        if (forcedException.has(keyName)) {
            return forcedException.getString(keyName);
        }
        return defaultValue;
    }

    public static String getForcedExceptionMetadataValue(JSONObject forcedException, String keyName, @Nullable String defaultValue) {
        Objects.requireNonNull(forcedException);
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        if (forcedExceptionMetadata.has(keyName)) {
            return forcedExceptionMetadata.getString(keyName);
        }
        return defaultValue;
    }

    public static Status generateExceptionFromForcedException(FilibusterClientInstrumentor filibusterClientInstrumentor) {
        JSONObject forcedException = filibusterClientInstrumentor.getForcedException();
        Objects.requireNonNull(forcedException);
        String exceptionNameString = FilibusterShared.getForcedExceptionValue(forcedException, "name", "");
        String codeStr = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "code", null);
        String descriptionStr = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "description", null);
        String causeString = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "cause", null);
        String causeMessageString = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "cause_message", null);
        Status status = FilibusterShared.generateExceptionFromForcedException(exceptionNameString, codeStr, descriptionStr, causeString, causeMessageString);
        HashMap<String, String> additionalMetadata = new HashMap<String, String>();
        additionalMetadata.put("code", codeStr);
        additionalMetadata.put("description", descriptionStr);
        filibusterClientInstrumentor.afterInvocationWithException(exceptionNameString, causeString, additionalMetadata, status);
        return status;
    }

    public static Status generateExceptionFromForcedException(String exceptionNameString, @Nullable String codeStr, @Nullable String descriptionStr, @Nullable String causeString, @Nullable String causeMessageString) {
        Status status;
        if (causeString != null && !causeString.isEmpty()) {
            try {
                String throwableMessage = "Filibuster generated exception.";
                if (causeMessageString != null && !causeMessageString.isEmpty()) {
                    throwableMessage = causeMessageString;
                }
                Throwable throwable = Class.forName(causeString).asSubclass(Throwable.class).getConstructor(String.class).newInstance(throwableMessage);
                status = Status.fromThrowable((Throwable)throwable);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FilibusterFaultInjectionException("Unable to generate custom exception from string '" + causeString + "':" + e, e);
            }
        } else if (!codeStr.isEmpty()) {
            Status.Code code = Status.Code.valueOf((String)codeStr);
            status = descriptionStr != null ? Status.fromCode((Status.Code)code).withDescription(descriptionStr) : Status.fromCode((Status.Code)code);
        } else {
            throw new FilibusterFaultInjectionException("No code or cause provided for injection of io.grpc.StatusRuntimeException.");
        }
        return status;
    }
}

