/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.libraries.armeria.http;

import cloud.filibuster.RpcType;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionException;
import cloud.filibuster.instrumentation.datatypes.Callsite;
import cloud.filibuster.instrumentation.datatypes.CallsiteArguments;
import cloud.filibuster.instrumentation.helpers.Networking;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.instrumentors.FilibusterClientInstrumentor;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import cloud.filibuster.instrumentation.storage.ThreadLocalContextStorage;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.ResponseTimeoutException;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.netty.channel.ConnectTimeoutException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class FilibusterDecoratingHttpClient
extends SimpleDecoratingHttpClient {
    private static final Logger logger = Logger.getLogger(FilibusterDecoratingHttpClient.class.getName());
    protected ContextStorage contextStorage;
    protected String serviceName;
    public static Boolean disableServerCommunication = false;
    public static Boolean disableInstrumentation = false;
    private static final String logPrefix = "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: ";
    private boolean grpcRpcType = false;

    private static boolean shouldInstrument() {
        return Property.getInstrumentationEnabledProperty() && disableInstrumentation == false;
    }

    private static boolean shouldCommunicateWithServer() {
        return Property.getInstrumentationServerCommunicationEnabledProperty() && disableServerCommunication == false;
    }

    private static boolean isRequestGrpcAsHttp(HttpRequest request) {
        String contentType = request.headers().get((CharSequence)"content-type");
        return contentType != null && contentType.contains("grpc");
    }

    private static boolean isResponseGrpcAsHttp(ResponseHeaders responseHeaders) {
        String contentType = responseHeaders.get((CharSequence)"content-type");
        return contentType != null && contentType.contains("grpc");
    }

    public FilibusterDecoratingHttpClient(HttpClient delegate) {
        super(delegate);
        this.serviceName = System.getenv("SERVICE_NAME");
        this.contextStorage = new ThreadLocalContextStorage();
    }

    public FilibusterDecoratingHttpClient(HttpClient delegate, String serviceName) {
        super(delegate);
        this.serviceName = serviceName;
        this.contextStorage = new ThreadLocalContextStorage();
    }

    public FilibusterDecoratingHttpClient(HttpClient delegate, String serviceName, boolean grpcRpcType) {
        super(delegate);
        this.serviceName = serviceName;
        this.contextStorage = new ThreadLocalContextStorage();
        this.grpcRpcType = true;
    }

    protected void setupContext(ClientRequestContext ctx, HttpRequest req) {
    }

    protected void contextWhenComplete(ClientRequestContext ctx) {
    }

    protected HttpResponse delegateWithContext(ClientRequestContext ctx, HttpRequest req) throws Exception {
        return (HttpResponse)((Client)this.unwrap()).execute(ctx, (Request)req);
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        Callsite callsite;
        String classOrModuleName;
        if (!FilibusterDecoratingHttpClient.shouldInstrument() || req.headers().contains((CharSequence)"X-Filibuster-Instrumentation")) {
            boolean shouldInstrument = FilibusterDecoratingHttpClient.shouldInstrument();
            boolean isInstrumentationRequest = req.headers().contains((CharSequence)"X-Filibuster-Instrumentation");
            return (HttpResponse)((Client)this.unwrap()).execute(ctx, (Request)req);
        }
        ArrayList<String> serializedArguments = new ArrayList<String>();
        serializedArguments.add(req.headers().uri().toString());
        if (!FilibusterDecoratingHttpClient.isRequestGrpcAsHttp(req)) {
            if (req.method().toString().equals("POST") || req.method().toString().equals("PUT")) {
                int payloadHashCode = -1;
                String payloadString = null;
                try {
                    Field f1 = req.getClass().getDeclaredField("delegate");
                    f1.setAccessible(true);
                    Object f1Delegate = f1.get(req);
                    Field f2 = f1Delegate.getClass().getSuperclass().getDeclaredField("obj");
                    f2.setAccessible(true);
                    HttpData f2ByteArray = (HttpData)f2.get(f1Delegate);
                    payloadHashCode = f2ByteArray.hashCode();
                    payloadString = f2ByteArray.toStringAscii();
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    logger.log(Level.SEVERE, "!!! Possible dynamic reduction risk: could not serialize arguments for callsite identification");
                }
                if (payloadString != null) {
                    serializedArguments.add(payloadString);
                } else {
                    serializedArguments.add(String.valueOf(payloadHashCode));
                }
            }
            classOrModuleName = "WebClient";
            callsite = new Callsite(this.serviceName, classOrModuleName, req.method().toString(), new CallsiteArguments(req.getClass(), "[" + String.join((CharSequence)",", serializedArguments) + "]"));
        } else {
            classOrModuleName = "GrpcClient";
            String path = req.path();
            String grpcFullMethodName = path.indexOf("/") == 0 ? path.substring(path.indexOf("/") + 1) : path;
            String grpcServiceName = grpcFullMethodName.substring(0, grpcFullMethodName.indexOf("/"));
            callsite = new Callsite(this.serviceName, grpcServiceName, grpcFullMethodName, new CallsiteArguments(req.getClass(), String.join((CharSequence)"-", serializedArguments)));
        }
        final FilibusterClientInstrumentor filibusterClientInstrumentor = new FilibusterClientInstrumentor(this.serviceName, FilibusterDecoratingHttpClient.shouldCommunicateWithServer(), this.contextStorage, callsite);
        filibusterClientInstrumentor.prepareForInvocation();
        this.setupContext(ctx, req);
        if (this.grpcRpcType) {
            filibusterClientInstrumentor.setRpcType(RpcType.GRPC);
        }
        filibusterClientInstrumentor.beforeInvocation();
        final JSONObject forcedException = filibusterClientInstrumentor.getForcedException();
        JSONObject failureMetadata = filibusterClientInstrumentor.getFailureMetadata();
        JSONObject transformerFault = filibusterClientInstrumentor.getTransformerFault();
        logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: forcedException: " + forcedException);
        logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: failureMetadata: " + failureMetadata);
        logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: transformerFault: " + transformerFault);
        RequestHeadersBuilder newHeaders = req.headers().toBuilder();
        String outgoingRequestId = filibusterClientInstrumentor.getOutgoingRequestId();
        newHeaders.add((CharSequence)"X-Filibuster-Request-Id", outgoingRequestId);
        if (filibusterClientInstrumentor.getGeneratedId() > -1) {
            newHeaders.add((CharSequence)"X-Filibuster-Generated-Id", String.valueOf(filibusterClientInstrumentor.getGeneratedId()));
        }
        newHeaders.add((CharSequence)"X-Filibuster-VClock", filibusterClientInstrumentor.getVectorClock().toString());
        newHeaders.add((CharSequence)"X-Filibuster-Origin-VClock", filibusterClientInstrumentor.getOriginVectorClock().toString());
        newHeaders.add((CharSequence)"X-Filibuster-Execution-Index", filibusterClientInstrumentor.getDistributedExecutionIndex().toString());
        if (forcedException != null) {
            JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
            if (forcedExceptionMetadata.has("sleep")) {
                int sleepInterval = forcedExceptionMetadata.getInt("sleep");
                newHeaders.add((CharSequence)"X-Filibuster-Forced-Sleep", String.valueOf(sleepInterval));
            } else {
                newHeaders.add((CharSequence)"X-Filibuster-Forced-Sleep", String.valueOf(0));
            }
        }
        req = req.withHeaders(newHeaders);
        ctx.updateRequest(req);
        String uri = req.uri().toString();
        Map.Entry<String, String> hostnameAndPort = Networking.extractHostnameAndPortFromUri(uri);
        final String hostname = hostnameAndPort.getKey();
        final String port = hostnameAndPort.getValue();
        final String hostnameForExceptionBody = Networking.attemptHostnameResolution(hostname, uri);
        if (failureMetadata != null) {
            if (FilibusterDecoratingHttpClient.isRequestGrpcAsHttp(req)) {
                String statusCodeMsg = failureMetadata.getJSONObject("exception").getJSONObject("metadata").getString("code");
                int statusCode = Status.Code.valueOf((String)statusCodeMsg).value();
                HashMap<String, String> additionalMetadata = new HashMap<String, String>();
                additionalMetadata.put("code", statusCodeMsg);
                String exceptionName = "io.grpc.StatusRuntimeException";
                filibusterClientInstrumentor.afterInvocationWithException(exceptionName, null, additionalMetadata);
                return FilibusterDecoratingHttpClient.generateResponseWithErrorHeaders(ctx, statusCode);
            }
            JSONObject returnValue = failureMetadata.getJSONObject("return_value");
            String statusCode = returnValue.getString("status_code");
            String className = "com.linecorp.armeria.common.HttpResponse";
            HashMap<String, String> returnValueProperties = new HashMap<String, String>();
            returnValueProperties.put("status_code", statusCode);
            filibusterClientInstrumentor.afterInvocationComplete(className, returnValueProperties);
            return HttpResponse.of((HttpStatus)HttpStatus.valueOf((String)statusCode));
        }
        if (forcedException != null && filibusterClientInstrumentor.shouldAbort()) {
            if (FilibusterDecoratingHttpClient.isRequestGrpcAsHttp(req)) {
                String statusCodeMsg = forcedException.getJSONObject("metadata").getString("code");
                int statusCode = Status.Code.valueOf((String)statusCodeMsg).value();
                HashMap<String, String> additionalMetadata = new HashMap<String, String>();
                additionalMetadata.put("code", statusCodeMsg);
                String exceptionName = "io.grpc.StatusRuntimeException";
                filibusterClientInstrumentor.afterInvocationWithException(exceptionName, null, additionalMetadata);
                return FilibusterDecoratingHttpClient.generateResponseWithErrorHeaders(ctx, statusCode);
            }
            FilibusterDecoratingHttpClient.generateAndThrowException(filibusterClientInstrumentor, forcedException, hostname, hostnameForExceptionBody, port);
        }
        logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: Issuing request!");
        HttpResponse response = transformerFault != null && filibusterClientInstrumentor.shouldAbort() ? FilibusterDecoratingHttpClient.injectTransformerFault(transformerFault) : this.delegateWithContext(ctx, req);
        response.whenComplete().handle((result, cause) -> {
            if (cause != null) {
                logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: cause: " + cause);
                if (!(cause instanceof CancelledSubscriptionException)) {
                    filibusterClientInstrumentor.afterInvocationWithException((Throwable)cause);
                }
            }
            return null;
        });
        this.contextWhenComplete(ctx);
        return new FilteredHttpResponse(response){
            ResponseHeaders responseHeaders;
            List<String> response;
            {
                super(delegate);
                this.response = new ArrayList<String>();
            }

            @CanIgnoreReturnValue
            protected HttpObject filter(HttpObject obj) {
                if (!filibusterClientInstrumentor.shouldAbort()) {
                    if (forcedException != null) {
                        FilibusterDecoratingHttpClient.generateAndThrowException(filibusterClientInstrumentor, forcedException, hostname, hostnameForExceptionBody, port);
                    }
                } else if (obj instanceof ResponseHeaders) {
                    this.responseHeaders = (ResponseHeaders)obj;
                    logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: responseHeaders: " + this.responseHeaders);
                    if (FilibusterDecoratingHttpClient.isResponseGrpcAsHttp(this.responseHeaders)) {
                        if (this.responseHeaders.get((CharSequence)"grpc-status") != null && !Objects.equals(this.responseHeaders.get((CharSequence)"grpc-status"), "0")) {
                            HashMap<String, String> additionalMetadata = new HashMap<String, String>();
                            int grpcErrorCode = Integer.parseInt(this.responseHeaders.get((CharSequence)"grpc-status"));
                            additionalMetadata.put("code", Status.Code.values()[grpcErrorCode].toString());
                            String exceptionName = "io.grpc.StatusRuntimeException";
                            filibusterClientInstrumentor.afterInvocationWithException(exceptionName, null, additionalMetadata);
                        } else {
                            String className = "io.grpc.StatusRuntimeException";
                            HashMap<String, String> returnValueProperties = new HashMap<String, String>();
                            filibusterClientInstrumentor.afterInvocationComplete(className, returnValueProperties);
                        }
                    } else {
                        String className = "com.linecorp.armeria.common.HttpResponse";
                        String statusCode = this.responseHeaders.get((CharSequence)HttpHeaderNames.STATUS);
                        logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: statusCode: " + statusCode);
                        logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: Notifying Filibuster!!!");
                        HashMap<String, String> returnValueProperties = new HashMap<String, String>();
                        returnValueProperties.put("status_code", statusCode);
                        filibusterClientInstrumentor.afterInvocationComplete(className, returnValueProperties, false, statusCode);
                    }
                } else if (obj instanceof HttpData) {
                    HttpData responseData = (HttpData)obj;
                    if (!responseData.isEmpty()) {
                        this.response.add(responseData.toStringAscii());
                    }
                    String className = "com.linecorp.armeria.common.HttpResponse";
                    String statusCode = this.responseHeaders.get((CharSequence)HttpHeaderNames.STATUS);
                    logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: statusCode: " + statusCode);
                    logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: Notifying Filibuster!!!");
                    HashMap<String, String> returnValueProperties = new HashMap<String, String>();
                    returnValueProperties.put("status_code", statusCode);
                    filibusterClientInstrumentor.afterInvocationComplete(className, returnValueProperties, true, String.join((CharSequence)"", this.response));
                }
                return obj;
            }
        };
    }

    private static HttpResponse injectTransformerFault(JSONObject transformerFault) {
        try {
            if (transformerFault.has("value") && transformerFault.has("accumulator")) {
                Object transformerFaultValue = transformerFault.get("value");
                logger.log(Level.INFO, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: Injecting the transformed fault value: " + transformerFaultValue);
                if (transformerFaultValue == JSONObject.NULL) {
                    transformerFaultValue = null;
                }
                return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.PLAIN_TEXT, (String)String.valueOf(transformerFaultValue));
            }
            String missingKey = transformerFault.has("value") ? "accumulator" : "value";
            logger.log(Level.WARNING, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: injectTransformerFault: The transformerFault does not have the required key " + missingKey);
            throw new FilibusterFaultInjectionException("injectTransformerFault: The transformerFault does not have the required key " + missingKey);
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "[FILIBUSTER-ARMERIA_HTTP_CLIENT]: Could not inject transformer fault. The cast was probably not successful:", e);
            throw new FilibusterFaultInjectionException("Could not inject transformer fault. The cast was probably not successful:", e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateAndThrowException(FilibusterClientInstrumentor filibusterClientInstrumentor, JSONObject forcedException, String hostname, String hostnameForExceptionBody, String port) {
        void var8_14;
        String exceptionNameString = forcedException.getString("name");
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        String causeString = forcedExceptionMetadata.getString("cause");
        if (exceptionNameString.equals("com.linecorp.armeria.client.UnprocessedRequestException")) {
            if (!causeString.equals("io.netty.channel.ConnectTimeoutException")) throw new FilibusterFaultInjectionException("Cannot determine the execution cause to throw: " + causeString);
            String message = "connection timed out: " + hostname + "/" + hostnameForExceptionBody + ":" + port;
            ConnectTimeoutException cause = new ConnectTimeoutException(message);
            UnprocessedRequestException unprocessedRequestException = UnprocessedRequestException.of((Throwable)cause);
        } else if (exceptionNameString.equals("com.linecorp.armeria.client.ResponseTimeoutException")) {
            ResponseTimeoutException responseTimeoutException = ResponseTimeoutException.get();
        } else {
            if (!Objects.equals(exceptionNameString, "io.grpc.StatusRuntimeException")) throw new FilibusterFaultInjectionException("Cannot determine the execution to throw: " + exceptionNameString);
            String grpcErrorCode = forcedException.getJSONObject("metadata").get("code").toString();
            StatusRuntimeException statusRuntimeException = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.valueOf((String)grpcErrorCode)));
        }
        if (var8_14 == null) throw new FilibusterFaultInjectionException("Exception is supposed to be thrown, but is null because we could not find a match.");
        filibusterClientInstrumentor.afterInvocationWithException((Throwable)var8_14);
        throw var8_14;
    }

    private static HttpResponse generateResponseWithErrorHeaders(ClientRequestContext ctx, int statusCode) {
        return FilibusterDecoratingHttpClient.generateResponseWithErrorHeaders(ctx, statusCode, "Injected fault from Filibuster, status code: " + statusCode);
    }

    private static HttpResponse generateResponseWithErrorHeaders(ClientRequestContext ctx, int statusCode, String errorMessage) {
        ResponseHeadersBuilder responseHeadersBuilder = ResponseHeaders.builder().status(200).add((CharSequence)"content-type", "application/grpc").add((CharSequence)"content-length", String.valueOf(0)).add((CharSequence)"grpc-status", String.valueOf(statusCode));
        responseHeadersBuilder.endOfStream(true);
        if (errorMessage != null) {
            responseHeadersBuilder.add((CharSequence)"grpc-message", errorMessage);
        }
        ResponseHeaders responseHeaders = responseHeadersBuilder.build();
        RequestLogBuilder logBuilder = ctx.logBuilder();
        logBuilder.responseHeaders(responseHeaders);
        logBuilder.responseTrailers((HttpHeaders)responseHeaders);
        return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)HttpData.empty(), (HttpHeaders)responseHeaders);
    }
}

