/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.libraries.armeria.http;

import cloud.filibuster.instrumentation.datatypes.RequestId;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.instrumentors.FilibusterServerInstrumentor;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import cloud.filibuster.instrumentation.storage.ThreadLocalContextStorage;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilibusterDecoratingHttpService
extends SimpleDecoratingHttpService {
    private static final Logger logger = Logger.getLogger(FilibusterDecoratingHttpService.class.getName());
    protected String serviceName;
    protected ContextStorage contextStorage;
    public static Boolean disableServerCommunication = false;
    public static Boolean disableInstrumentation = false;
    private static final String logPrefix = "[FILIBUSTER-ARMERIA_HTTP_SERVICE]: ";

    private static boolean shouldInstrument() {
        return Property.getInstrumentationEnabledProperty() && disableInstrumentation == false;
    }

    private static boolean shouldCommunicateWithServer() {
        return Property.getInstrumentationServerCommunicationEnabledProperty() && disableServerCommunication == false;
    }

    public FilibusterDecoratingHttpService(HttpService delegate) {
        super(delegate);
        this.serviceName = System.getenv("SERVICE_NAME");
        this.contextStorage = new ThreadLocalContextStorage();
    }

    public FilibusterDecoratingHttpService(HttpService delegate, String serviceName) {
        super(delegate);
        this.serviceName = serviceName;
        this.contextStorage = new ThreadLocalContextStorage();
    }

    protected void setupContext(ServiceRequestContext ctx, HttpRequest req) {
    }

    protected void contextWhenComplete(ServiceRequestContext ctx) {
    }

    protected HttpResponse delegateWithContext(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpService delegate = (HttpService)this.unwrap();
        return delegate.serve(ctx, req);
    }

    public String getRequestIdFromRequestMetadata(HttpRequest req) {
        return req.headers().get((CharSequence)"X-Filibuster-Request-Id", RequestId.generateNewRequestId().toString());
    }

    public String getGeneratedIdFromRequestMetadata(HttpRequest req) {
        return req.headers().get((CharSequence)"X-Filibuster-Generated-Id");
    }

    public String getVectorClockFromRequestMetadata(HttpRequest req) {
        return req.headers().get((CharSequence)"X-Filibuster-VClock");
    }

    public String getOriginVectorClockFromRequestMetadata(HttpRequest req) {
        return req.headers().get((CharSequence)"X-Filibuster-Origin-VClock");
    }

    public String getDistributedExecutionIndexFromRequestMetadata(HttpRequest req) {
        return req.headers().get((CharSequence)"X-Filibuster-Execution-Index");
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (!FilibusterDecoratingHttpService.shouldInstrument()) {
            HttpService delegate = (HttpService)this.unwrap();
            return delegate.serve(ctx, req);
        }
        logger.log(Level.SEVERE, "[FILIBUSTER-ARMERIA_HTTP_SERVICE]: INVOKING CONSTRUCTOR");
        FilibusterServerInstrumentor filibusterServerInstrumentor = new FilibusterServerInstrumentor(this.serviceName, FilibusterDecoratingHttpService.shouldCommunicateWithServer(), this.getRequestIdFromRequestMetadata(req), this.getGeneratedIdFromRequestMetadata(req), this.getVectorClockFromRequestMetadata(req), this.getOriginVectorClockFromRequestMetadata(req), this.getDistributedExecutionIndexFromRequestMetadata(req), this.contextStorage);
        logger.log(Level.SEVERE, "[FILIBUSTER-ARMERIA_HTTP_SERVICE]: DONE");
        logger.log(Level.SEVERE, "[FILIBUSTER-ARMERIA_HTTP_SERVICE]: INVOKING SETUP CONTEXT");
        this.setupContext(ctx, req);
        logger.log(Level.SEVERE, "[FILIBUSTER-ARMERIA_HTTP_SERVICE]: DONE INVOKING SETUP CONTEXT");
        String sleepIntervalStr = req.headers().get((CharSequence)"X-Filibuster-Forced-Sleep", "0");
        int sleepInterval = Integer.parseInt(sleepIntervalStr);
        if (sleepInterval > 0) {
            Thread.sleep((long)sleepInterval * 1000L);
        }
        filibusterServerInstrumentor.beforeInvocation();
        this.contextWhenComplete(ctx);
        return this.delegateWithContext(ctx, req);
    }
}

