/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.libraries.dynamic.proxy;

import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionException;
import cloud.filibuster.exceptions.filibuster.FilibusterRuntimeException;
import cloud.filibuster.instrumentation.datatypes.Callsite;
import cloud.filibuster.instrumentation.datatypes.CallsiteArguments;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.instrumentors.FilibusterClientInstrumentor;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import cloud.filibuster.instrumentation.storage.ThreadLocalContextStorage;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import cloud.filibuster.junit.server.core.transformers.DBException;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.google.gson.Gson;
import io.lettuce.core.RedisBusyException;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.cluster.PartitionSelectorException;
import io.lettuce.core.cluster.UnknownPartitionException;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.dynamic.batch.BatchException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;

public final class DynamicProxyInterceptor<T>
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(DynamicProxyInterceptor.class.getName());
    private final T targetObject;
    public static final Boolean disableInstrumentation = false;
    private final String futureInvokeExceptionOnMethod;
    private final JSONObject futureExceptionMetadata;
    private final ContextStorage contextStorage;
    public static final Boolean disableServerCommunication = false;
    private final String serviceName;
    private final String connectionString;
    private static final String logPrefix = "[FILIBUSTER-PROXY_INTERCEPTOR]: ";
    private FilibusterClientInstrumentor filibusterClientInstrumentor;
    private boolean trackedMethodInvoked;

    private DynamicProxyInterceptor(T targetObject, String connectionString) {
        this(targetObject, connectionString, null, null, false);
    }

    private DynamicProxyInterceptor(T targetObject, String connectionString, @Nullable String futureInvokeExceptionOnMethod, @Nullable JSONObject futureExceptionMetadata, boolean trackedMethodInvoked) {
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: Constructor was called");
        this.targetObject = targetObject;
        this.contextStorage = new ThreadLocalContextStorage();
        this.connectionString = connectionString;
        this.serviceName = DynamicProxyInterceptor.extractServiceFromConnection(connectionString);
        this.futureInvokeExceptionOnMethod = futureInvokeExceptionOnMethod;
        this.futureExceptionMetadata = futureExceptionMetadata;
        this.trackedMethodInvoked = trackedMethodInvoked;
    }

    private static String extractServiceFromConnection(String connectionString) {
        if (Property.getRedisTestPortNondeterminismProperty()) {
            try {
                URI fullServiceName = new URI(connectionString);
                connectionString = fullServiceName.getHost();
            }
            catch (Throwable e) {
                throw new FilibusterRuntimeException("DB connection string could not be processed. URI is probably malformed: ", e);
            }
        }
        return connectionString;
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: invoke() called");
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: shouldInstrument() is " + DynamicProxyInterceptor.shouldInstrument());
        String classNameOfInvokedMethod = method.getDeclaringClass().getName();
        String simpleMethodName = method.getName();
        String fullMethodName = String.format("%s/%s", classNameOfInvokedMethod, simpleMethodName);
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: fullMethodName: " + fullMethodName);
        Class argsClass = args != null ? args.getClass() : Object[].class;
        String argsString = args != null ? Arrays.toString(args) : "[]";
        CallsiteArguments callsiteArguments = new CallsiteArguments(argsClass, argsString);
        Callsite callsite = new Callsite(this.serviceName, classNameOfInvokedMethod, fullMethodName, callsiteArguments);
        this.filibusterClientInstrumentor = new FilibusterClientInstrumentor(this.serviceName, DynamicProxyInterceptor.shouldCommunicateWithServer(), this.contextStorage, callsite);
        this.filibusterClientInstrumentor.prepareForInvocation();
        this.filibusterClientInstrumentor.beforeInvocation();
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: requestId: " + this.filibusterClientInstrumentor.getOutgoingRequestId());
        JSONObject forcedException = this.filibusterClientInstrumentor.getForcedException();
        JSONObject failureMetadata = this.filibusterClientInstrumentor.getFailureMetadata();
        JSONObject transformerFault = this.filibusterClientInstrumentor.getTransformerFault();
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: forcedException: " + forcedException);
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: failureMetadata: " + failureMetadata);
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: transformerFault: " + transformerFault);
        if (failureMetadata != null && this.filibusterClientInstrumentor.shouldAbort()) {
            DynamicProxyInterceptor.generateExceptionFromFailureMetadata();
        }
        String futureInvokeExceptionOnMethod = null;
        JSONObject futureExceptionMetadata = null;
        if (transformerFault != null && this.filibusterClientInstrumentor.shouldAbort()) {
            Object transformerFaultValue = DynamicProxyInterceptor.getTransformerFaultValue(this.filibusterClientInstrumentor, transformerFault, method.getReturnType());
            if (transformerFaultValue instanceof DBException) {
                forcedException = DynamicProxyInterceptor.getJsonExceptionFromTransformerFault((DBException)transformerFaultValue);
            } else {
                return transformerFaultValue;
            }
        }
        if (forcedException != null && this.filibusterClientInstrumentor.shouldAbort()) {
            boolean shouldInjectExceptionOnCurrentMethod = DynamicProxyInterceptor.shouldInjectExceptionOnCurrentMethod(forcedException, fullMethodName);
            if (shouldInjectExceptionOnCurrentMethod) {
                DynamicProxyInterceptor.generateAndThrowException(this.filibusterClientInstrumentor, forcedException);
            } else {
                futureInvokeExceptionOnMethod = DynamicProxyInterceptor.getExceptionMethodName(forcedException, fullMethodName);
                futureExceptionMetadata = forcedException;
            }
        }
        if (this.futureExceptionMetadata != null) {
            this.currentMethodIsTracked(this.futureExceptionMetadata, fullMethodName);
            if (this.futureInvokeExceptionOnMethod != null && this.futureInvokeExceptionOnMethod.equals(fullMethodName) && this.filibusterClientInstrumentor.shouldAbort()) {
                this.trackedMethodInvoked = false;
                DynamicProxyInterceptor.generateAndThrowException(this.filibusterClientInstrumentor, this.futureExceptionMetadata);
            }
        }
        Object invocationResult = this.invokeOnInterceptedObject(method, args);
        HashMap<String, String> returnValueProperties = new HashMap<String, String>();
        if (invocationResult != null) {
            String sInvocationResult = (invocationResult.getClass().getName().contains("jdk.proxy") || invocationResult.getClass().getName().contains("org.postgresql.jdbc")) && invocationResult.toString().matches(".*\\..*@.*") ? invocationResult.toString().split("@")[0] : invocationResult.toString();
            returnValueProperties.put("toString", sInvocationResult);
            returnValueProperties.put("trackedMethodInvoked", String.valueOf(this.trackedMethodInvoked));
            if (method.getReturnType().isInterface() && method.getReturnType().getClassLoader() != null) {
                invocationResult = DynamicProxyInterceptor.createInterceptor(invocationResult, this.connectionString, futureInvokeExceptionOnMethod, futureExceptionMetadata, this.trackedMethodInvoked);
                this.filibusterClientInstrumentor.afterInvocationComplete(method.getReturnType().getName(), returnValueProperties);
            } else {
                this.filibusterClientInstrumentor.afterInvocationComplete(invocationResult.getClass().getName(), returnValueProperties, false, invocationResult);
            }
        } else {
            returnValueProperties.put("toString", null);
            this.filibusterClientInstrumentor.afterInvocationComplete(method.getReturnType().getName(), returnValueProperties);
        }
        return invocationResult;
    }

    private static JSONObject getJsonExceptionFromTransformerFault(DBException transformerFaultValue) {
        JSONObject forcedException = new JSONObject();
        forcedException.put("name", (Object)transformerFaultValue.getName());
        forcedException.put("metadata", transformerFaultValue.getMetadata());
        forcedException.put("isTransformerFault", true);
        return forcedException;
    }

    private Object invokeOnInterceptedObject(Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        try {
            return method.invoke(this.targetObject, args);
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: An exception was thrown in invokeOnInterceptedObject ", t.getMessage());
            this.filibusterClientInstrumentor.afterInvocationWithException(t);
            throw t;
        }
    }

    @Nullable
    private static Object getTransformerFaultValue(FilibusterClientInstrumentor filibusterClientInstrumentor, JSONObject transformerFault, Class<?> returnType) {
        try {
            if (transformerFault.has("value") && transformerFault.has("accumulator")) {
                Object transformerFaultValue = transformerFault.get("value");
                String sTransformerValue = String.valueOf(transformerFaultValue);
                logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: Injecting the transformed fault value: " + sTransformerValue);
                Accumulator accumulator = (Accumulator)new Gson().fromJson(transformerFault.get("accumulator").toString(), Accumulator.class);
                if (transformerFaultValue instanceof DBException) {
                    filibusterClientInstrumentor.afterInvocationWithTransformerFault(sTransformerValue, ((DBException)transformerFaultValue).getName(), accumulator);
                } else {
                    filibusterClientInstrumentor.afterInvocationWithTransformerFault(sTransformerValue, returnType.toString(), accumulator);
                }
                return transformerFaultValue == JSONObject.NULL ? null : transformerFaultValue;
            }
            String missingKey = transformerFault.has("value") ? "accumulator" : "value";
            logger.log(Level.WARNING, "[FILIBUSTER-PROXY_INTERCEPTOR]: injectTransformerFault: The transformerFault does not have the required key " + missingKey);
            throw new FilibusterFaultInjectionException("injectTransformerFault: The transformerFault does not have the required key " + missingKey);
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "[FILIBUSTER-PROXY_INTERCEPTOR]: Could not inject transformer fault. The cast was probably not successful:", e);
            throw new FilibusterFaultInjectionException("Could not inject transformer fault. The cast was probably not successful:", e);
        }
    }

    private static boolean shouldInjectExceptionOnCurrentMethod(JSONObject forcedException, String currentMethodName) {
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        if (forcedExceptionMetadata.has("injectOn")) {
            String injectOn = forcedExceptionMetadata.getString("injectOn");
            return injectOn.equals(currentMethodName);
        }
        return true;
    }

    private void currentMethodIsTracked(JSONObject forcedException, String currentMethodName) {
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        if (forcedExceptionMetadata.has("trackInvocationOf")) {
            String trackInvocationOf = forcedExceptionMetadata.getString("trackInvocationOf");
            this.trackedMethodInvoked = this.trackedMethodInvoked || Pattern.compile(trackInvocationOf).matcher(currentMethodName).find();
        }
    }

    private static String getExceptionMethodName(JSONObject forcedException, String currentMethodName) {
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        if (forcedExceptionMetadata.has("injectOn")) {
            return forcedExceptionMetadata.getString("injectOn");
        }
        return currentMethodName;
    }

    private static void generateAndThrowException(FilibusterClientInstrumentor filibusterClientInstrumentor, JSONObject forcedException) throws Exception {
        String sExceptionName = forcedException.getString("name");
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        String sCause = forcedExceptionMetadata.getString("cause");
        String sCode = forcedExceptionMetadata.getString("code");
        boolean isTransformerFault = forcedException.has("isTransformerFault") && forcedException.getBoolean("isTransformerFault");
        DynamicProxyInterceptor.throwExceptionAndNotifyFilibuster(filibusterClientInstrumentor, sExceptionName, sCause, sCode, isTransformerFault);
    }

    private static void throwExceptionAndNotifyFilibuster(FilibusterClientInstrumentor filibusterClientInstrumentor, String exceptionName, String cause, String code, boolean isTransformerFault) throws Exception {
        Exception exceptionToThrow;
        Random rand = new Random(0L);
        switch (exceptionName) {
            case "org.postgresql.util.PSQLException": {
                exceptionToThrow = new PSQLException(new ServerErrorMessage(cause));
                break;
            }
            case "java.sql.SQLException": {
                exceptionToThrow = new SQLException(cause);
                break;
            }
            case "java.sql.SQLTimeoutException": {
                exceptionToThrow = new SQLTimeoutException(cause);
                break;
            }
            case "com.datastax.oss.driver.api.core.servererrors.OverloadedException": {
                exceptionToThrow = new OverloadedException(null);
                break;
            }
            case "com.datastax.oss.driver.api.core.servererrors.InvalidQueryException": {
                exceptionToThrow = new InvalidQueryException(null, cause);
                break;
            }
            case "com.datastax.oss.driver.api.core.servererrors.ReadFailureException": {
                exceptionToThrow = new ReadFailureException(null, null, rand.nextInt(), rand.nextInt(), rand.nextInt(), true, null);
                break;
            }
            case "com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException": {
                exceptionToThrow = new ReadTimeoutException(null, null, rand.nextInt(), rand.nextInt(), true);
                break;
            }
            case "com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException": {
                exceptionToThrow = new WriteTimeoutException(null, null, rand.nextInt(), rand.nextInt(), null);
                break;
            }
            case "com.datastax.oss.driver.api.core.servererrors.WriteFailureException": {
                exceptionToThrow = new WriteFailureException(null, null, rand.nextInt(), rand.nextInt(), null, rand.nextInt(), null);
                break;
            }
            case "software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException": {
                exceptionToThrow = (Exception)RequestLimitExceededException.builder().message(cause).statusCode(Integer.parseInt(code)).requestId(UUID.randomUUID().toString().replace("-", "").toUpperCase(Locale.ROOT)).build();
                break;
            }
            case "software.amazon.awssdk.services.dynamodb.model.SdkClientException": {
                exceptionToThrow = SdkClientException.builder().message(cause).build();
                break;
            }
            case "software.amazon.awssdk.services.dynamodb.model.DynamoDbException": {
                exceptionToThrow = DynamoDbException.builder().message(cause).statusCode(Integer.parseInt(code)).requestId(UUID.randomUUID().toString().replace("-", "").toUpperCase(Locale.ROOT)).build();
                break;
            }
            case "software.amazon.awssdk.services.dynamodb.model.AwsServiceException": {
                exceptionToThrow = AwsServiceException.builder().message(cause).statusCode(Integer.parseInt(code)).requestId(UUID.randomUUID().toString().replace("-", "").toUpperCase(Locale.ROOT)).build();
                break;
            }
            case "io.lettuce.core.RedisCommandTimeoutException": {
                exceptionToThrow = new RedisCommandTimeoutException(cause);
                break;
            }
            case "io.lettuce.core.RedisConnectionException": {
                exceptionToThrow = new RedisConnectionException(cause);
                break;
            }
            case "io.lettuce.core.RedisBusyException": {
                exceptionToThrow = new RedisBusyException(cause);
                break;
            }
            case "io.lettuce.core.RedisCommandExecutionException": {
                exceptionToThrow = new RedisCommandExecutionException(cause);
                break;
            }
            case "io.lettuce.core.RedisCommandInterruptedException": {
                exceptionToThrow = new RedisCommandInterruptedException(new Throwable(cause));
                break;
            }
            case "io.lettuce.core.cluster.UnknownPartitionException": {
                exceptionToThrow = new UnknownPartitionException(cause);
                break;
            }
            case "io.lettuce.core.cluster.PartitionSelectorException": {
                exceptionToThrow = new PartitionSelectorException(cause, new Partitions());
                break;
            }
            case "io.lettuce.core.dynamic.batch.BatchException": {
                exceptionToThrow = new BatchException(new ArrayList());
                break;
            }
            default: {
                throw new FilibusterFaultInjectionException("Cannot determine the execution cause to throw: " + cause);
            }
        }
        if (!isTransformerFault) {
            filibusterClientInstrumentor.afterInvocationWithException(exceptionToThrow);
        }
        throw exceptionToThrow;
    }

    private static void generateExceptionFromFailureMetadata() {
        throw new FilibusterFaultInjectionException("Failure metadata not supported for Lettuce.");
    }

    private static boolean shouldInstrument() {
        return Property.getInstrumentationEnabledProperty() && disableInstrumentation == false;
    }

    private static boolean shouldCommunicateWithServer() {
        return Property.getInstrumentationServerCommunicationEnabledProperty() && disableServerCommunication == false;
    }

    private static <T> T createProxy(T target, DynamicProxyInterceptor<?> dynamicProxyInterceptor) {
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: createProxy was called");
        return (T)Proxy.newProxyInstance(target.getClass().getClassLoader(), target.getClass().getInterfaces(), dynamicProxyInterceptor);
    }

    private static <T> T createInterceptor(T target, String connectionString, String futureInvokeExceptionOnMethod, JSONObject futureExceptionMetadata, boolean trackedMethodInvoked) {
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: createInterceptor was called");
        return DynamicProxyInterceptor.createProxy(target, new DynamicProxyInterceptor<T>(target, connectionString, futureInvokeExceptionOnMethod, futureExceptionMetadata, trackedMethodInvoked));
    }

    public static <T> T createInterceptor(T target, String connectionString) {
        logger.log(Level.INFO, "[FILIBUSTER-PROXY_INTERCEPTOR]: createInterceptor was called");
        return DynamicProxyInterceptor.createProxy(target, new DynamicProxyInterceptor<T>(target, connectionString));
    }
}

