/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.libraries.grpc;

import cloud.filibuster.RpcType;
import cloud.filibuster.exceptions.filibuster.FilibusterFaultInjectionException;
import cloud.filibuster.exceptions.filibuster.FilibusterInstrumentationMissingDelegateException;
import cloud.filibuster.instrumentation.datatypes.Callsite;
import cloud.filibuster.instrumentation.datatypes.CallsiteArguments;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.instrumentors.FilibusterClientInstrumentor;
import cloud.filibuster.instrumentation.instrumentors.FilibusterShared;
import cloud.filibuster.instrumentation.libraries.grpc.NoopClientCall;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import cloud.filibuster.instrumentation.storage.ThreadLocalContextStorage;
import cloud.filibuster.junit.server.core.transformers.Accumulator;
import com.google.gson.Gson;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.json.JSONObject;

public class FilibusterClientInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(FilibusterClientInterceptor.class.getName());
    protected String serviceName;
    protected ContextStorage contextStorage;
    public static Boolean disableServerCommunication = false;
    public static Boolean disableInstrumentation = false;
    private static final String logPrefix = "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: ";

    private static boolean shouldInstrument() {
        return Property.getInstrumentationEnabledProperty() && disableInstrumentation == false;
    }

    private static boolean shouldCommunicateWithServer() {
        return Property.getInstrumentationServerCommunicationEnabledProperty() && disableServerCommunication == false;
    }

    private static Status generateCorrectStatusForAbort(FilibusterClientInstrumentor filibusterClientInstrumentor) {
        JSONObject forcedException = filibusterClientInstrumentor.getForcedException();
        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
        String codeStr = forcedExceptionMetadata.getString("code");
        Status.Code code = Status.Code.valueOf((String)codeStr);
        Status status = Status.fromCode((Status.Code)code);
        return status;
    }

    private static Status generateExceptionFromFailureMetadata(FilibusterClientInstrumentor filibusterClientInstrumentor) {
        JSONObject failureMetadata = filibusterClientInstrumentor.getFailureMetadata();
        Objects.requireNonNull(failureMetadata);
        JSONObject exception = failureMetadata.getJSONObject("exception");
        JSONObject exceptionMetadata = exception.getJSONObject("metadata");
        String exceptionNameString = "io.grpc.StatusRuntimeException";
        String codeStr = exceptionMetadata.getString("code");
        Status.Code code = Status.Code.valueOf((String)codeStr);
        String causeString = "";
        Status status = Status.fromCode((Status.Code)code);
        HashMap<String, String> additionalMetadata = new HashMap<String, String>();
        additionalMetadata.put("name", exceptionNameString);
        additionalMetadata.put("code", codeStr);
        filibusterClientInstrumentor.afterInvocationWithException(exceptionNameString, causeString, additionalMetadata, status);
        return status;
    }

    public FilibusterClientInterceptor() {
        this.serviceName = System.getenv("SERVICE_NAME");
        this.contextStorage = new ThreadLocalContextStorage();
    }

    public FilibusterClientInterceptor(String serviceName) {
        this.serviceName = serviceName;
        this.contextStorage = new ThreadLocalContextStorage();
    }

    @Nullable
    private static <REQUEST> REQUEST injectTransformerFault(FilibusterClientInstrumentor filibusterClientInstrumentor, JSONObject transformerFault, REQUEST originalRequest) {
        try {
            if (transformerFault.has("value") && transformerFault.has("accumulator")) {
                Object transformerFaultValue = transformerFault.get("value");
                String sTransformerValue = transformerFaultValue.toString();
                Object castedValue = transformerFaultValue;
                logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: Injecting the transformed fault value: " + sTransformerValue);
                Accumulator accumulator = (Accumulator)new Gson().fromJson(transformerFault.get("accumulator").toString(), Accumulator.class);
                filibusterClientInstrumentor.afterInvocationWithTransformerFault(sTransformerValue, originalRequest.getClass().toString(), accumulator);
                if (castedValue == JSONObject.NULL) {
                    return null;
                }
                return (REQUEST)castedValue;
            }
            String missingKey = transformerFault.has("value") ? "accumulator" : "value";
            logger.log(Level.WARNING, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: injectTransformerFault: The transformerFault does not have the required key " + missingKey);
            throw new FilibusterFaultInjectionException("injectTransformerFault: The transformerFault does not have the required key " + missingKey);
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: Could not inject transformer fault. The cast was probably not successful:", e);
            throw new FilibusterFaultInjectionException("Could not inject transformer fault. The cast was probably not successful:", e);
        }
    }

    public <REQUEST, RESPONSE> ClientCall<REQUEST, RESPONSE> interceptCall(final MethodDescriptor<REQUEST, RESPONSE> method, final CallOptions callOptions, final Channel next) {
        if (method.getType() != MethodDescriptor.MethodType.UNARY) {
            return next.newCall(method, callOptions);
        }
        return new ForwardingClientCall<REQUEST, RESPONSE>(){
            @Nullable
            private ClientCall<REQUEST, RESPONSE> delegate;
            private ClientCall.Listener<RESPONSE> responseListener;
            @Nullable
            private Metadata headers;
            private int requestTokens;
            private FilibusterClientInstrumentor filibusterClientInstrumentor;

            protected ClientCall<REQUEST, RESPONSE> delegate() {
                if (this.delegate == null) {
                    throw new FilibusterInstrumentationMissingDelegateException("Delegate is null, something threw inside of the Filibuster interceptor previously, scroll to see previous exception.");
                }
                return this.delegate;
            }

            public void start(ClientCall.Listener<RESPONSE> responseListener, Metadata headers) {
                logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: INSIDE: start!");
                this.headers = headers;
                this.responseListener = responseListener;
            }

            public void request(int requests) {
                if (this.delegate == null) {
                    this.requestTokens += requests;
                    return;
                }
                super.request(requests);
            }

            public void sendMessage(REQUEST message) {
                logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: INSIDE: sendMessage!");
                logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: message: " + message.toString());
                String instrumentationRequestStr = (String)this.headers.get(Metadata.Key.of((String)"x-filibuster-instrumentation", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: instrumentationRequestStr: " + instrumentationRequestStr);
                boolean instrumentationRequest = Boolean.parseBoolean(instrumentationRequestStr);
                logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: instrumentationRequest: " + instrumentationRequest);
                if (!FilibusterClientInterceptor.shouldInstrument() || instrumentationRequest) {
                    this.delegate = next.newCall(method, callOptions);
                    super.start(this.responseListener, this.headers);
                    this.headers = null;
                    if (this.requestTokens > 0) {
                        super.request(this.requestTokens);
                        this.requestTokens = 0;
                    }
                } else {
                    Status status;
                    String grpcFullMethodName = method.getFullMethodName();
                    String grpcServiceName = grpcFullMethodName.substring(0, grpcFullMethodName.indexOf("/"));
                    String grpcRpcName = grpcFullMethodName.replace(grpcServiceName + "/", "");
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: method: " + method);
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: grpcFullMethodName: " + grpcFullMethodName);
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: grpcServiceName: " + grpcServiceName);
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: grpcRpcName: " + grpcRpcName);
                    CallsiteArguments callsiteArguments = new CallsiteArguments(message.getClass(), message.toString());
                    Callsite callsite = new Callsite(FilibusterClientInterceptor.this.serviceName, grpcServiceName, grpcFullMethodName, callsiteArguments);
                    this.filibusterClientInstrumentor = new FilibusterClientInstrumentor(FilibusterClientInterceptor.this.serviceName, FilibusterClientInterceptor.shouldCommunicateWithServer(), FilibusterClientInterceptor.this.contextStorage, callsite);
                    if (message instanceof GeneratedMessageV3) {
                        GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)message;
                        this.filibusterClientInstrumentor.prepareForInvocation(generatedMessageV3);
                    } else {
                        this.filibusterClientInstrumentor.prepareForInvocation();
                    }
                    this.filibusterClientInstrumentor.setRpcType(RpcType.GRPC);
                    this.filibusterClientInstrumentor.beforeInvocation();
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: requestId: " + this.filibusterClientInstrumentor.getOutgoingRequestId());
                    if (this.filibusterClientInstrumentor.getOutgoingRequestId() != null) {
                        this.headers.put(Metadata.Key.of((String)"x-filibuster-request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.filibusterClientInstrumentor.getOutgoingRequestId());
                    }
                    if (this.filibusterClientInstrumentor.getGeneratedId() > -1) {
                        this.headers.put(Metadata.Key.of((String)"x-filibuster-generated-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(this.filibusterClientInstrumentor.getGeneratedId()));
                    }
                    this.headers.put(Metadata.Key.of((String)"x-filibuster-vclock", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.filibusterClientInstrumentor.getVectorClock().toString());
                    this.headers.put(Metadata.Key.of((String)"x-filibuster-origin-vclock", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.filibusterClientInstrumentor.getOriginVectorClock().toString());
                    this.headers.put(Metadata.Key.of((String)"x-filibuster-execution-index", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.filibusterClientInstrumentor.getDistributedExecutionIndex().toString());
                    String x = this.filibusterClientInstrumentor.getDistributedExecutionIndex().toString();
                    JSONObject forcedException = this.filibusterClientInstrumentor.getForcedException();
                    JSONObject failureMetadata = this.filibusterClientInstrumentor.getFailureMetadata();
                    JSONObject transformerFault = this.filibusterClientInstrumentor.getTransformerFault();
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: forcedException: " + forcedException);
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: failureMetadata: " + failureMetadata);
                    logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: transformerFault: " + transformerFault);
                    if (forcedException != null) {
                        JSONObject forcedExceptionMetadata = forcedException.getJSONObject("metadata");
                        if (forcedExceptionMetadata.has("sleep")) {
                            int sleepInterval = forcedExceptionMetadata.getInt("sleep");
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-forced-sleep", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(sleepInterval));
                        } else {
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-forced-sleep", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.valueOf(0));
                        }
                        if (forcedExceptionMetadata.has("defer") && forcedExceptionMetadata.getBoolean("defer")) {
                            String exceptionNameString = FilibusterShared.getForcedExceptionValue(forcedException, "name", "");
                            String codeStr = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "code", "");
                            String descriptionStr = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "description", "");
                            String causeString = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "cause", "");
                            String causeMessageString = FilibusterShared.getForcedExceptionMetadataValue(forcedException, "cause_message", "");
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-exception-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)exceptionNameString);
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-exception-code", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)codeStr);
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-exception-description", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)descriptionStr);
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-exception-cause", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)causeString);
                            this.headers.put(Metadata.Key.of((String)"x-filibuster-exception-cause-message", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)causeMessageString);
                        }
                    }
                    if (failureMetadata != null && this.filibusterClientInstrumentor.shouldAbort()) {
                        this.delegate = new NoopClientCall();
                        status = FilibusterClientInterceptor.generateExceptionFromFailureMetadata(this.filibusterClientInstrumentor);
                        this.responseListener.onClose(status, new Metadata());
                        return;
                    }
                    if (forcedException != null && this.filibusterClientInstrumentor.shouldAbort()) {
                        this.delegate = new NoopClientCall();
                        status = FilibusterShared.generateExceptionFromForcedException(this.filibusterClientInstrumentor);
                        this.responseListener.onClose(status, new Metadata());
                        return;
                    }
                    if (transformerFault != null && this.filibusterClientInstrumentor.shouldAbort()) {
                        message = FilibusterClientInterceptor.injectTransformerFault(this.filibusterClientInstrumentor, transformerFault, message);
                    }
                    this.delegate = next.newCall(method, callOptions);
                    super.start(new FilibusterClientCallListener(this.responseListener, this.filibusterClientInstrumentor), this.headers);
                    this.headers = null;
                    if (this.requestTokens > 0) {
                        super.request(this.requestTokens);
                        this.requestTokens = 0;
                    }
                }
                super.sendMessage(message);
            }
        };
    }

    final class FilibusterClientCallListener<RESPONSE>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RESPONSE> {
        private final FilibusterClientInstrumentor filibusterClientInstrumentor;

        FilibusterClientCallListener(ClientCall.Listener<RESPONSE> delegate, FilibusterClientInstrumentor filibusterClientInstrumentor) {
            super(delegate);
            this.filibusterClientInstrumentor = filibusterClientInstrumentor;
        }

        public void onMessage(RESPONSE message) {
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: INSIDE: onMessage!");
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: message: " + message);
            if (!this.filibusterClientInstrumentor.shouldAbort()) {
                FilibusterShared.generateExceptionFromForcedException(this.filibusterClientInstrumentor);
            } else {
                String className = message.getClass().getName();
                HashMap<String, String> returnValueProperties = new HashMap<String, String>();
                returnValueProperties.put("toString", message.toString());
                if (message instanceof GeneratedMessageV3) {
                    GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)message;
                    this.filibusterClientInstrumentor.afterInvocationComplete(className, returnValueProperties, false, message, generatedMessageV3);
                } else {
                    this.filibusterClientInstrumentor.afterInvocationComplete(className, returnValueProperties, false, message);
                }
                this.delegate().onMessage(message);
            }
        }

        public void onClose(Status status, Metadata trailers) {
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: INSIDE: onClose!");
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: status: " + status);
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: trailers: " + trailers);
            if (!this.filibusterClientInstrumentor.shouldAbort()) {
                Status rewrittenStatus = FilibusterClientInterceptor.generateCorrectStatusForAbort(this.filibusterClientInstrumentor);
                this.delegate().onClose(rewrittenStatus, trailers);
            }
            if (!status.isOk()) {
                HashMap<String, String> additionalMetadata = new HashMap<String, String>();
                additionalMetadata.put("code", status.getCode().toString());
                additionalMetadata.put("description", status.getDescription());
                String exceptionName = "io.grpc.StatusRuntimeException";
                String cause = null;
                if (status.getCause() != null) {
                    cause = status.getCause().getClass().toString();
                }
                this.filibusterClientInstrumentor.afterInvocationWithException(exceptionName, cause, additionalMetadata, status);
            }
            this.delegate().onClose(status, trailers);
        }

        public void onReady() {
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_CLIENT_INTERCEPTOR]: INSIDE: onReady!");
            this.delegate().onReady();
        }
    }
}

