/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.libraries.grpc;

import cloud.filibuster.instrumentation.datatypes.RequestId;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.instrumentors.FilibusterServerInstrumentor;
import cloud.filibuster.instrumentation.instrumentors.FilibusterShared;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import cloud.filibuster.instrumentation.storage.ThreadLocalContextStorage;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class FilibusterServerInterceptor
implements ServerInterceptor {
    private static final Logger logger = Logger.getLogger(FilibusterServerInterceptor.class.getName());
    protected String serviceName;
    protected ContextStorage contextStorage;
    public static Boolean disableServerCommunication = false;
    public static Boolean disableInstrumentation = false;
    private static final String logPrefix = "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: ";
    @Nullable
    private String requestId;

    private static boolean shouldInstrument() {
        return Property.getInstrumentationEnabledProperty() && disableInstrumentation == false;
    }

    private static boolean shouldCommunicateWithServer() {
        return Property.getInstrumentationServerCommunicationEnabledProperty() && disableServerCommunication == false;
    }

    public FilibusterServerInterceptor() {
        this.serviceName = System.getenv("SERVICE_NAME");
        this.contextStorage = new ThreadLocalContextStorage();
    }

    public FilibusterServerInterceptor(String serviceName) {
        this.serviceName = serviceName;
        this.contextStorage = new ThreadLocalContextStorage();
    }

    public String getRequestIdFromMetadata(Metadata requestHeaders) {
        String requestId = (String)requestHeaders.get(Metadata.Key.of((String)"x-filibuster-request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        if (requestId == null) {
            requestId = RequestId.generateNewRequestId().toString();
        }
        logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: requestId: " + requestId);
        return requestId;
    }

    public String getGeneratedIdFromMetadata(Metadata requestHeaders) {
        String generatedId = (String)requestHeaders.get(Metadata.Key.of((String)"x-filibuster-generated-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: generatedId: " + generatedId);
        return generatedId;
    }

    public String getVectorClockFromMetadata(Metadata requestHeaders) {
        String vclock = (String)requestHeaders.get(Metadata.Key.of((String)"x-filibuster-vclock", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: vclock: " + vclock);
        return vclock;
    }

    public String getOriginVectorClockFromMetadata(Metadata requestHeaders) {
        String originVclock = (String)requestHeaders.get(Metadata.Key.of((String)"x-filibuster-origin-vclock", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: originVclock: " + originVclock);
        return originVclock;
    }

    public String getDistributedExecutionIndexFromMetadata(Metadata requestHeaders) {
        String distributedExecutionIndex = (String)requestHeaders.get(Metadata.Key.of((String)"x-filibuster-execution-index", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: executionIndex: " + distributedExecutionIndex);
        return distributedExecutionIndex;
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
        if (FilibusterServerInterceptor.shouldInstrument()) {
            int sleepInterval;
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: Entering server interceptor...");
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: !!! Entering constructor.");
            FilibusterServerInstrumentor filibusterServerInstrumentor = new FilibusterServerInstrumentor(this.serviceName, FilibusterServerInterceptor.shouldCommunicateWithServer(), this.getRequestIdFromMetadata(headers), this.getGeneratedIdFromMetadata(headers), this.getVectorClockFromMetadata(headers), this.getOriginVectorClockFromMetadata(headers), this.getDistributedExecutionIndexFromMetadata(headers), this.contextStorage);
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: !!! Leaving constructor.");
            String sleepIntervalStr = (String)headers.get(Metadata.Key.of((String)"x-filibuster-forced-sleep", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            if (sleepIntervalStr == null) {
                sleepIntervalStr = "0";
            }
            if ((sleepInterval = Integer.parseInt(sleepIntervalStr)) > 0) {
                try {
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            String exceptionNameString = (String)headers.get(Metadata.Key.of((String)"x-filibuster-exception-name", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            String codeString = (String)headers.get(Metadata.Key.of((String)"x-filibuster-exception-code", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            String descriptionString = (String)headers.get(Metadata.Key.of((String)"x-filibuster-exception-description", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            String causeString = (String)headers.get(Metadata.Key.of((String)"x-filibuster-exception-cause", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            String causeMessageString = (String)headers.get(Metadata.Key.of((String)"x-filibuster-exception-cause-message", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            Status status = null;
            if (exceptionNameString != null && !exceptionNameString.isEmpty()) {
                status = FilibusterShared.generateExceptionFromForcedException(exceptionNameString, codeString, descriptionString, causeString, causeMessageString);
            }
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: !!! Entering beforeInvocation.");
            filibusterServerInstrumentor.beforeInvocation();
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: !!! Leaving beforeInvocation.");
            logger.log(Level.INFO, "[FILIBUSTER-GRPC_SERVER_INTERCEPTOR]: Leaving server interceptor...");
            if (status != null) {
                return next.startCall(new FilibusterErrorServerCall<REQUEST, RESPONSE>(call, status), headers);
            }
        }
        return next.startCall(new FilibusterServerCall<REQUEST, RESPONSE>(call), headers);
    }

    final class FilibusterErrorServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        public FilibusterErrorServerCall(ServerCall<REQUEST, RESPONSE> delegate, Status status) {
            super(delegate);
            delegate.close(status, new Metadata());
        }
    }

    final class FilibusterServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        public FilibusterServerCall(ServerCall<REQUEST, RESPONSE> delegate) {
            super(delegate);
        }
    }
}

