/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.libraries.grpc;

import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.server.core.reports.ServerInvocationAndResponseReport;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.List;
import java.util.UUID;

public class FilibusterServerInvocationInterceptor
implements ServerInterceptor {
    public FilibusterServerInvocationInterceptor(String packageName) {
        ServerInvocationAndResponseReport.loadGrpcEndpoints(packageName);
    }

    public FilibusterServerInvocationInterceptor(Class clazz) {
        ServerInvocationAndResponseReport.loadGrpcEndpoints(clazz);
    }

    public FilibusterServerInvocationInterceptor(List<Class> clazzes) {
        for (Class clazz : clazzes) {
            ServerInvocationAndResponseReport.loadGrpcEndpoints(clazz);
        }
    }

    private static boolean shouldInstrument() {
        return Property.getEnabledProperty();
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata metadata, ServerCallHandler<REQUEST, RESPONSE> next) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        String requestId = UUID.randomUUID().toString();
        return new FilibusterServerCallListener(next.startCall(new FilibusterServerCall<REQUEST, RESPONSE>(call, requestId, fullMethodName), metadata), requestId);
    }

    private static class FilibusterServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        private final String requestId;
        private final String fullMethodName;

        protected FilibusterServerCall(ServerCall<REQUEST, RESPONSE> delegate, String requestId, String fullMethodName) {
            super(delegate);
            this.requestId = requestId;
            this.fullMethodName = fullMethodName;
        }

        public void sendMessage(RESPONSE message) {
            if (!FilibusterServerInvocationInterceptor.shouldInstrument()) {
                super.sendMessage(message);
            } else {
                GeneratedMessageV3 generatedMessage = (GeneratedMessageV3)message;
                ServerInvocationAndResponseReport.endServerInvocation(this.requestId, this.fullMethodName, Status.OK, generatedMessage);
                super.sendMessage(message);
            }
        }

        public void close(Status status, Metadata trailers) {
            if (!FilibusterServerInvocationInterceptor.shouldInstrument()) {
                super.close(status, trailers);
            } else {
                if (!status.equals((Object)Status.OK)) {
                    ServerInvocationAndResponseReport.endServerInvocation(this.requestId, this.fullMethodName, status, null);
                }
                super.close(status, trailers);
            }
        }
    }

    private static class FilibusterServerCallListener<REQUEST>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
        private final String requestId;

        protected FilibusterServerCallListener(ServerCall.Listener<REQUEST> delegate, String requestId) {
            super(delegate);
            this.requestId = requestId;
        }

        public void onMessage(REQUEST message) {
            if (!FilibusterServerInvocationInterceptor.shouldInstrument()) {
                super.onMessage(message);
            } else {
                GeneratedMessageV3 generatedMessage = (GeneratedMessageV3)message;
                ServerInvocationAndResponseReport.beginServerInvocation(this.requestId, generatedMessage);
                super.onMessage(message);
            }
        }
    }
}

