/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.instrumentation.storage;

import cloud.filibuster.instrumentation.datatypes.VectorClock;
import cloud.filibuster.instrumentation.storage.ContextStorage;
import java.util.HashMap;

public class ThreadLocalContextStorage
implements ContextStorage {
    public static boolean useGlobalContext = false;
    private static final HashMap<String, InheritableThreadLocal> threadLocalDictionary = new HashMap();
    private static final HashMap<String, Object> globalDictionary = new HashMap();

    public static void clear() {
        threadLocalDictionary.clear();
        globalDictionary.clear();
    }

    public static <T> void set(String key, T value) {
        if (!useGlobalContext) {
            InheritableThreadLocal threadLocal;
            if (threadLocalDictionary.containsKey(key)) {
                threadLocal = threadLocalDictionary.get(key);
            } else {
                threadLocal = new InheritableThreadLocal();
                threadLocalDictionary.put(key, threadLocal);
            }
            threadLocal.set(value);
        } else {
            globalDictionary.put(key, value);
        }
    }

    public static <T> T get(String key) {
        if (!useGlobalContext) {
            if (threadLocalDictionary.containsKey(key)) {
                InheritableThreadLocal threadLocal = threadLocalDictionary.get(key);
                return threadLocal.get();
            }
            return null;
        }
        if (globalDictionary.containsKey(key)) {
            return (T)globalDictionary.get(key);
        }
        return null;
    }

    @Override
    public String getRequestId() {
        return (String)ThreadLocalContextStorage.get("_filibuster_request_id");
    }

    @Override
    public VectorClock getVectorClock() {
        return (VectorClock)ThreadLocalContextStorage.get("_filibuster_vclock");
    }

    @Override
    public VectorClock getOriginVectorClock() {
        return (VectorClock)ThreadLocalContextStorage.get("_filibuster_origin_vclock");
    }

    @Override
    public String getDistributedExecutionIndex() {
        return (String)ThreadLocalContextStorage.get("_filibuster_execution_index");
    }

    @Override
    public void setRequestId(String requestId) {
        ThreadLocalContextStorage.set("_filibuster_request_id", requestId);
    }

    @Override
    public void setVectorClock(VectorClock vectorClock) {
        ThreadLocalContextStorage.set("_filibuster_vclock", vectorClock);
    }

    @Override
    public void setOriginVectorClock(VectorClock originVectorClock) {
        ThreadLocalContextStorage.set("_filibuster_origin_vclock", originVectorClock);
    }

    @Override
    public void setDistributedExecutionIndex(String distributedExecutionIndex) {
        ThreadLocalContextStorage.set("_filibuster_execution_index", distributedExecutionIndex);
    }
}

