/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.assertions;

import cloud.filibuster.exceptions.filibuster.FilibusterUnsupportedAPIException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.assertions.BlockType;
import cloud.filibuster.junit.server.core.FilibusterCore;

public class Helpers {
    public static void setupBlock(Runnable block) {
        Helpers.incrementTestScopeCounter(BlockType.SETUP);
        Helpers.disableFaultInjection();
        block.run();
        Helpers.enableFaultInjection();
    }

    public static void testBlock(Runnable block) {
        Helpers.incrementTestScopeCounter(BlockType.TEST);
        block.run();
    }

    public static void assertionBlock(Runnable block) {
        Helpers.incrementTestScopeCounter(BlockType.ASSERTION);
        Helpers.disableFaultInjection();
        block.run();
        Helpers.enableFaultInjection();
    }

    public static void teardownBlock(Runnable block) {
        Helpers.incrementTestScopeCounter(BlockType.TEARDOWN);
        Helpers.disableFaultInjection();
        block.run();
        Helpers.enableFaultInjection();
    }

    public static void incrementTestScopeCounter(BlockType blockType) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) {
                throw new FilibusterUnsupportedAPIException("Unable to execute test; @TestWithFilibuster was used but no instance of Core could be found.");
            }
        } else {
            throw new FilibusterUnsupportedAPIException("Unable to execute test; Filibuster must be enabled using @TestWithFilibuster and a supported backend must be supplied.");
        }
        FilibusterCore.getCurrentInstance().incrementTestScopeCounter(blockType);
    }

    private static void disableFaultInjection() {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) {
                throw new FilibusterUnsupportedAPIException("Unable to execute test; @TestWithFilibuster was used but no instance of Core could be found.");
            }
        } else {
            throw new FilibusterUnsupportedAPIException("Unable to execute test; Filibuster must be enabled using @TestWithFilibuster and a supported backend must be supplied.");
        }
        FilibusterCore.getCurrentInstance().disableFaultInjection();
    }

    private static void enableFaultInjection() {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (!FilibusterCore.hasCurrentInstance()) {
                throw new FilibusterUnsupportedAPIException("Unable to execute test; @TestWithFilibuster was used but no instance of Core could be found.");
            }
        } else {
            throw new FilibusterUnsupportedAPIException("Unable to execute test; Filibuster must be enabled using @TestWithFilibuster and a supported backend must be supplied.");
        }
        FilibusterCore.getCurrentInstance().enableFaultInjection();
    }

    public static void executeWithoutFaultInjection(BlockType blockType, Runnable block) {
        Helpers.incrementTestScopeCounter(blockType);
        Helpers.disableFaultInjection();
        block.run();
        Helpers.enableFaultInjection();
    }
}

