/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.assertions.protocols;

import cloud.filibuster.exceptions.filibuster.FilibusterServerBadResponseException;
import cloud.filibuster.instrumentation.datatypes.FilibusterExecutor;
import cloud.filibuster.instrumentation.helpers.Networking;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.instrumentation.helpers.Response;
import cloud.filibuster.junit.assertions.protocols.GrpcAssertions;
import cloud.filibuster.junit.server.core.FilibusterCore;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class GenericAssertions {
    public static boolean wasFaultInjected() {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjected();
            }
            return false;
        }
        return GenericAssertions.wasFaultInjectedHelper("/filibuster/fault-injected");
    }

    public static boolean wasFaultInjectedOnJavaClassAndMethod(String className, String methodName) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnMethod(className, methodName);
            }
            return false;
        }
        return GenericAssertions.wasFaultInjectedHelper("/filibuster/fault-injected/method/" + className + "/" + methodName);
    }

    public static boolean wasFaultInjectedOnJavaClassAndMethod(String fullyQualifiedMethodName) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            String[] split = fullyQualifiedMethodName.split("/", 2);
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnMethod(split[0], split[1]);
            }
            return false;
        }
        return GenericAssertions.wasFaultInjectedHelper("/filibuster/fault-injected/method/" + fullyQualifiedMethodName);
    }

    protected static boolean wasFaultInjectedHelper(String uri) {
        Logger logger = Logger.getLogger(GrpcAssertions.class.getName());
        String filibusterBaseUri = "http://" + Networking.getFilibusterHost() + ":" + Networking.getFilibusterPort() + "/";
        WebClient webClient = FilibusterExecutor.getWebClient(filibusterBaseUri);
        RequestHeaders getHeaders = RequestHeaders.of((HttpMethod)HttpMethod.GET, (String)uri, (CharSequence)HttpHeaderNames.ACCEPT, (String)"application/json");
        try {
            AggregatedHttpResponse response = (AggregatedHttpResponse)webClient.execute(getHeaders).aggregate().join();
            ResponseHeaders headers = response.headers();
            String statusCode = headers.get((CharSequence)HttpHeaderNames.STATUS);
            if (statusCode == null) {
                FilibusterServerBadResponseException.logAndThrow("wasFaultInjected, statusCode: null");
            }
            if (!Objects.equals(statusCode, "200")) {
                FilibusterServerBadResponseException.logAndThrow("wasFaultInjected, statusCode: " + statusCode);
            }
            JSONObject jsonObject = Response.aggregatedHttpResponseToJsonObject(response);
            return jsonObject.getBoolean("result");
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Couldn't connect to Filibuster server, assuming no fault was injected: " + e);
            return false;
        }
    }
}

