/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.assertions.protocols;

import cloud.filibuster.exceptions.filibuster.FilibusterUnsupportedByHTTPServerException;
import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.assertions.BlockType;
import cloud.filibuster.junit.assertions.Helpers;
import cloud.filibuster.junit.assertions.protocols.GenericAssertions;
import cloud.filibuster.junit.server.core.FilibusterCore;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.MethodDescriptor;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class GrpcAssertions
extends GenericAssertions {
    public static void tryGrpcAndCatchGrpcExceptions(Runnable block, ThrowingConsumer<Throwable> catchBlock) throws Throwable {
        Helpers.incrementTestScopeCounter(BlockType.TEST);
        try {
            block.run();
        }
        catch (Throwable t) {
            if (!GrpcAssertions.wasFaultInjected()) {
                throw t;
            }
            if (t instanceof StatusException || t instanceof StatusRuntimeException) {
                catchBlock.accept((Object)t);
            }
            throw t;
        }
    }

    public static boolean wasFaultInjectedOnService(String serviceName) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnService(serviceName);
            }
            return false;
        }
        return GrpcAssertions.wasFaultInjectedHelper("/filibuster/fault-injected/service/" + serviceName);
    }

    public static boolean wasFaultInjectedOnMethod(MethodDescriptor method) {
        String fullyQualifiedMethodName = method.getFullMethodName();
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            String[] split = fullyQualifiedMethodName.split("/", 2);
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnMethod(split[0], split[1]);
            }
            return false;
        }
        return GrpcAssertions.wasFaultInjectedHelper("/filibuster/fault-injected/method/" + fullyQualifiedMethodName);
    }

    public static boolean wasFaultInjectedOnRequest(GeneratedMessage request) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnRequest(request.toString());
            }
            return false;
        }
        throw new FilibusterUnsupportedByHTTPServerException("wasFaultInjectedOnRequest only supported with local server.");
    }

    public static boolean wasFaultInjectedOnRequest(GeneratedMessageV3 request) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnRequest(request.toString());
            }
            return false;
        }
        throw new FilibusterUnsupportedByHTTPServerException("wasFaultInjectedOnRequest only supported with local server.");
    }
}

