/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.assertions.protocols;

import cloud.filibuster.instrumentation.helpers.Property;
import cloud.filibuster.junit.assertions.protocols.GenericAssertions;
import cloud.filibuster.junit.server.core.FilibusterCore;
import com.linecorp.armeria.common.HttpMethod;

public class HttpAssertions {
    public static boolean wasFaultInjectedOnService(String serviceName) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnService(serviceName);
            }
            return false;
        }
        return GenericAssertions.wasFaultInjectedHelper("/filibuster/fault-injected/service/" + serviceName);
    }

    public static boolean wasFaultInjectedOnHttpMethod(HttpMethod httpMethod, String uriPattern) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnHttpMethod(httpMethod, uriPattern);
            }
            return false;
        }
        throw new HttpAssertionsNotImplementedException();
    }

    public static boolean wasFaultInjectedOnHttpRequest(HttpMethod httpMethod, String uriPattern, String serializedRequestPattern) {
        if (Property.getServerBackendCanInvokeDirectlyProperty()) {
            if (FilibusterCore.hasCurrentInstance()) {
                return FilibusterCore.getCurrentInstance().wasFaultInjectedOnHttpRequest(httpMethod, uriPattern, serializedRequestPattern);
            }
            return false;
        }
        throw new HttpAssertionsNotImplementedException();
    }

    public static class HttpAssertionsNotImplementedException
    extends RuntimeException {
    }
}

