/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.configuration;

import cloud.filibuster.RpcType;
import cloud.filibuster.instrumentation.datatypes.Pair;
import cloud.filibuster.junit.server.core.transformers.Transformer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FilibusterAnalysisConfiguration {
    private final JSONObject analysisConfiguration = new JSONObject();
    private final JSONObject configurationObject = new JSONObject();
    private final List<JSONObject> exceptionFaultObjects = new ArrayList<JSONObject>();
    private final List<JSONObject> errorFaultObjects = new ArrayList<JSONObject>();
    private final List<JSONObject> latencyFaultObjects = new ArrayList<JSONObject>();
    private final List<JSONObject> transformerFaultObjects = new ArrayList<JSONObject>();
    private final String name;
    private final String pattern;
    private final RpcType rpcType;

    public FilibusterAnalysisConfiguration(Builder builder) {
        this.name = builder.name;
        this.pattern = builder.pattern;
        this.rpcType = builder.rpcType;
        this.configurationObject.put("pattern", (Object)builder.pattern);
        this.configurationObject.put("rpc_type", (Object)builder.rpcType);
        if (builder.exceptions.size() > 0) {
            this.configurationObject.put("exceptions", (Collection)builder.exceptions);
            for (JSONObject exceptionObject : builder.exceptions) {
                JSONObject exception = new JSONObject();
                exception.put("forced_exception", (Object)exceptionObject);
                this.exceptionFaultObjects.add(exception);
            }
        }
        if (builder.errors.size() > 0) {
            this.configurationObject.put("errors", (Collection)builder.errors);
            for (JSONObject errorObject : builder.errors) {
                JSONObject error = new JSONObject();
                error.put("failure_metadata", (Object)errorObject);
                this.errorFaultObjects.add(error);
            }
        }
        if (builder.latencies.size() > 0) {
            this.configurationObject.put("latencies", (Collection)builder.latencies);
            for (JSONObject latencyObject : builder.latencies) {
                JSONObject latency = new JSONObject();
                latency.put("latency", (Object)latencyObject);
                this.latencyFaultObjects.add(latency);
            }
        }
        if (builder.transformers.size() > 0) {
            this.configurationObject.put("transformers", (Collection)builder.transformers);
            for (JSONObject transformerObject : builder.transformers) {
                JSONObject transformerJson = new JSONObject();
                transformerJson.put("transformer_fault", (Object)transformerObject);
                this.transformerFaultObjects.add(transformerJson);
            }
        }
        this.analysisConfiguration.put(builder.name, (Object)this.configurationObject);
    }

    public List<JSONObject> getExceptionFaultObjects() {
        return this.exceptionFaultObjects;
    }

    public List<JSONObject> getTransformerFaultObjects() {
        return this.transformerFaultObjects;
    }

    public List<JSONObject> getErrorFaultObjects() {
        return this.errorFaultObjects;
    }

    public List<JSONObject> getLatencyFaultObjects() {
        return this.latencyFaultObjects;
    }

    public boolean hasRpcType() {
        return this.rpcType != null;
    }

    public boolean isPatternMatch(String matchString) {
        Pattern pattern = Pattern.compile(this.pattern, 2);
        Matcher matcher = pattern.matcher(matchString);
        return matcher.find();
    }

    public boolean isRpcTypeMatch(RpcType rpcType) {
        return rpcType.equals((Object)this.rpcType);
    }

    public Map.Entry<String, JSONObject> toJsonPair() {
        return Pair.of(this.name, this.configurationObject);
    }

    public String toString() {
        return this.analysisConfiguration.toString();
    }

    public static class Builder {
        private String name;
        private String pattern;
        private RpcType rpcType;
        private final List<JSONObject> exceptions = new ArrayList<JSONObject>();
        private final List<JSONObject> errors = new ArrayList<JSONObject>();
        private final List<JSONObject> latencies = new ArrayList<JSONObject>();
        private final List<JSONObject> transformers = new ArrayList<JSONObject>();

        @CanIgnoreReturnValue
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder error(String serviceName, List<JSONObject> types) {
            JSONObject error = new JSONObject();
            error.put("service_name", (Object)serviceName);
            error.put("types", types);
            this.errors.add(error);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exception(String name, Map<String, String> metadata) {
            JSONObject exception = new JSONObject();
            exception.put("name", (Object)name);
            exception.put("metadata", metadata);
            this.exceptions.add(exception);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder transformer(Class<? extends Transformer<?, ?>> transformer) {
            JSONObject transformerJson = new JSONObject();
            transformerJson.put("transformerClassName", (Object)transformer.getName());
            this.transformers.add(transformerJson);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder latency(MatcherType matcherType, String matcher, int milliseconds) {
            JSONObject latency = new JSONObject();
            latency.put("type", (Object)matcherType.toString());
            latency.put("matcher", (Object)matcher);
            latency.put("milliseconds", milliseconds);
            this.latencies.add(latency);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rpcType(RpcType type) {
            this.rpcType = type;
            return this;
        }

        public FilibusterAnalysisConfiguration build() {
            return new FilibusterAnalysisConfiguration(this);
        }
    }

    public static enum MatcherType {
        SERVICE,
        METHOD;

    }
}

