/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.configuration;

import cloud.filibuster.exceptions.filibuster.FilibusterUnsupportedServerBackendException;
import cloud.filibuster.junit.FilibusterSearchStrategy;
import cloud.filibuster.junit.filters.FilibusterFaultInjectionFilter;
import cloud.filibuster.junit.server.FilibusterServerBackend;
import cloud.filibuster.junit.server.backends.FilibusterDockerServerBackend;
import cloud.filibuster.junit.server.core.profiles.ServiceProfile;
import cloud.filibuster.junit.server.core.profiles.ServiceProfileBehavior;
import cloud.filibuster.junit.server.latency.FilibusterLatencyProfile;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class FilibusterConfiguration {
    private static final String filibusterExecutable = "/usr/local/bin/filibuster";
    private final boolean dynamicReduction;
    private final boolean suppressCombinations;
    private final boolean dataNondeterminism;
    private final boolean avoidRedundantInjections;
    private final boolean avoidInjectionsOnOrganicFailures;
    private final boolean failOnOrganicFailures;
    private final FilibusterSearchStrategy searchStrategy;
    private final String analysisFile;
    private final FilibusterServerBackend serverBackend;
    private final String dockerImageName;
    private final boolean degradeWhenServerInitializationFails;
    private final boolean abortOnFirstFailure;
    private final Class<? extends Throwable> expected;
    private final Class<? extends FilibusterFaultInjectionFilter> faultInjectionFilter;
    private final FilibusterLatencyProfile latencyProfile;
    private final String testName;
    private final String className;
    private final List<ServiceProfile> serviceProfiles;
    private final ServiceProfileBehavior serviceProfileBehavior;
    private final boolean failIfFaultNotInjected;
    private final boolean failIfFaultInjectionMismatch;
    private final boolean failIfFaultNotInjectedAndATrackedMethodIsInvoked;

    public static FilibusterServerBackend backendToBackendClass(Class<? extends FilibusterServerBackend> clazz) {
        FilibusterServerBackend serverBackend;
        try {
            serverBackend = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FilibusterUnsupportedServerBackendException("Backend " + clazz + " is not supported.", e);
        }
        return serverBackend;
    }

    private FilibusterConfiguration(Builder builder) {
        this.abortOnFirstFailure = builder.abortOnFirstFailure;
        this.dynamicReduction = builder.dynamicReduction;
        this.suppressCombinations = builder.suppressCombinations;
        this.dataNondeterminism = builder.dataNondeterminism;
        this.avoidRedundantInjections = builder.avoidRedundantInjections;
        this.avoidInjectionsOnOrganicFailures = builder.avoidInjectionsOnOrganicFailures;
        this.failOnOrganicFailures = builder.failOnOrganicFailures;
        this.searchStrategy = builder.searchStrategy;
        this.analysisFile = builder.analysisFile;
        this.serverBackend = builder.serverBackend;
        this.dockerImageName = builder.dockerImageName;
        this.degradeWhenServerInitializationFails = builder.degradeWhenServerInitializationFails;
        this.expected = builder.expected;
        this.faultInjectionFilter = builder.faultInjectionFilter;
        this.latencyProfile = builder.latencyProfile;
        this.testName = builder.testName;
        this.serviceProfiles = builder.serviceProfiles;
        this.serviceProfileBehavior = builder.serviceProfileBehavior;
        this.className = builder.className;
        this.failIfFaultNotInjected = builder.failIfFaultNotInjected;
        this.failIfFaultInjectionMismatch = builder.failIfFaultInjectionMismatch;
        this.failIfFaultNotInjectedAndATrackedMethodIsInvoked = builder.failIfFaultNotInjectedAndATrackedMethodIsInvoked;
    }

    public FilibusterServerBackend getServerBackend() {
        return this.serverBackend;
    }

    public Class<? extends Throwable> getExpected() {
        return this.expected;
    }

    public Class<? extends FilibusterFaultInjectionFilter> getFaultInjectionFilter() {
        return this.faultInjectionFilter;
    }

    public String getDockerImageName() {
        return this.dockerImageName;
    }

    public boolean getDataNondeterminism() {
        return this.dataNondeterminism;
    }

    public boolean getAvoidRedundantInjections() {
        return this.avoidRedundantInjections;
    }

    public boolean getAvoidInjectionsOnOrganicFailures() {
        return this.avoidInjectionsOnOrganicFailures;
    }

    public boolean getFailOnOrganicFailures() {
        return this.failOnOrganicFailures;
    }

    public boolean getDynamicReduction() {
        return this.dynamicReduction;
    }

    public boolean getAbortOnFirstFailure() {
        return this.abortOnFirstFailure;
    }

    public boolean getSuppressCombinations() {
        return this.suppressCombinations;
    }

    public FilibusterSearchStrategy getSearchStrategy() {
        return this.searchStrategy;
    }

    public FilibusterLatencyProfile getLatencyProfile() {
        return this.latencyProfile;
    }

    public String getTestName() {
        return this.testName;
    }

    public List<ServiceProfile> getServiceProfiles() {
        return this.serviceProfiles;
    }

    public boolean getFailIfFaultNotInjected() {
        return this.failIfFaultNotInjected;
    }

    public boolean getFailIfFaultInjectionMismatch() {
        return this.failIfFaultInjectionMismatch;
    }

    public boolean getFailIfFaultNotInjectedAndATrackedMethodIsInvoked() {
        return this.failIfFaultNotInjectedAndATrackedMethodIsInvoked;
    }

    public ServiceProfileBehavior getServiceProfileBehavior() {
        return this.serviceProfileBehavior;
    }

    public boolean getDegradeWhenServerInitializationFails() {
        return this.degradeWhenServerInitializationFails;
    }

    public JSONObject readAnalysisFile() throws IOException {
        if (this.analysisFile != null) {
            File f = new File(this.analysisFile);
            if (f.exists()) {
                InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);
                String jsonTxt = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
                return new JSONObject(jsonTxt);
            }
            return new JSONObject();
        }
        return new JSONObject();
    }

    public List<String> toExecutableCommand() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(filibusterExecutable);
        commands.add("--server-only");
        if (!this.dynamicReduction) {
            commands.add("--disable-dynamic-reduction");
        }
        if (this.suppressCombinations) {
            commands.add("--should-suppress-combinations");
        }
        return commands;
    }

    public String getClassName() {
        return this.className;
    }

    public static class Builder {
        private boolean dynamicReduction = false;
        private boolean suppressCombinations = false;
        private boolean dataNondeterminism = false;
        private boolean avoidRedundantInjections = false;
        private boolean avoidInjectionsOnOrganicFailures = false;
        private boolean failOnOrganicFailures = false;
        private boolean abortOnFirstFailure = false;
        private FilibusterSearchStrategy searchStrategy;
        private String analysisFile;
        private FilibusterServerBackend serverBackend = new FilibusterDockerServerBackend();
        private String dockerImageName;
        private boolean degradeWhenServerInitializationFails = false;
        private Class<? extends Throwable> expected;
        private Class<? extends FilibusterFaultInjectionFilter> faultInjectionFilter;
        private FilibusterLatencyProfile latencyProfile;
        private String testName;
        private String className;
        private List<ServiceProfile> serviceProfiles;
        private ServiceProfileBehavior serviceProfileBehavior;
        private boolean failIfFaultInjectionMismatch;
        private boolean failIfFaultNotInjected;
        private boolean failIfFaultNotInjectedAndATrackedMethodIsInvoked;

        @CanIgnoreReturnValue
        public Builder dynamicReduction(boolean dynamicReduction) {
            this.dynamicReduction = dynamicReduction;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder suppressCombinations(boolean suppressCombinations) {
            this.suppressCombinations = suppressCombinations;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder abortOnFirstFailure(boolean abortOnFirstFailure) {
            this.abortOnFirstFailure = abortOnFirstFailure;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dataNondeterminism(boolean dataNondeterminism) {
            this.dataNondeterminism = dataNondeterminism;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avoidRedundantInjections(boolean avoidRedundantInjections) {
            this.avoidRedundantInjections = avoidRedundantInjections;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder failOnOrganicFailures(boolean failOnOrganicFailures) {
            this.failOnOrganicFailures = failOnOrganicFailures;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avoidInjectionsOnOrganicFailures(boolean avoidInjectionsOnOrganicFailures) {
            this.avoidInjectionsOnOrganicFailures = avoidInjectionsOnOrganicFailures;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder analysisFile(String analysisFile) {
            this.analysisFile = analysisFile;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder serverBackend(Class<? extends FilibusterServerBackend> clazz) {
            this.serverBackend = FilibusterConfiguration.backendToBackendClass(clazz);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder expected(Class<? extends Throwable> clazz) {
            this.expected = clazz;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder faultInjectionFilter(Class<? extends FilibusterFaultInjectionFilter> clazz) {
            this.faultInjectionFilter = clazz;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dockerImageName(String dockerImageName) {
            this.dockerImageName = dockerImageName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder degradeWhenServerInitializationFails(boolean degradeWhenServerInitializationFails) {
            this.degradeWhenServerInitializationFails = degradeWhenServerInitializationFails;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder searchStrategy(FilibusterSearchStrategy searchStrategy) {
            this.searchStrategy = searchStrategy;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder testName(String testName) {
            this.testName = testName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder latencyProfile(Class<? extends FilibusterLatencyProfile> clazz) {
            FilibusterLatencyProfile latencyProfile;
            try {
                latencyProfile = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FilibusterUnsupportedServerBackendException("Backend " + clazz + " is not supported.", e);
            }
            this.latencyProfile = latencyProfile;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder serviceProfilesPath(String serviceProfilesPath) {
            if (!serviceProfilesPath.isEmpty()) {
                Path path = Path.of(serviceProfilesPath, new String[0]);
                List<ServiceProfile> serviceProfiles = ServiceProfile.loadFromDirectory(path);
                this.serviceProfiles = serviceProfiles;
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder serviceProfileBehavior(ServiceProfileBehavior serviceProfileBehavior) {
            this.serviceProfileBehavior = serviceProfileBehavior;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder className(String className) {
            this.className = className;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder failIfFaultNotInjected(boolean failIfFaultNotInjected) {
            this.failIfFaultNotInjected = failIfFaultNotInjected;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder failIfFaultInjectionMismatch(boolean failIfFaultInjectionMismatch) {
            this.failIfFaultInjectionMismatch = failIfFaultInjectionMismatch;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder failIfFaultNotInjectedAndATrackedMethodIsInvoked(boolean failIfFaultNotInjectedAndATrackedMethodIsInvoked) {
            this.failIfFaultNotInjectedAndATrackedMethodIsInvoked = failIfFaultNotInjectedAndATrackedMethodIsInvoked;
            return this;
        }

        public FilibusterConfiguration build() {
            return new FilibusterConfiguration(this);
        }
    }
}

