/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.configuration;

import cloud.filibuster.junit.configuration.FilibusterAnalysisConfiguration;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class FilibusterCustomAnalysisConfigurationFile {
    private static final Logger logger = Logger.getLogger(FilibusterCustomAnalysisConfigurationFile.class.getName());
    private final JSONObject analysisConfigurationFile = new JSONObject();
    private final List<FilibusterAnalysisConfiguration> filibusterAnalysisConfigurations = new ArrayList<FilibusterAnalysisConfiguration>();

    public List<FilibusterAnalysisConfiguration> getFilibusterAnalysisConfigurations() {
        return this.filibusterAnalysisConfigurations;
    }

    public FilibusterCustomAnalysisConfigurationFile(Builder builder) {
        for (FilibusterAnalysisConfiguration analysisConfiguration : builder.analysisConfigurations) {
            Map.Entry<String, JSONObject> entry = analysisConfiguration.toJsonPair();
            this.analysisConfigurationFile.put(entry.getKey(), (Object)entry.getValue());
            this.filibusterAnalysisConfigurations.add(analysisConfiguration);
        }
    }

    public JSONObject toJsonObject() {
        return this.analysisConfigurationFile;
    }

    public String toString() {
        return this.analysisConfigurationFile.toString();
    }

    public boolean writeToDisk(String filePath) {
        try {
            FileWriter fw = new FileWriter(filePath);
            fw.write(this.analysisConfigurationFile.toString(4));
            fw.close();
            return true;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "couldn't write analysis file!");
            return false;
        }
    }

    public Path writeToDisk() throws IOException {
        File f = File.createTempFile("filibuster-analysis", null);
        FileWriter fw = new FileWriter(f);
        fw.write(this.analysisConfigurationFile.toString());
        fw.close();
        return f.toPath();
    }

    public static class Builder {
        private final List<FilibusterAnalysisConfiguration> analysisConfigurations = new ArrayList<FilibusterAnalysisConfiguration>();

        @CanIgnoreReturnValue
        public Builder analysisConfiguration(FilibusterAnalysisConfiguration analysisConfiguration) {
            this.analysisConfigurations.add(analysisConfiguration);
            return this;
        }

        public FilibusterCustomAnalysisConfigurationFile build() {
            return new FilibusterCustomAnalysisConfigurationFile(this);
        }
    }
}

