/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.configuration.examples;

import cloud.filibuster.RpcType;
import cloud.filibuster.junit.configuration.FilibusterAnalysisConfiguration;
import cloud.filibuster.junit.configuration.FilibusterAnalysisConfigurationFile;
import cloud.filibuster.junit.configuration.FilibusterCustomAnalysisConfigurationFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilibusterSingleFaultUnimplementedAnalysisConfigurationFile
implements FilibusterAnalysisConfigurationFile {
    private static final List<String> exhaustiveGrpcErrorCodeList = new ArrayList<String>();
    private static final FilibusterCustomAnalysisConfigurationFile filibusterCustomAnalysisConfigurationFile;

    private static Map<String, String> createGrpcErrorMap(String code) {
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("cause", "");
        myMap.put("code", code);
        return myMap;
    }

    @Override
    public FilibusterCustomAnalysisConfigurationFile toFilibusterCustomAnalysisConfigurationFile() {
        return filibusterCustomAnalysisConfigurationFile;
    }

    static {
        FilibusterCustomAnalysisConfigurationFile.Builder filibusterCustomAnalysisConfigurationFileBuilder = new FilibusterCustomAnalysisConfigurationFile.Builder();
        exhaustiveGrpcErrorCodeList.add("UNIMPLEMENTED");
        FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilderGrpcExceptions = new FilibusterAnalysisConfiguration.Builder().name("java.grpc.exceptions").pattern("(.*/.*)").rpcType(RpcType.GRPC);
        for (String code : exhaustiveGrpcErrorCodeList) {
            filibusterAnalysisConfigurationBuilderGrpcExceptions.exception("io.grpc.StatusRuntimeException", FilibusterSingleFaultUnimplementedAnalysisConfigurationFile.createGrpcErrorMap(code));
        }
        filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfigurationBuilderGrpcExceptions.build());
        filibusterCustomAnalysisConfigurationFile = filibusterCustomAnalysisConfigurationFileBuilder.build();
    }
}

