/*
 * Decompiled with CFR 0.152.
 */
package cloud.filibuster.junit.configuration.examples;

import cloud.filibuster.RpcType;
import cloud.filibuster.junit.configuration.FilibusterAnalysisConfiguration;
import cloud.filibuster.junit.configuration.FilibusterAnalysisConfigurationFile;
import cloud.filibuster.junit.configuration.FilibusterCustomAnalysisConfigurationFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class FilibusterWorldExtendedDefaultAnalysisConfigurationFile
implements FilibusterAnalysisConfigurationFile {
    private static final List<String> exhaustiveGrpcErrorCodeList = new ArrayList<String>();
    private static final FilibusterCustomAnalysisConfigurationFile filibusterCustomAnalysisConfigurationFile;

    private static Map<String, String> createGrpcErrorMap(String code) {
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("cause", "");
        myMap.put("code", code);
        return myMap;
    }

    private static Map<String, String> createHttpErrorMap(String cause) {
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("cause", cause);
        myMap.put("code", "");
        return myMap;
    }

    @Override
    public FilibusterCustomAnalysisConfigurationFile toFilibusterCustomAnalysisConfigurationFile() {
        return filibusterCustomAnalysisConfigurationFile;
    }

    static {
        FilibusterCustomAnalysisConfigurationFile.Builder filibusterCustomAnalysisConfigurationFileBuilder = new FilibusterCustomAnalysisConfigurationFile.Builder();
        exhaustiveGrpcErrorCodeList.add("DEADLINE_EXCEEDED");
        exhaustiveGrpcErrorCodeList.add("UNAVAILABLE");
        FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilderGrpcExceptions = new FilibusterAnalysisConfiguration.Builder().name("java.grpc.exceptions").pattern("(.*/.*)").rpcType(RpcType.GRPC);
        for (String code : exhaustiveGrpcErrorCodeList) {
            filibusterAnalysisConfigurationBuilderGrpcExceptions.exception("io.grpc.StatusRuntimeException", FilibusterWorldExtendedDefaultAnalysisConfigurationFile.createGrpcErrorMap(code));
        }
        filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfigurationBuilderGrpcExceptions.build());
        FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilderGrpcErrors = new FilibusterAnalysisConfiguration.Builder().name("java.grpc.errors").pattern("(.*/.*)");
        ArrayList<String> grpcErrorCodes = new ArrayList<String>();
        grpcErrorCodes.add("UNIMPLEMENTED");
        grpcErrorCodes.add("INTERNAL");
        ArrayList<JSONObject> grpcErrorTypes = new ArrayList<JSONObject>();
        for (String errorCode : grpcErrorCodes) {
            JSONObject codeObject = new JSONObject();
            codeObject.put("code", (Object)errorCode);
            JSONObject metadataObject = new JSONObject();
            metadataObject.put("metadata", (Object)codeObject);
            JSONObject exceptionObject = new JSONObject();
            exceptionObject.put("exception", (Object)metadataObject);
            grpcErrorTypes.add(exceptionObject);
        }
        filibusterAnalysisConfigurationBuilderGrpcErrors.error(".*", grpcErrorTypes);
        filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfigurationBuilderGrpcErrors.build());
        FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilderHttpExceptions = new FilibusterAnalysisConfiguration.Builder().name("java.WebClient.exceptions").pattern("WebClient\\.(GET|PUT|POST|HEAD)");
        filibusterAnalysisConfigurationBuilderHttpExceptions.exception("com.linecorp.armeria.client.UnprocessedRequestException", FilibusterWorldExtendedDefaultAnalysisConfigurationFile.createHttpErrorMap("io.netty.channel.ConnectTimeoutException"));
        filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfigurationBuilderHttpExceptions.build());
        FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilderHttpErrors = new FilibusterAnalysisConfiguration.Builder().name("java.WebClient.errors").pattern("WebClient\\.(GET|PUT|POST|HEAD)");
        ArrayList<String> httpErrorCodes = new ArrayList<String>();
        httpErrorCodes.add("500");
        httpErrorCodes.add("502");
        httpErrorCodes.add("503");
        ArrayList<JSONObject> webClientErrorTypes = new ArrayList<JSONObject>();
        for (String errorCode : httpErrorCodes) {
            JSONObject statusCodeObject = new JSONObject();
            statusCodeObject.put("status_code", (Object)errorCode);
            JSONObject returnValueObject = new JSONObject();
            returnValueObject.put("return_value", (Object)statusCodeObject);
            webClientErrorTypes.add(returnValueObject);
        }
        filibusterAnalysisConfigurationBuilderHttpErrors.error(".*", webClientErrorTypes);
        filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfigurationBuilderHttpErrors.build());
        FilibusterAnalysisConfiguration.Builder filibusterAnalysisConfigurationBuilderHttpErrorsForWorld = new FilibusterAnalysisConfiguration.Builder().name("java.WebClient.world.errors").pattern("WebClient\\.(GET|PUT|POST|HEAD)");
        ArrayList<String> worldHttpErrorCodes = new ArrayList<String>();
        worldHttpErrorCodes.add("404");
        ArrayList<JSONObject> worldWebClientErrorTypes = new ArrayList<JSONObject>();
        for (String errorCode : worldHttpErrorCodes) {
            JSONObject statusCodeObject = new JSONObject();
            statusCodeObject.put("status_code", (Object)errorCode);
            JSONObject returnValueObject = new JSONObject();
            returnValueObject.put("return_value", (Object)statusCodeObject);
            worldWebClientErrorTypes.add(returnValueObject);
        }
        filibusterAnalysisConfigurationBuilderHttpErrorsForWorld.error("world", worldWebClientErrorTypes);
        filibusterCustomAnalysisConfigurationFileBuilder.analysisConfiguration(filibusterAnalysisConfigurationBuilderHttpErrorsForWorld.build());
        filibusterCustomAnalysisConfigurationFile = filibusterCustomAnalysisConfigurationFileBuilder.build();
    }
}

